/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class SceneInteraction
extends Interaction {
    private final ScreenView myScreenView;

    public SceneInteraction(@NotNull ScreenView screenView) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/scene/SceneInteraction", "<init>"));
        }
        this.myScreenView = screenView;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        super.begin(x, y, startMask);
        int androidX = Coordinates.getAndroidX(this.myScreenView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.myScreenView, this.myStartY);
        int dpX = Coordinates.pxToDp(this.myScreenView, androidX);
        int dpY = Coordinates.pxToDp(this.myScreenView, androidY);
        Scene scene = this.myScreenView.getScene();
        scene.updateModifiers(startMask);
        scene.mouseDown(SceneContext.get(this.myScreenView), dpX, dpY);
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        int dpX = Coordinates.pxToDp(this.myScreenView, androidX);
        int dpY = Coordinates.pxToDp(this.myScreenView, androidY);
        Scene scene = this.myScreenView.getScene();
        scene.updateModifiers(modifiers);
        scene.mouseDrag(SceneContext.get(this.myScreenView), dpX, dpY);
        this.myScreenView.getSurface().repaint();
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        int dpX = Coordinates.pxToDp(this.myScreenView, androidX);
        int dpY = Coordinates.pxToDp(this.myScreenView, androidY);
        Scene scene = this.myScreenView.getScene();
        scene.updateModifiers(modifiers);
        scene.mouseRelease(SceneContext.get(this.myScreenView), dpX, dpY);
        this.myScreenView.getSurface().repaint();
    }
}

