/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.draw.Notch;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutNotchProvider
implements Notch.Provider {
    protected static final ArrayList<String> ourLeftAttributes = new ArrayList();
    protected static final ArrayList<String> ourTopAttributes;
    protected static final ArrayList<String> ourRightAttributes;
    protected static final ArrayList<String> ourBottomAttributes;

    private boolean hasAttributes(@NotNull AttributesTransaction transaction, String uri, ArrayList<String> attributes) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasAttributes"));
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasLeft(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasLeft"));
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private boolean hasTop(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasTop"));
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private boolean hasRight(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasRight"));
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private boolean hasBottom(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasBottom"));
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private boolean hasBaseline(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "hasBaseline"));
        }
        return transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    @Override
    public void fill(@NotNull SceneComponent component, @NotNull SceneComponent target, @NotNull ArrayList<Notch> horizontalNotches, @NotNull ArrayList<Notch> verticalNotches) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "fill"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "fill"));
        }
        if (horizontalNotches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "horizontalNotches", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "fill"));
        }
        if (verticalNotches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verticalNotches", "com/android/tools/idea/uibuilder/scene/draw/ConstraintLayoutNotchProvider", "fill"));
        }
        int x1 = component.getDrawX();
        int x2 = x1 + component.getDrawWidth();
        int midX = x1 + (x2 - x1) / 2 - target.getDrawWidth() / 2;
        horizontalNotches.add(new Notch.Horizontal(component, midX, x1 + (x2 - x1) / 2, attributes -> {
            if (this.hasLeft(attributes) || this.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
        }));
        horizontalNotches.add(new Notch.Horizontal(component, x1 + 16, x1 + 16, attributes -> {
            if (this.hasLeft(attributes) || this.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", String.format("%ddp", 16));
        }));
        horizontalNotches.add(new Notch.Horizontal(component, x2 - target.getDrawWidth() - 16, x2 - 16, attributes -> {
            if (this.hasLeft(attributes) || this.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", String.format("%ddp", 16));
        }));
        int y1 = component.getDrawY();
        int y2 = y1 + component.getDrawHeight();
        int midY = y1 + (y2 - y1) / 2 - target.getDrawHeight() / 2;
        verticalNotches.add(new Notch.Vertical(component, midY, y1 + (y2 - y1) / 2, attributes -> {
            if (this.hasTop(attributes) || this.hasBottom(attributes) || this.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        }));
        verticalNotches.add(new Notch.Vertical(component, y1 + 16, y1 + 16, attributes -> {
            if (this.hasTop(attributes) || this.hasBottom(attributes) || this.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", String.format("%ddp", 16));
        }));
        verticalNotches.add(new Notch.Vertical(component, y2 - target.getDrawHeight() - 16, y2 - 16, attributes -> {
            if (this.hasTop(attributes) || this.hasBottom(attributes) || this.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", String.format("%ddp", 16));
        }));
    }

    static {
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
    }
}

