/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final DesignSurface mySurface;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "<init>"));
        }
        this.mySurface = surface;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "performCopy"));
        }
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents(screenView.getModel().getSelectionAsTransferable());
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isCopyEnabled"));
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isCopyVisible"));
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "performCut"));
        }
        this.performCopy(dataContext);
        this.deleteElement(dataContext);
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isCutEnabled"));
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isCutVisible"));
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "deleteElement"));
        }
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlModel model = screenView.getModel();
        model.delete(selectionModel.getSelection());
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "canDeleteElement"));
        }
        return this.hasNonEmptySelection();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "performPaste"));
        }
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isPastePossible"));
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/surface/DesignSurfaceActionHandler", "isPasteEnabled"));
        }
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        return screenView != null && !screenView.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        NlComponent before;
        List<NlComponent> components;
        NlComponent receiver;
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return false;
        }
        List<NlComponent> selection = screenView.getSelectionModel().getSelection();
        NlComponent nlComponent = receiver = !selection.isEmpty() ? selection.get(0) : null;
        if (receiver == null && (components = screenView.getModel().getComponents()).size() == 1) {
            receiver = components.get(0);
        }
        if (receiver == null) {
            return false;
        }
        NlModel model = screenView.getModel();
        ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getProject());
        ViewHandler handler = handlerManager.getHandler(receiver);
        if (handler instanceof ViewGroupHandler) {
            before = receiver.getChild(0);
        } else {
            before = receiver.getNextSibling();
            if ((receiver = receiver.getParent()) == null) {
                return false;
            }
        }
        DnDTransferItem item = DesignSurfaceActionHandler.getClipboardData();
        if (item == null) {
            return false;
        }
        InsertType insertType = model.determineInsertType(DragType.PASTE, item, checkOnly);
        List<NlComponent> pasted = model.createComponents(screenView, item, insertType);
        if (!model.canAddComponents(pasted, receiver, before)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        model.addComponents(pasted, receiver, before, insertType);
        return true;
    }

    @Nullable
    private static DnDTransferItem getClipboardData() {
        try {
            Object data = CopyPasteManager.getInstance().getContents(ItemTransferable.DESIGNER_FLAVOR);
            if (!(data instanceof DnDTransferItem)) {
                return null;
            }
            return (DnDTransferItem)data;
        }
        catch (Exception e) {
            return null;
        }
    }
}

