/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.api.ConstantSourceProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepositorySourceProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.SdkComponentSource;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkUpdaterPlugin
implements ApplicationComponent {
    public void initComponent() {
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            ExternalComponentManager.getInstance().registerComponentSource((ExternalComponentSource)new SdkComponentSource());
            URL offlineRepo = AndroidSdkUpdaterPlugin.getOfflineRepoDir();
            if (offlineRepo != null) {
                ConstantSourceProvider provider = new ConstantSourceProvider(offlineRepo.toString(), "Offline Repo", (Collection)AndroidSdkHandler.getAllModules());
                AndroidSdkHandler.addCustomSourceProvider((RepositorySourceProvider)provider, (ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
            }
        }
    }

    @Nullable
    private static URL getOfflineRepoDir() {
        Path path = Paths.get(PathManager.getPreInstalledPluginsPath(), "sdk-updates", "offline-repo", "offline-repo.xml");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("Android Sdk Updater" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/AndroidSdkUpdaterPlugin", "getComponentName"));
        }
        return "Android Sdk Updater";
    }
}

