/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.adapters.AdapterProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.updater.configure.CheckboxClickListener;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.PlatformComponentsPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.ToolComponentsPanel;
import com.android.tools.idea.updater.configure.UpdateSitesPanel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.CausedFocusEvent;

public class SdkUpdaterConfigPanel
implements Disposable {
    private JPanel myRootPane;
    private JTextField mySdkLocationTextField;
    private JComboBox<File> mySdkLocationChooser;
    private JBLabel mySdkLocationLabel;
    private JPanel mySdkLocationPanel;
    private HyperlinkLabel myEditSdkLink;
    private JBLabel mySdkErrorLabel;
    private PlatformComponentsPanel myPlatformComponentsPanel;
    private ToolComponentsPanel myToolComponentsPanel;
    private UpdateSitesPanel myUpdateSitesPanel;
    private HyperlinkLabel myChannelLink;
    private JBTabbedPane myTabPane;
    private final Downloader myDownloader;
    private final SettingsController mySettings;
    private final SdkUpdaterConfigurable myConfigurable;
    private final OptionalValueProperty<File> mySelectedSdkLocation;
    private final BindingsManager myBindingsManager;
    private final RepoManager.RepoLoadedCallback myLocalUpdater;
    private final RepoManager.RepoLoadedCallback myRemoteUpdater;

    public SdkUpdaterConfigPanel(final @NotNull Runnable channelChangedCallback, @Nullable Downloader downloader, @Nullable SettingsController settings, @NotNull SdkUpdaterConfigurable configurable) {
        if (channelChangedCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelChangedCallback", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.mySelectedSdkLocation = new OptionalValueProperty();
        this.myBindingsManager = new BindingsManager();
        this.myLocalUpdater = packages -> ApplicationManager.getApplication().invokeLater(() -> this.loadPackages(packages), ModalityState.any());
        this.myRemoteUpdater = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$1", "doRun"));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (packages == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$1", "lambda$doRun$0"));
                    }
                    SdkUpdaterConfigPanel.this.loadPackages(packages);
                    SdkUpdaterConfigPanel.this.myPlatformComponentsPanel.finishLoading();
                    SdkUpdaterConfigPanel.this.myToolComponentsPanel.finishLoading();
                }, ModalityState.any());
            }
        };
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SDK_MANAGER).setKind(AndroidStudioEvent.EventKind.SDK_MANAGER_LOADED));
        this.myConfigurable = configurable;
        this.myUpdateSitesPanel.setConfigurable(configurable);
        this.myDownloader = downloader;
        this.mySettings = settings;
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        this.mySelectedSdkLocation.set((File)((Object)sdkLocations.stream().findFirst()));
        this.mySelectedSdkLocation.addListener(sender -> ApplicationManager.getApplication().invokeLater(this::reset));
        ((CardLayout)this.mySdkLocationPanel.getLayout()).show(this.mySdkLocationPanel, "SingleSdk");
        this.setUpSingleSdkChooser();
        this.myBindingsManager.bindTwoWay(this.mySelectedSdkLocation, new AdapterProperty<String, Optional<File>>((AbstractProperty)new TextProperty(this.mySdkLocationTextField), (Optional)this.mySelectedSdkLocation.get()){

            @Override
            @Nullable
            protected Optional<File> convertFromSourceType(@NotNull String value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$2", "convertFromSourceType"));
                }
                if (value.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new File(value));
            }

            @Override
            @NotNull
            protected String convertFromDestType(@NotNull Optional<File> value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$2", "convertFromDestType"));
                }
                String string = value.isPresent() ? value.get().getPath() : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$2", "convertFromDestType"));
                }
                return string;
            }
        });
        this.myChannelLink.setHyperlinkText("Preview packages available! ", "Switch", " to Preview Channel to see them");
        this.myChannelLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                UpdateSettingsConfigurable settings = new UpdateSettingsConfigurable(false);
                ShowSettingsUtil.getInstance().editConfigurable((Component)SdkUpdaterConfigPanel.this.getComponent(), (Configurable)settings);
                channelChangedCallback.run();
            }
        });
        this.myToolComponentsPanel.setConfigurable(this.myConfigurable);
        this.myPlatformComponentsPanel.setConfigurable(this.myConfigurable);
    }

    @Nullable
    File getSelectedSdkLocation() {
        return ((Optional)this.mySelectedSdkLocation.get()).orElse(null);
    }

    @NotNull
    private static Collection<File> getSdkLocations() {
        File androidHome = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidHome != null) {
            ImmutableList immutableList = ImmutableList.of((Object)androidHome);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel", "getSdkLocations"));
            }
            return immutableList;
        }
        HashSet locations = new HashSet();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            try {
                LocalProperties localProperties = new LocalProperties(project);
                File androidSdkPath = localProperties.getAndroidSdkPath();
                if (androidSdkPath != null) {
                    locations.add(androidSdkPath);
                    continue;
                }
            }
            catch (IOException ignored) {
                Logger.getInstance(SdkUpdaterConfigPanel.class).info("Unable to read local.properties file from project: " + project.getName(), (Throwable)ignored);
            }
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            for (AndroidFacet facet : facets) {
                AndroidSdkData sdkData = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidSdk();
                if (sdkData == null) continue;
                locations.add(sdkData.getLocation());
            }
        }
        HashSet hashSet = locations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel", "getSdkLocations"));
        }
        return hashSet;
    }

    private void setUpSingleSdkChooser() {
        this.myEditSdkLink.setHyperlinkText("Edit");
        this.myEditSdkLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                DialogWrapperHost host = new DialogWrapperHost(null);
                DynamicWizard wizard = new DynamicWizard(null, null, "SDK Setup", host){

                    @Override
                    public void init() {
                        DownloadingComponentsStep progressStep = new DownloadingComponentsStep(this.myHost.getDisposable(), this.myHost);
                        String sdkPath = SdkUpdaterConfigPanel.this.mySdkLocationTextField.getText();
                        File location = StringUtil.isEmpty((String)sdkPath) ? FirstRunWizardDefaults.getInitialSdkLocation(FirstRunWizardMode.MISSING_SDK) : new File(sdkPath);
                        InstallComponentsPath path = new InstallComponentsPath(FirstRunWizardMode.MISSING_SDK, location, progressStep, false);
                        progressStep.setInstallComponentsPath(path);
                        this.addPath(path);
                        this.addPath(new SingleStepPath(progressStep));
                        super.init();
                    }

                    @Override
                    public void performFinishingActions() {
                        File sdkLocation = IdeSdks.getInstance().getAndroidSdkPath();
                        if (sdkLocation == null) {
                            return;
                        }
                        String stateSdkLocationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
                        assert (stateSdkLocationPath != null);
                        File stateSdkLocation = new File(stateSdkLocationPath);
                        if (!FileUtil.filesEqual((File)sdkLocation, (File)stateSdkLocation)) {
                            SdkUpdaterConfigPanel.setAndroidSdkLocation(stateSdkLocation);
                            sdkLocation = stateSdkLocation;
                        }
                        SdkUpdaterConfigPanel.this.mySelectedSdkLocation.setValue(sdkLocation);
                    }

                    @Override
                    @NotNull
                    protected String getProgressTitle() {
                        if ("Setting up SDK..." == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$4$1", "getProgressTitle"));
                        }
                        return "Setting up SDK...";
                    }

                    @Override
                    protected String getWizardActionDescription() {
                        return "Setting up SDK...";
                    }
                };
                wizard.init();
                wizard.show();
            }
        });
        this.mySdkLocationTextField.setEditable(false);
    }

    public void dispose() {
        this.myBindingsManager.releaseAll();
    }

    private static void setAndroidSdkLocation(File sdkLocation) {
        ApplicationUtils.invokeWriteActionAndWait(ModalityState.any(), () -> IdeSdks.getInstance().setAndroidSdkPath(sdkLocation, null));
    }

    public JComponent getComponent() {
        return this.myRootPane;
    }

    public boolean isModified() {
        return this.myPlatformComponentsPanel.isModified() || this.myToolComponentsPanel.isModified() || this.myUpdateSitesPanel.isModified();
    }

    static void setTreeTableProperties(TreeTableView tt, UpdaterTreeNode.Renderer renderer, ChangeListener listener) {
        tt.setTreeCellRenderer((TreeCellRenderer)renderer);
        new CheckboxClickListener(tt, renderer).installOn((Component)tt);
        TreeUtil.installActions((JTree)tt.getTree());
        tt.getTree().setToggleClickCount(0);
        tt.getTree().setShowsRootHandles(true);
        SdkUpdaterConfigPanel.setTableProperties((JTable)tt, listener);
    }

    static void setTableProperties(final @NotNull JTable table, final @Nullable ChangeListener listener) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel", "setTableProperties"));
        }
        assert (table instanceof SelectionProvider);
        ActionMap am = table.getActionMap();
        final CycleAction forwardAction = new CycleAction(false);
        final CycleAction backwardAction = new CycleAction(true);
        if (!ScreenReader.isActive()) {
            am.put("selectPreviousColumnCell", backwardAction);
            am.put("selectNextColumnCell", forwardAction);
        }
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    Collection selection = ((SelectionProvider)table).getSelection();
                    for (MultiStateRow node : selection) {
                        node.cycleState();
                        table.repaint();
                        if (listener == null) continue;
                        listener.stateChanged(new ChangeEvent(node));
                    }
                }
            }
        });
        table.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null) {
                    table.getSelectionModel().clearSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTable table2 = (JTable)e.getSource();
                if (table2.getSelectionModel().getMinSelectionIndex() != -1) {
                    return;
                }
                if (e instanceof CausedFocusEvent && ((CausedFocusEvent)e).getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                    backwardAction.doAction(table2);
                } else {
                    forwardAction.doAction(table2);
                }
            }
        });
    }

    protected static void resizeColumnsToFit(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 1; column < table.getColumnCount(); ++column) {
            int width = 50;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    public void refresh() {
        this.validate();
        this.myPlatformComponentsPanel.startLoading();
        this.myToolComponentsPanel.startLoading();
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading SDK", false, projects.length == 0 ? null : projects[0]);
        this.myConfigurable.getRepoManager().load(0L, (List)ImmutableList.of((Object)this.myLocalUpdater), (List)ImmutableList.of((Object)this.myRemoteUpdater), null, (ProgressRunner)progressRunner, this.myDownloader, this.mySettings, false);
    }

    private void validate() {
        File sdkLocation = this.myConfigurable.getRepoManager().getLocalPath();
        String sdkLocationPath = sdkLocation == null ? null : sdkLocation.getAbsolutePath();
        WizardUtils.ValidationResult result = WizardUtils.validateLocation(sdkLocationPath, "Android SDK location", false, WizardUtils.WritableCheckMode.NOT_WRITABLE_IS_WARNING);
        switch (result.getStatus()) {
            case OK: {
                this.mySdkLocationLabel.setForeground(JBColor.foreground());
                this.mySdkErrorLabel.setVisible(false);
                this.myPlatformComponentsPanel.setEnabled(true);
                this.myTabPane.setEnabled(true);
                break;
            }
            case WARN: {
                this.mySdkErrorLabel.setIcon(AllIcons.General.BalloonWarning);
                this.mySdkErrorLabel.setText(result.getFormattedMessage());
                this.mySdkErrorLabel.setVisible(true);
                this.myPlatformComponentsPanel.setEnabled(false);
                this.myTabPane.setEnabled(false);
                break;
            }
            case ERROR: {
                this.mySdkErrorLabel.setIcon(AllIcons.General.BalloonError);
                this.mySdkErrorLabel.setText(result.getFormattedMessage());
                this.mySdkErrorLabel.setVisible(true);
                this.myPlatformComponentsPanel.setEnabled(false);
                this.myTabPane.setEnabled(false);
            }
        }
    }

    private void loadPackages(RepositoryPackages packages) {
        TreeMultimap platformPackages = TreeMultimap.create();
        TreeSet toolsPackages = Sets.newTreeSet();
        for (UpdatablePackage info : packages.getConsolidatedPkgs().values()) {
            RepoPackage p = info.getRepresentative();
            TypeDetails details = p.getTypeDetails();
            if (details instanceof DetailsTypes.ApiDetailsType) {
                platformPackages.put((Object)((DetailsTypes.ApiDetailsType)details).getAndroidVersion(), (Object)info);
                continue;
            }
            toolsPackages.add(info);
        }
        this.myPlatformComponentsPanel.setPackages((Multimap<AndroidVersion, UpdatablePackage>)platformPackages);
        this.myToolComponentsPanel.setPackages(toolsPackages);
    }

    public Collection<PackageNodeModel> getStates() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myPlatformComponentsPanel.myStates);
        result.addAll(this.myToolComponentsPanel.myStates);
        return result;
    }

    public void reset() {
        this.refresh();
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        if (SdkUpdaterConfigPanel.getSdkLocations().size() == 1) {
            this.mySdkLocationTextField.setText(sdkLocations.iterator().next().getPath());
        }
        this.myPlatformComponentsPanel.reset();
        this.myToolComponentsPanel.reset();
        this.myUpdateSitesPanel.reset();
    }

    public void saveSources() {
        this.myUpdateSitesPanel.save();
    }

    private void createUIComponents() {
        this.myUpdateSitesPanel = new UpdateSitesPanel(this::refresh);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        ToolComponentsPanel toolComponentsPanel;
        PlatformComponentsPanel platformComponentsPanel;
        JBTabbedPane jBTabbedPane;
        HyperlinkLabel hyperlinkLabel2;
        JTextField jTextField;
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Manager for the Android SDK and Tools used by Android Studio");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 8, 2, 3, 3, null, null, null));
        this.mySdkLocationLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Android SDK Location:");
        jBLabel2.setEnabled(true);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySdkErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("SDK Location must be set");
        jBLabel.setVisible(false);
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySdkLocationPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "SingleSdk");
        this.mySdkLocationTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null));
        this.myEditSdkLink = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "MultiSdk");
        JComboBox jComboBox = new JComboBox();
        this.mySdkLocationChooser = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Platforms", null, jPanel6, null);
        this.myPlatformComponentsPanel = platformComponentsPanel = new PlatformComponentsPanel();
        JComponent jComponent = platformComponentsPanel.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Tools", null, jPanel7, null);
        this.myToolComponentsPanel = toolComponentsPanel = new ToolComponentsPanel();
        JComponent jComponent2 = toolComponentsPanel.$$$getRootComponent$$$();
        jPanel7.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Update Sites", null, jPanel8, null);
        UpdateSitesPanel updateSitesPanel = this.myUpdateSitesPanel;
        JComponent jComponent3 = updateSitesPanel.$$$getRootComponent$$$();
        jPanel8.add((Component)jComponent3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myChannelLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setVisible(false);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }

    public static interface MultiStateRow {
        public void cycleState();
    }

    private static class CycleAction
    extends AbstractAction {
        final boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.doAction((JTable)evt.getSource());
        }

        public void doAction(JTable table) {
            int row;
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ListSelectionModel selectionModel = table.getSelectionModel();
            int n = row = this.myBackward ? selectionModel.getMinSelectionIndex() : selectionModel.getMaxSelectionIndex();
            if (row == -1 && this.myBackward) {
                row = table.getRowCount();
            }
            if ((row += this.myBackward ? -1 : 1) < 0) {
                manager.focusPreviousComponent(table);
            } else if (row >= table.getRowCount()) {
                manager.focusNextComponent(table);
            } else {
                selectionModel.setSelectionInterval(row, row);
                table.setColumnSelectionInterval(1, 1);
                table.scrollRectToVisible(table.getCellRect(row, 1, true));
            }
            table.repaint();
        }
    }

    private static final class DownloadingComponentsStep
    extends ConsolidatedProgressStep {
        private InstallComponentsPath myInstallComponentsPath;

        private DownloadingComponentsStep(@NotNull Disposable disposable, @NotNull DynamicWizardHost host) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$DownloadingComponentsStep", "<init>"));
            }
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/updater/configure/SdkUpdaterConfigPanel$DownloadingComponentsStep", "<init>"));
            }
            super(disposable, host);
        }

        private void setInstallComponentsPath(InstallComponentsPath installComponentsPath) {
            this.setPaths(Collections.singletonList(installComponentsPath));
            this.myInstallComponentsPath = installComponentsPath;
        }

        @Override
        public boolean isStepVisible() {
            return this.myInstallComponentsPath.shouldDownloadingComponentsStepBeShown();
        }
    }
}

