/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import org.jetbrains.annotations.NotNull;

public class StructureUtils {
    private StructureUtils() {
    }

    public static void acceptChildrenInOrder(@NotNull DomElement element, @NotNull DomElementVisitor visitor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/StructureUtils", "acceptChildrenInOrder"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/android/dom/structure/StructureUtils", "acceptChildrenInOrder"));
        }
        XmlTag tag = element.getXmlTag();
        for (XmlTag xmlTag : tag.getSubTags()) {
            DomElement child = element.getManager().getDomElement(xmlTag);
            if (child == null) {
                return;
            }
            child.accept(visitor);
        }
    }
}

