/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import javax.swing.JComponent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurableForm;
import org.jetbrains.annotations.NotNull;

public class AndroidSdkConfigurable
implements AdditionalDataConfigurable {
    private final AndroidSdkConfigurableForm myForm;
    private Sdk mySdk;
    private final SdkModel.Listener myListener;
    private final SdkModel mySdkModel;

    public AndroidSdkConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "org/jetbrains/android/sdk/AndroidSdkConfigurable", "<init>"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "org/jetbrains/android/sdk/AndroidSdkConfigurable", "<init>"));
        }
        this.mySdkModel = sdkModel;
        this.myForm = new AndroidSdkConfigurableForm(sdkModel, sdkModificator);
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.updateJdks(sdk, previousName);
                }
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                if (sdk != null && AndroidSdks.getInstance().isAndroidSdk(sdk)) {
                    AndroidSdkConfigurable.this.myForm.internalJdkUpdate(sdk);
                }
            }
        };
        this.mySdkModel.addListener(this.myListener);
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public JComponent createComponent() {
        return this.myForm.getContentPanel();
    }

    public boolean isModified() {
        AndroidSdkAdditionalData data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(this.mySdk);
        Sdk javaSdk = data != null ? data.getJavaSdk() : null;
        String javaSdkHomePath = javaSdk != null ? javaSdk.getHomePath() : null;
        Sdk selectedSdk = this.myForm.getSelectedSdk();
        String selectedSdkHomePath = selectedSdk != null ? selectedSdk.getHomePath() : null;
        return !FileUtil.pathsEqual((String)javaSdkHomePath, (String)selectedSdkHomePath);
    }

    public void apply() throws ConfigurationException {
        Sdk javaSdk = this.myForm.getSelectedSdk();
        AndroidSdkAdditionalData newData = new AndroidSdkAdditionalData(this.mySdk, javaSdk);
        newData.setBuildTarget(this.myForm.getSelectedBuildTarget());
        SdkModificator modificator = this.mySdk.getSdkModificator();
        modificator.setVersionString(javaSdk != null ? javaSdk.getVersionString() : null);
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)modificator).commitChanges());
    }

    public void reset() {
        if (this.mySdk == null) {
            return;
        }
        AndroidSdkAdditionalData data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(this.mySdk);
        if (data == null) {
            return;
        }
        AndroidPlatform platform = data.getAndroidPlatform();
        this.myForm.init(data.getJavaSdk(), this.mySdk, platform != null ? data.getBuildTarget(platform.getSdkData()) : null);
    }

    public void disposeUIResources() {
        this.mySdkModel.removeListener(this.myListener);
    }
}

