/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakHashMap;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private final LayoutLibrary myLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static WeakHashMap<Module, ModuleClassLoader> ourCache = new WeakHashMap();

    private ModuleClassLoader(@NotNull LayoutLibrary library, @NotNull Module module) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/uipreview/ModuleClassLoader", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ModuleClassLoader", "<init>"));
        }
        super(library.getClassLoader(), library.getApiLevel());
        this.myLibrary = library;
        this.myModuleReference = new WeakReference<Module>(module);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        block15: {
            block14: {
                if (ModuleClassLoader.LOG.isDebugEnabled()) {
                    ModuleClassLoader.LOG.debug(String.format("findClass(%s)", new Object[]{name}));
                }
                try {
                    if (this.myInsideJarClassLoader || (module = (Module)this.myModuleReference.get()) == null || (index = name.lastIndexOf(46)) == -1 || name.charAt(index + 1) != 'R' || index != name.length() - 2 && name.charAt(index + 2) != '$' || index <= 1) ** GOTO lbl36
                    appResources = AppResourceRepository.getAppResources(module, false);
                    if (appResources == null) ** GOTO lbl34
                    data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, appResources);
                    if (data == null) break block14;
                    data = this.convertClass(data);
                    if (ModuleClassLoader.LOG.isDebugEnabled()) {
                        ModuleClassLoader.LOG.debug("  Defining class from AAR registry");
                    }
                    v0 = this.defineClassAndPackage(name, data, 0, data.length);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                    if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                        clazz = RecyclerViewHelper.getAdapterClass();
                    }
                    if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                        clazz = RecyclerViewHelper.getViewHolder();
                    }
                    if (clazz != null) {
                        if (ModuleClassLoader.LOG.isDebugEnabled()) {
                            ModuleClassLoader.LOG.debug("  Defining RecyclerView helper class");
                        }
                        v1 = this.defineClassAndPackage(name, clazz, 0, clazz.length);
                        if (v1 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"}));
                        }
                        return v1;
                    }
                    ModuleClassLoader.LOG.debug((Throwable)e);
                    throw e;
                }
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"}));
                }
                return v0;
            }
            break block15;
lbl34:
            // 1 sources

            if (ModuleClassLoader.LOG.isDebugEnabled()) {
                ModuleClassLoader.LOG.debug("  AppResourceRepositoryInstance not found");
            }
        }
        if (ModuleClassLoader.LOG.isDebugEnabled()) {
            ModuleClassLoader.LOG.debug(String.format("  super.findClass(%s)", new Object[]{LogAnonymizerUtil.anonymizeClassName(name)}));
        }
        v2 = super.findClass(name);
        if (v2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"}));
        }
        return v2;
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Module module;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName(name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name, (Set<Module>)new HashSet());
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "load"));
            }
            return clazz;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("  ClassNotFoundException(%s)", LogAnonymizerUtil.anonymizeClassName(name)));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean loadFromProject = name.startsWith("android.support.constraint.solver");
        if (loadFromProject) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                return this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        Class<?> aClass;
        if (!visited.add(module)) {
            return null;
        }
        if (module.isDisposed()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModuleOrDependency(%s, %s)", LogAnonymizerUtil.anonymize(module), LogAnonymizerUtil.anonymizeClassName(name)));
        }
        if ((aClass = this.loadClassFromModule(module, name)) != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        if (module.isDisposed()) {
            return null;
        }
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModule(%s, %s)", LogAnonymizerUtil.anonymize(module), LogAnonymizerUtil.anonymizeClassName(name)));
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        VirtualFile classFile = null;
        if (vOutFolder == null) {
            AndroidModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.requiresAndroidModel() && (androidModel = facet.getAndroidModel()) != null) {
                classFile = androidModel.getClassJarProvider().findModuleClassFile(name, module);
            }
        } else {
            classFile = ClassJarProvider.findClassFileInPath(vOutFolder, name);
        }
        if (classFile != null) {
            return this.loadClassFile(name, classFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Class not found");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(final @NotNull String fqcn, @Nullable Object myCredential) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "org/jetbrains/android/uipreview/ModuleClassLoader", "isSourceModified"));
        }
        final Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(fqcn);
        if (classFile != null) {
            boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
            try {
                VirtualFile virtualFile;
                long classFileModified = classFile.getTimeStamp();
                if (classFileModified > 0L && (virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                    @Nullable
                    public VirtualFile compute() {
                        PsiFile containingFile;
                        Project project = module.getProject();
                        GlobalSearchScope scope = module.getModuleWithDependenciesScope();
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
                        PsiClass source = psiFacade.findClass(fqcn, scope);
                        if (source != null && (containingFile = source.getContainingFile()) != null) {
                            return containingFile.getVirtualFile();
                        }
                        return null;
                    }
                })) != null && !"R.java".equals(virtualFile.getName())) {
                    boolean modified = FileDocumentManager.getInstance().isFileModified(virtualFile);
                    if (!modified) {
                        Long projectBuildTimestamp;
                        File sourceFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                        long sourceFileModified = sourceFile.lastModified();
                        AndroidFacet facet = AndroidFacet.getInstance(module);
                        long lastBuildTimestamp = classFileModified;
                        if (facet != null && facet.requiresAndroidModel() && facet.getAndroidModel() != null && (projectBuildTimestamp = facet.getAndroidModel().getLastBuildTimestamp(module.getProject())) != null) {
                            lastBuildTimestamp = projectBuildTimestamp;
                        }
                        if (sourceFileModified > lastBuildTimestamp && lastBuildTimestamp > 0L) {
                            modified = true;
                        }
                    }
                    boolean bl = modified;
                    return bl;
                }
            }
            finally {
                RenderSecurityManager.exitSafeRegion(token);
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFile", "org/jetbrains/android/uipreview/ModuleClassLoader", "loadClassFile"));
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = Maps.newHashMap();
            this.myClassFilesLastModified = Maps.newHashMap();
        }
        this.myClassFiles.put(fqcn, classFile);
        this.myClassFilesLastModified.put(fqcn, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(fqcn, classFile);
    }

    @Override
    protected List<URL> getExternalJars() {
        List<VirtualFile> externalLibraries;
        AndroidFacet facet;
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        URL customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl();
        if (customWidgetsUrl != null) {
            result.add(customWidgetsUrl);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null && facet.requiresAndroidModel() && facet.getAndroidModel() != null) {
            AndroidModel androidModel = facet.getAndroidModel();
            externalLibraries = androidModel.getClassJarProvider().getModuleExternalLibraries(module);
        } else {
            externalLibraries = AndroidRootUtil.getExternalLibraries(module);
        }
        for (VirtualFile libFile : externalLibraries) {
            File file;
            if (!"jar".equals(libFile.getExtension()) || !(file = new File(libFile.getPath())).exists()) continue;
            try {
                FileResourceRepository repository;
                AppResourceRepository appResources;
                File manifest;
                File parentFile;
                result.add(SdkUtils.fileToUrl((File)file));
                File aarDir = file.getParentFile();
                if (aarDir != null && (aarDir.getPath().endsWith(".aar") || aarDir.getPath().contains("exploded-aar"))) {
                    AppResourceRepository appResources2;
                    if (aarDir.getPath().contains("exploded-aar")) {
                        if (aarDir.getPath().endsWith("libs")) {
                            aarDir = aarDir.getParentFile();
                        }
                        if (aarDir.getPath().endsWith("jars")) {
                            aarDir = aarDir.getParentFile();
                        }
                    }
                    if ((appResources2 = AppResourceRepository.getAppResources(module, true)) == null) continue;
                    ResourceClassRegistry.get(module.getProject()).addAarLibrary(appResources2, aarDir);
                    continue;
                }
                if (aarDir == null || (parentFile = aarDir.getParentFile()) == null || !(manifest = new File(parentFile, "AndroidManifest.xml")).exists() || (appResources = AppResourceRepository.getAppResources(module, true)) == null || (repository = appResources.findRepositoryFor(parentFile)) == null) continue;
                ResourceClassRegistry registry = ResourceClassRegistry.get(module.getProject());
                registry.addLibrary(appResources, registry.getAarPackage(parentFile));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ModuleClassLoader", "getClassFile"));
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        ModuleClassLoader loader;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ModuleClassLoader.get(%s)", LogAnonymizerUtil.anonymize(module)));
        }
        if ((loader = (ModuleClassLoader)ourCache.get((Object)module)) != null) {
            if (library != loader.myLibrary) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because the layout library has changed");
                }
                loader = null;
            } else if (!loader.isUpToDate()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because some files have changed");
                }
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Recreating jar class loader because dependencies have changed.");
                    }
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  New class loader");
            }
            loader = new ModuleClassLoader(library, module);
            ourCache.put((Object)module, (Object)loader);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("  Re-used class loader");
        }
        ModuleClassLoader moduleClassLoader = loader;
        if (moduleClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        return moduleClassLoader;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    public static void clearCache(Module module) {
        if (ourCache.containsKey((Object)module)) {
            ourCache.remove((Object)module);
        }
    }

    public boolean isClassLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        public ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

