/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.model.MergedManifest;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;

    public InstantAppUrlFinder(@NotNull MergedManifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/util/InstantAppUrlFinder", "<init>"));
        }
        this(manifest.getActivities());
    }

    InstantAppUrlFinder(@NotNull Collection<Element> activities) {
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "org/jetbrains/android/util/InstantAppUrlFinder", "<init>"));
        }
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                for (UrlData urlData : wrapper.getAllUrlData()) {
                    allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
                }
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)allUrls.values());
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder", "getAllUrls"));
        }
        return immutableList;
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            String string = (String)urls.iterator().next();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder", "getDefaultUrl"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder", "getDefaultUrl"));
        }
        return "";
    }

    static final class UrlData {
        private final String myScheme;
        private final String myHost;
        private final String myPathPattern;

        @NotNull
        public static UrlData of(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/util/InstantAppUrlFinder$UrlData", "of"));
            }
            String scheme = "";
            String host = "";
            String pathPattern = "";
            if (node.getNodeType() == 1 && "data".equals(node.getNodeName())) {
                Element element = (Element)node;
                scheme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme");
                host = element.getAttributeNS("http://schemas.android.com/apk/res/android", "host");
                pathPattern = element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern");
            }
            UrlData urlData = new UrlData(scheme, host, pathPattern);
            if (urlData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$UrlData", "of"));
            }
            return urlData;
        }

        public UrlData(String scheme, String host, String pathPattern) {
            this.myScheme = scheme;
            this.myHost = host;
            this.myPathPattern = pathPattern;
        }

        @NotNull
        public static String convertPatternToExample(String pattern) {
            String string = pattern.replace(".*", "parameter").replace("?", "X");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$UrlData", "convertPatternToExample"));
            }
            return string;
        }

        public boolean isValid() {
            return StringUtil.isNotEmpty((String)this.myScheme) && StringUtil.isNotEmpty((String)this.myHost) && StringUtil.isNotEmpty((String)this.myPathPattern);
        }

        @NotNull
        public String getUrl() {
            String string = String.format("%s://%s/%s", this.myScheme, this.myHost, UrlData.convertPatternToExample(this.myPathPattern));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$UrlData", "getUrl"));
            }
            return string;
        }
    }

    static final class InstantAppIntentFilterWrapper {
        @Nullable
        private final Element myElement;
        private final int myOrder;

        private InstantAppIntentFilterWrapper(@Nullable Element element, int order) {
            this.myElement = element;
            this.myOrder = order;
        }

        @NotNull
        public static InstantAppIntentFilterWrapper of(@NotNull Node node) {
            int order;
            Element element;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "of"));
            }
            try {
                element = InstantAppIntentFilterWrapper.getElement(node);
                order = InstantAppIntentFilterWrapper.getOrder(element);
            }
            catch (IllegalArgumentException unused) {
                element = null;
                order = -1;
            }
            InstantAppIntentFilterWrapper instantAppIntentFilterWrapper = new InstantAppIntentFilterWrapper(element, order);
            if (instantAppIntentFilterWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "of"));
            }
            return instantAppIntentFilterWrapper;
        }

        @NotNull
        public static Element getElement(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "getElement"));
            }
            if (node.getNodeType() == 1 && "intent-filter".equals(node.getNodeName())) {
                Element element = (Element)node;
                if (element == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "getElement"));
                }
                return element;
            }
            throw new IllegalArgumentException();
        }

        public static int getOrder(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "getOrder"));
            }
            String orderValue = element.getAttributeNS("http://schemas.android.com/instantapps", "order");
            try {
                return Integer.parseUnsignedInt(orderValue);
            }
            catch (NumberFormatException unused) {
                throw new IllegalArgumentException();
            }
        }

        @NotNull
        public Collection<UrlData> getAllUrlData() {
            if (this.myElement == null) {
                List<UrlData> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "getAllUrlData"));
                }
                return list;
            }
            ArrayList<UrlData> allUrls = new ArrayList<UrlData>();
            for (Node node = this.myElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                UrlData data = UrlData.of(node);
                if (!data.isValid()) continue;
                allUrls.add(data);
            }
            ArrayList<UrlData> arrayList = allUrls;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper", "getAllUrlData"));
            }
            return arrayList;
        }

        public int getOrder() {
            return this.myOrder;
        }
    }
}

