/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocFieldReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyDocCheckInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("GroovyDoc issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection", "getDisplayName"));
        }
        return "GroovyDoc issues";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return (String)args[0];
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitDocMethodReference(@NotNull GrDocMethodReference reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection$1", "visitDocMethodReference"));
                }
                this.checkGrDocMemberReference(reference);
            }

            @Override
            public void visitDocFieldReference(@NotNull GrDocFieldReference reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection$1", "visitDocFieldReference"));
                }
                this.checkGrDocMemberReference(reference);
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                if (refElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection$1", "visitCodeReferenceElement"));
                }
                GroovyResolveResult resolveResult = refElement.advancedResolve();
                if (refElement.getReferenceName() == null) {
                    return;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)refElement, GroovyDocPsiElement.class, (boolean)true, (Class[])new Class[]{GrMember.class, GrCodeBlock.class}) == null) {
                    return;
                }
                PsiElement resolved = resolveResult.getElement();
                if (resolved != null) {
                    return;
                }
                PsiElement toHighlight = refElement.getReferenceNameElement();
                this.registerError(toHighlight, GroovyBundle.message("cannot.resolve", refElement.getReferenceName()));
            }

            private void checkGrDocMemberReference(GrDocMemberReference reference) {
                if (reference.resolve() != null) {
                    return;
                }
                this.registerError((PsiElement)reference.getReferenceNameElement(), GroovyBundle.message("cannot.resolve", reference.getReferenceName()));
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDocCheckInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }
}

