/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class AsTypeTransformation
extends Transformation<GrSafeCastExpression> {
    @Override
    @Nullable
    protected GrSafeCastExpression checkCast(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/AsTypeTransformation", "checkCast"));
        }
        return expression instanceof GrSafeCastExpression ? (GrSafeCastExpression)expression : null;
    }

    @Override
    protected boolean couldApply(@NotNull GrSafeCastExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/AsTypeTransformation", "couldApply"));
        }
        GrTypeElement typeElement = expression.getCastTypeElement();
        if (typeElement == null) {
            return false;
        }
        PsiType type = typeElement.getType();
        return type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 0;
    }

    @Override
    protected void apply(@NotNull GrSafeCastExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/AsTypeTransformation", "apply"));
        }
        GrExpression lhsParenthesized = this.addParenthesesIfNeeded(expression.getOperand());
        GrTypeElement typeElement = Objects.requireNonNull(expression.getCastTypeElement());
        GrInspectionUtil.replaceExpression(expression, String.format("%s.asType(%s)", lhsParenthesized.getText(), typeElement.getText()));
    }

    @Override
    public String getMethod() {
        return "asType";
    }
}

