/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public abstract class ClashingTraitMethodsInspectionBase
extends BaseInspection {
    protected static final Logger LOG = Logger.getInstance(ClashingTraitMethodsInspectionBase.class);

    @NotNull
    protected static List<ClashingMethod> collectClassingMethods(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "collectClassingMethods"));
        }
        Collection visibleSignatures = typeDefinition.getVisibleSignatures();
        ArrayList clashingMethods = ContainerUtil.newArrayList();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            List superSignatures;
            PsiMethod method = signature.getMethod();
            if (!(method instanceof GrTraitMethod) || method.getContainingClass() != typeDefinition || (superSignatures = signature.getSuperSignatures()).size() <= 1) continue;
            ArrayList traits = ContainerUtil.newArrayList();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiMethod superMethod = superSignature.getMethod();
                PsiClass superClass = superMethod.getContainingClass();
                if (!GrTraitUtil.isTrait(superClass) || superMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                traits.add((GrTypeDefinition)superClass);
            }
            if (traits.size() <= 1) continue;
            clashingMethods.add(new ClashingMethod(signature, traits));
        }
        ArrayList arrayList = clashingMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "collectClassingMethods"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClass> collectImplementedTraits(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "collectImplementedTraits"));
        }
        List list = ContainerUtil.findAll((Object[])typeDefinition.getSupers(), aClass -> GrTraitUtil.isTrait(aClass));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "collectImplementedTraits"));
        }
        return list;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "visitTypeDefinition"));
                }
                super.visitTypeDefinition(typeDefinition);
                List superTraits = ClashingTraitMethodsInspectionBase.collectImplementedTraits(typeDefinition);
                if (superTraits.size() < 2) {
                    return;
                }
                List<ClashingMethod> clashingMethods = ClashingTraitMethodsInspectionBase.collectClassingMethods(typeDefinition);
                for (ClashingMethod clashing : clashingMethods) {
                    this.registerError(typeDefinition.getNameIdentifierGroovy(), this.buildWarning(clashing), new LocalQuickFix[]{ClashingTraitMethodsInspectionBase.this.getFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @NotNull
            private String buildWarning(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildWarning"));
                }
                String string = "Traits " + this.buildTraitString(entry) + " contain clashing methods with signature " + this.buildSignatureString(entry);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildWarning"));
                }
                return string;
            }

            @NotNull
            private String buildSignatureString(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildSignatureString"));
                }
                HierarchicalMethodSignature signature = entry.getSignature();
                String string = PsiFormatUtil.formatMethod((PsiMethod)signature.getMethod(), (PsiSubstitutor)signature.getSubstitutor(), (int)257, (int)2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildSignatureString"));
                }
                return string;
            }

            @NotNull
            private String buildTraitString(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildTraitString"));
                }
                String string = StringUtil.join(entry.getSuperTraits(), tr -> tr.getName(), (String)", ");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1", "buildTraitString"));
                }
                return string;
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    @NotNull
    protected LocalQuickFix getFix() {
        GroovyFix groovyFix = GroovyFix.EMPTY_FIX;
        if (groovyFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase", "getFix"));
        }
        return groovyFix;
    }

    protected static class ClashingMethod {
        private final HierarchicalMethodSignature mySignature;
        private final List<GrTypeDefinition> mySuperTraits;

        public ClashingMethod(@NotNull HierarchicalMethodSignature signature, @NotNull List<GrTypeDefinition> superTraits) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod", "<init>"));
            }
            if (superTraits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superTraits", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod", "<init>"));
            }
            this.mySignature = signature;
            this.mySuperTraits = superTraits;
        }

        @NotNull
        public HierarchicalMethodSignature getSignature() {
            HierarchicalMethodSignature hierarchicalMethodSignature = this.mySignature;
            if (hierarchicalMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod", "getSignature"));
            }
            return hierarchicalMethodSignature;
        }

        @NotNull
        public List<GrTypeDefinition> getSuperTraits() {
            List<GrTypeDefinition> list = this.mySuperTraits;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod", "getSuperTraits"));
            }
            return list;
        }
    }
}

