/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class NegationCountVisitor
extends GroovyRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/metrics/NegationCountVisitor", "visitElement"));
        }
        int oldCount = 0;
        if (element instanceof GrMethod) {
            oldCount = this.negationCount;
        }
        super.visitElement(element);
        if (element instanceof GrMethod) {
            this.negationCount = oldCount;
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/metrics/NegationCountVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return;
        }
        if (GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
            ++this.negationCount;
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression grUnaryExpression) {
        if (grUnaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grUnaryExpression", "org/jetbrains/plugins/groovy/codeInspection/metrics/NegationCountVisitor", "visitUnaryExpression"));
        }
        super.visitUnaryExpression(grUnaryExpression);
        IElementType sign = grUnaryExpression.getOperationTokenType();
        if (GroovyTokenTypes.mLNOT.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }
}

