/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public class GroovyConsoleUtil {
    private static final Function<Module, String> MODULE_VERSION = module -> {
        String moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module);
        boolean bundled = moduleGroovyHomePath == null || !GroovyConsoleUtil.hasGroovyAll(module);
        String homePathToUse = bundled ? GroovyFacetUtil.getBundledGroovyJar().getParentFile().getParent() : moduleGroovyHomePath;
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePathToUse);
        return version == "undefined" ? "" : (bundled ? "Bundled " : "") + "Groovy " + version;
    };

    static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, GroovyConsoleUtilKt.getApplicableModules(project), (Function<Module, String>)((Function)GroovyConsoleUtil::getTitle), consumer);
    }

    @NotNull
    public static String getTitle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyConsoleUtil", "getTitle"));
        }
        String string = ModuleChooserUtil.formatModuleVersion(module, (String)MODULE_VERSION.fun((Object)module));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleUtil", "getTitle"));
        }
        return string;
    }
}

