/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;

public class GroovyStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory", "createFilter"));
        }
        GroovyStripTrailingSpacesFilter groovyStripTrailingSpacesFilter = new GroovyStripTrailingSpacesFilter(document);
        if (groovyStripTrailingSpacesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory", "createFilter"));
        }
        return groovyStripTrailingSpacesFilter;
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory", "isApplicableTo"));
        }
        return language.is((Language)GroovyLanguage.INSTANCE);
    }

    private static class GroovyStripTrailingSpacesFilter
    extends PsiBasedStripTrailingSpacesFilter {
        protected GroovyStripTrailingSpacesFilter(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory$GroovyStripTrailingSpacesFilter", "<init>"));
            }
            super(document);
        }

        protected void process(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory$GroovyStripTrailingSpacesFilter", "process"));
            }
            psiFile.accept((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitGStringExpression(@NotNull GrString gstring) {
                    if (gstring == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gstring", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory$GroovyStripTrailingSpacesFilter$1", "visitGStringExpression"));
                    }
                    this.disableRange(gstring.getTextRange(), false);
                }

                @Override
                public void visitLiteralExpression(@NotNull GrLiteral literal) {
                    if (literal == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/plugins/groovy/editor/GroovyStripTrailingSpacesFilterFactory$GroovyStripTrailingSpacesFilter$1", "visitLiteralExpression"));
                    }
                    this.disableRange(literal.getTextRange(), false);
                }
            }));
        }
    }
}

