/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrIndexPropertyReference;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyLValueUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyPolyVariantReference;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public class GrIndexPropertyImpl
extends GrExpressionImpl
implements GrIndexProperty {
    private final NullableLazyValue<GrIndexPropertyReference> myRValueReference;
    private final NullableLazyValue<GrIndexPropertyReference> myLValueReference;
    private final NotNullLazyValue<GroovyPolyVariantReference[]> myReferences;

    @Override
    @Nullable
    public GroovyPolyVariantReference getLValueReference() {
        return (GroovyPolyVariantReference)this.myLValueReference.getValue();
    }

    @Override
    @Nullable
    public GroovyPolyVariantReference getRValueReference() {
        return (GroovyPolyVariantReference)this.myRValueReference.getValue();
    }

    @NotNull
    public GroovyPolyVariantReference[] getReferences() {
        GroovyPolyVariantReference[] groovyPolyVariantReferenceArray = (GroovyPolyVariantReference[])this.myReferences.getValue();
        if (groovyPolyVariantReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getReferences"));
        }
        return groovyPolyVariantReferenceArray;
    }

    public GrIndexPropertyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "<init>"));
        }
        super(node);
        this.myRValueReference = AtomicNullableLazyValue.createValue(() -> GroovyLValueUtil.isRValue(this) ? new GrIndexPropertyReference(this, true) : null);
        this.myLValueReference = AtomicNullableLazyValue.createValue(() -> GroovyLValueUtil.isLValue(this) ? new GrIndexPropertyReference(this, false) : null);
        this.myReferences = AtomicNotNullLazyValue.createValue(() -> {
            GroovyPolyVariantReference lValueReference = this.getLValueReference();
            GroovyPolyVariantReference rValueReference = this.getRValueReference();
            if (lValueReference == null && rValueReference == null) {
                return GroovyPolyVariantReference.EMPTY_ARRAY;
            }
            if (lValueReference == null) {
                return new GroovyPolyVariantReference[]{rValueReference};
            }
            if (rValueReference == null) {
                return new GroovyPolyVariantReference[]{lValueReference};
            }
            return new GroovyPolyVariantReference[]{rValueReference, lValueReference};
        });
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitIndexProperty(this);
    }

    public String toString() {
        return "Property by index";
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getInvokedExpression"));
        }
        return grExpression;
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getArgumentList"));
        }
        return grArgumentList;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, GrTypeCalculator::getTypeFromCalculators);
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return GroovyIndexPropertyUtil.getSimpleArrayAccessType(this);
    }
}

