/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;

public abstract class GrTypeDefinitionElementType<TypeDef extends GrTypeDefinition>
extends GrStubElementType<GrTypeDefinitionStub, TypeDef> {
    public GrTypeDefinitionElementType(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public GrTypeDefinitionStub createStub(@NotNull TypeDef psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "createStub"));
        }
        byte flags = GrTypeDefinitionStub.buildFlags(psi);
        GrTypeDefinitionStub grTypeDefinitionStub = new GrTypeDefinitionStub(parentStub, psi.getName(), GrStubUtils.getBaseClassName(psi), this, psi.getQualifiedName(), GrStubUtils.getAnnotationNames(psi), flags);
        if (grTypeDefinitionStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "createStub"));
        }
        return grTypeDefinitionStub;
    }

    public void serialize(@NotNull GrTypeDefinitionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)stub.getFlags());
        dataStream.writeName(stub.getBaseClassName());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getAnnotations());
    }

    private static void writeStringArray(StubOutputStream dataStream, String[] names) throws IOException {
        dataStream.writeByte(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    @NotNull
    public GrTypeDefinitionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        String qname = StringRef.toString((StringRef)dataStream.readName());
        byte flags = dataStream.readByte();
        String baseClassName = StringRef.toString((StringRef)dataStream.readName());
        String[] annos = GrTypeDefinitionElementType.readStringArray(dataStream);
        GrTypeDefinitionStub grTypeDefinitionStub = new GrTypeDefinitionStub(parentStub, name, baseClassName, this, qname, annos, flags);
        if (grTypeDefinitionStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "deserialize"));
        }
        return grTypeDefinitionStub;
    }

    @NotNull
    private static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int supersNumber = dataStream.readByte();
        String[] superClasses = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            superClasses[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        if (superClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "readStringArray"));
        }
        return superClasses;
    }

    @Override
    public void indexStub(@NotNull GrTypeDefinitionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType", "indexStub"));
        }
        if (stub.isAnonymous()) {
            String baseClassName = stub.getBaseClassName();
            if (baseClassName != null) {
                String shortName = PsiNameHelper.getShortClassName((String)baseClassName);
                sink.occurrence(GrAnonymousClassIndex.KEY, (Object)shortName);
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(GrFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

