/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01Unfairish
implements RecursiveLock {
    protected final Sync sync;

    public RecursiveLockImpl01Unfairish(Sync sync) {
        this.sync = sync;
    }

    public RecursiveLockImpl01Unfairish() {
        this(new SingleThreadSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getLockedStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOwner(Thread thread) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.isOwner(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = this.sync.getOwner();
            return null != thread && Thread.currentThread() != thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getHoldCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateLocked() throws RuntimeException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (!this.sync.isOwner(Thread.currentThread())) {
                if (null == this.sync.getOwner()) {
                    String string = this.threadName(Thread.currentThread());
                    String string2 = this.toString();
                    throw new RuntimeException(new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": Not locked: ").append(string2).toString());
                }
                if (null != this.sync.getLockedStack()) {
                    this.sync.getLockedStack().printStackTrace();
                }
                String string = String.valueOf(Thread.currentThread());
                String string3 = this.toString();
                throw new RuntimeException(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(": Not owner: ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.getLockedStack()) {
                        this.sync.getLockedStack().printStackTrace();
                    }
                    long l = TIMEOUT;
                    String string = this.toString();
                    String string2 = this.threadName(Thread.currentThread());
                    throw new RuntimeException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Waited ").append(l).append("ms for: ").append(string).append(" - ").append(string2).toString());
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryLock(long l) throws InterruptedException {
        Sync sync = this.sync;
        synchronized (sync) {
            String string;
            Thread thread = Thread.currentThread();
            if (TRACE_LOCK) {
                string = this.toString();
                long l2 = l;
                String string2 = this.threadName(thread);
                System.err.println(new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("+++ LOCK 0 ").append(string).append(", timeout ").append(l2).append(" ms, cur ").append(string2).toString());
            }
            if (this.sync.isOwner(thread)) {
                this.sync.incrHoldCount(thread);
                if (TRACE_LOCK) {
                    string = this.toString();
                    String string3 = this.threadName(thread);
                    System.err.println(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string3).length()).append("+++ LOCK XR ").append(string).append(", cur ").append(string3).toString());
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l && 0 < this.sync.getQSz()) {
                long l3;
                if (0L >= l) {
                    if (TRACE_LOCK) {
                        string = this.toString();
                        String string4 = this.threadName(thread);
                        long l4 = l;
                        System.err.println(new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(string4).length()).append("+++ LOCK XY ").append(string).append(", cur ").append(string4).append(", left ").append(l4).append(" ms").toString());
                    }
                    return false;
                }
                this.sync.incrQSz();
                do {
                    l3 = System.currentTimeMillis();
                    this.sync.wait(l);
                } while (null != this.sync.getOwner() && 0L < (l -= System.currentTimeMillis() - l3));
                this.sync.decrQSz();
                if (0L >= l && this.sync.getOwner() != null) {
                    if (TRACE_LOCK) {
                        String string5 = this.toString();
                        String string6 = this.threadName(thread);
                        long l5 = l;
                        System.err.println(new StringBuilder(48 + String.valueOf(string5).length() + String.valueOf(string6).length()).append("+++ LOCK XX ").append(string5).append(", cur ").append(string6).append(", left ").append(l5).append(" ms").toString());
                    }
                    return false;
                }
                if (TRACE_LOCK) {
                    String string7 = this.toString();
                    String string8 = this.threadName(thread);
                    long l6 = l;
                    System.err.println(new StringBuilder(48 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("+++ LOCK X1 ").append(string7).append(", cur ").append(string8).append(", left ").append(l6).append(" ms").toString());
                }
            } else if (TRACE_LOCK) {
                string = this.toString();
                String string9 = this.threadName(thread);
                System.err.println(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string9).length()).append("+++ LOCK X0 ").append(string).append(", cur ").append(string9).toString());
            }
            this.sync.setOwner(thread);
            this.sync.incrHoldCount(thread);
            if (DEBUG) {
                String string10 = String.valueOf(this.toString());
                this.sync.setLockedStack(new Throwable(string10.length() != 0 ? "Previously locked by ".concat(string10) : new String("Previously locked by ")));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Runnable runnable) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread = Thread.currentThread();
            this.sync.decrHoldCount(thread);
            if (this.sync.getHoldCount() > 0) {
                if (TRACE_LOCK) {
                    String string = this.toString();
                    String string2 = this.threadName(thread);
                    System.err.println(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("--- LOCK XR ").append(string).append(", cur ").append(string2).toString());
                }
                return;
            }
            this.sync.setOwner(null);
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (null != runnable) {
                runnable.run();
            }
            if (TRACE_LOCK) {
                String string = this.toString();
                String string3 = this.threadName(thread);
                System.err.println(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string3).length()).append("--- LOCK X0 ").append(string).append(", cur ").append(string3).append(", signal any").toString());
            }
            this.sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getQSz();
        }
    }

    public String toString() {
        String string = this.syncName();
        int n = this.sync.getHoldCount();
        int n2 = this.sync.getQSz();
        String string2 = this.threadName(this.sync.getOwner());
        return new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[count ").append(n).append(", qsz ").append(n2).append(", owner ").append(string2).append("]").toString();
    }

    final String syncName() {
        String string = String.valueOf(Integer.toHexString(this.hashCode()));
        String string2 = String.valueOf(Integer.toHexString(this.sync.hashCode()));
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append(", ").append(string2).append(">").toString();
    }

    final String threadName(Thread thread) {
        String string;
        if (null != thread) {
            String string2 = String.valueOf(thread.getName());
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("<").append(string2).append(">").toString();
        } else {
            string = "<NULL>";
        }
        return string;
    }

    static class SingleThreadSync
    extends AbstractOwnableSynchronizer
    implements Sync {
        private int holdCount = 0;
        private int qsz = 0;
        private Throwable lockedStack = null;

        SingleThreadSync() {
        }

        @Override
        public final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        @Override
        public boolean isOwner(Thread thread) {
            return this.getExclusiveOwnerThread() == thread;
        }

        @Override
        public final void setOwner(Thread thread) {
            this.setExclusiveOwnerThread(thread);
        }

        @Override
        public final Throwable getLockedStack() {
            return this.lockedStack;
        }

        @Override
        public final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }

        @Override
        public final int getHoldCount() {
            return this.holdCount;
        }

        @Override
        public void incrHoldCount(Thread thread) {
            ++this.holdCount;
        }

        @Override
        public void decrHoldCount(Thread thread) {
            --this.holdCount;
        }

        @Override
        public final int getQSz() {
            return this.qsz;
        }

        @Override
        public final void incrQSz() {
            ++this.qsz;
        }

        @Override
        public final void decrQSz() {
            --this.qsz;
        }
    }

    static interface Sync {
        public Thread getOwner();

        public boolean isOwner(Thread var1);

        public void setOwner(Thread var1);

        public Throwable getLockedStack();

        public void setLockedStack(Throwable var1);

        public int getHoldCount();

        public void incrHoldCount(Thread var1);

        public void decrHoldCount(Thread var1);

        public int getQSz();

        public void incrQSz();

        public void decrQSz();
    }
}

