/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Properties;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadm.editors.AttributeEditorFactory;
import org.w3c.jigadm.editors.ResourceHelper;
import org.w3c.jigadm.events.ResourceChangeEvent;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.widgets.BorderPanel;

public class AttributesHelper
extends ResourceHelper {
    private RemoteResourceWrapper rrw = null;
    private AttributeDescription[] a = null;
    private AttributeEditor[] ae = null;
    private ScrollPane pwidget;
    private boolean initialized = false;
    protected static final String COMMIT_L = "Commit";
    protected static final String RESET_L = "Reset";
    Panel widget = new Panel(new BorderLayout());
    Label message;

    public void setMessage(String string) {
        this.message.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() throws RemoteAccessException {
        int n;
        if (!this.initialized) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.ae.length; ++n) {
            if (!this.ae[n].hasChanged()) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        Object[] objectArray = new Object[n2];
        n2 = 0;
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            stringArray[n2] = this.a[i].getName();
            objectArray[n2] = this.ae[i].getValue();
            if (stringArray[n2].equals("identifier")) {
                if (this.rrw.getBrowser() != null) {
                    this.rrw.getBrowser().renameNode(this.rrw, (String)objectArray[n2]);
                }
                this.processEvent(new ResourceChangeEvent(this.rrw, "identifier", null, objectArray[n2]));
            }
            ++n2;
        }
        n = 0;
        while (n == 0) {
            try {
                n = 1;
                this.rrw.getResource().setValues(stringArray, objectArray);
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    n = 0;
                    continue;
                }
                throw remoteAccessException;
            }
            finally {
                if (n != 0) continue;
                this.rrw.getBrowser().popupDialog("admin");
            }
        }
        this.clearChanged();
    }

    public boolean hasChanged() {
        if (this.ae == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < this.ae.length; ++i) {
            bl = this.ae[i].hasChanged();
        }
        return bl;
    }

    public void resetChanges() {
        if (this.ae == null) {
            return;
        }
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            this.ae[i].resetChanges();
        }
    }

    public void clearChanged() {
        if (this.ae == null) {
            return;
        }
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            this.ae[i].clearChanged();
        }
    }

    public Component getComponent() {
        return this.widget;
    }

    public final String getTitle() {
        return "Attribute";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        Object object;
        Serializable serializable;
        Object object2;
        int n;
        if (this.initialized) {
            return;
        }
        AttributeDescription[] attributeDescriptionArray = null;
        Object var5_4 = null;
        int n2 = 0;
        this.rrw = remoteResourceWrapper;
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        boolean bl = false;
        while (!bl) {
            try {
                bl = true;
                attributeDescriptionArray = remoteResource.getAttributes();
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                    continue;
                }
                throw remoteAccessException;
            }
            finally {
                if (bl) continue;
                remoteResourceWrapper.getBrowser().popupDialog("admin");
            }
        }
        for (n = 0; n < attributeDescriptionArray.length; ++n) {
            if (attributeDescriptionArray[n] == null) {
                ++n2;
                continue;
            }
            if (attributeDescriptionArray[n].getAttribute().checkFlag(2)) continue;
            ++n2;
        }
        this.a = new AttributeDescription[attributeDescriptionArray.length - n2];
        this.ae = new AttributeEditor[this.a.length];
        n = 0;
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            if (attributeDescriptionArray[i] == null || !attributeDescriptionArray[i].getAttribute().checkFlag(2)) continue;
            this.a[n++] = attributeDescriptionArray[i];
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel(gridBagLayout);
        panel.setForeground(new Color(0, 0, 128));
        this.pwidget = new ScrollPane();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] == null) continue;
            object2 = PropertyManager.getPropertyManager();
            serializable = ((PropertyManager)object2).getAttributeProperties(remoteResourceWrapper, this.a[i].getAttribute());
            object = (String)((Properties)serializable).get("label");
            if (object == null) {
                object = this.a[i].getName();
            }
            Label label = new Label((String)object, 2);
            this.ae[i] = AttributeEditorFactory.getEditor(remoteResourceWrapper, this.a[i].getAttribute());
            bl = false;
            while (!bl) {
                try {
                    bl = true;
                    this.ae[i].initialize(remoteResourceWrapper, this.a[i].getAttribute(), this.a[i].getValue(), (Properties)serializable);
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                        continue;
                    }
                    throw remoteAccessException;
                }
                finally {
                    if (bl) continue;
                    remoteResourceWrapper.getBrowser().popupDialog("admin");
                }
            }
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.ae[i].getComponent(), gridBagConstraints);
            panel.add(this.ae[i].getComponent());
        }
        this.pwidget.add(panel);
        this.widget.add("Center", this.pwidget);
        Panel panel2 = new Panel(new BorderLayout());
        object2 = new Button(COMMIT_L);
        serializable = new Button(RESET_L);
        object = new MouseButtonListener();
        ((Component)object2).addMouseListener((MouseListener)object);
        ((Component)serializable).addMouseListener((MouseListener)object);
        ButtonBarListener buttonBarListener = new ButtonBarListener();
        ((Button)object2).addActionListener(buttonBarListener);
        ((Button)serializable).addActionListener(buttonBarListener);
        this.message = new Label("", 1);
        this.message.setForeground(Color.white);
        this.message.setBackground(Color.gray);
        BorderPanel borderPanel = new BorderPanel(3, 2);
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add("Center", this.message);
        panel2.add("West", (Component)object2);
        panel2.add("Center", borderPanel);
        panel2.add("East", (Component)serializable);
        this.widget.add("South", panel2);
        String[] stringArray = new String[]{""};
        try {
            stringArray = remoteResource.getClassHierarchy();
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
        }
        Label label = new Label("Class: " + stringArray[0], 1);
        label.setForeground(new Color(0, 0, 128));
        this.widget.add("North", label);
        this.initialized = true;
    }

    class MouseButtonListener
    extends MouseAdapter {
        MouseButtonListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof Button) {
                String string = ((Button)component).getActionCommand();
                if (string.equals(AttributesHelper.COMMIT_L)) {
                    AttributesHelper.this.setMessage("Commit the changes to the server.");
                } else if (string.equals(AttributesHelper.RESET_L)) {
                    AttributesHelper.this.setMessage("Reset changes");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AttributesHelper.this.setMessage("");
        }
    }

    class ButtonBarListener
    implements ActionListener {
        ButtonBarListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(AttributesHelper.RESET_L)) {
                AttributesHelper.this.resetChanges();
            } else if (actionEvent.getActionCommand().equals(AttributesHelper.COMMIT_L)) {
                AttributesHelper.this.setMessage("Committing...");
                new Commiter().start();
                AttributesHelper.this.setMessage("Commit done.");
            }
        }

        class Commiter
        extends Thread {
            Commiter() {
            }

            public void run() {
                try {
                    AttributesHelper.this.commitChanges();
                }
                catch (RemoteAccessException remoteAccessException) {
                    AttributesHelper.this.errorPopup("RemoteAccessException", remoteAccessException);
                }
            }
        }
    }
}

