/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class GotoEjbMethodCellRenderer
implements ListCellRenderer {
    private final JPanel myComponent = new JPanel(new BorderLayout());
    private final JLabel myMethodNameLabel = new JLabel();
    private final JLabel myClassNameLabel;
    private final JLabel myPackageNameLabel;

    public GotoEjbMethodCellRenderer() {
        this.myMethodNameLabel.setOpaque(true);
        this.myClassNameLabel = new JLabel();
        this.myClassNameLabel.setOpaque(true);
        this.myPackageNameLabel = new JLabel();
        this.myPackageNameLabel.setOpaque(true);
        this.myComponent.add((Component)this.myMethodNameLabel, "West");
        this.myComponent.add((Component)this.myClassNameLabel, "Center");
        this.myClassNameLabel.setHorizontalAlignment(4);
        this.myComponent.add((Component)this.myPackageNameLabel, "East");
    }

    public Component getListCellRendererComponent(JList list, Object value, int _index, boolean isSelected, boolean cellHasFocus) {
        Color foreground;
        Color background;
        if (value instanceof PsiClass) {
            PsiClass aClass = (PsiClass)value;
            this.setupClassName(aClass);
            this.myMethodNameLabel.setText("");
            this.myMethodNameLabel.setIcon(null);
        } else if (value instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)value;
            this.myMethodNameLabel.setText(method.getName() + "  ");
            this.myMethodNameLabel.setIcon(method.getIcon(0));
            this.setupClassName(method.getContainingClass());
        } else {
            this.myClassNameLabel.setText(value.toString());
            this.myClassNameLabel.setIcon(null);
            this.myPackageNameLabel.setText("");
            this.myMethodNameLabel.setText("");
            this.myMethodNameLabel.setIcon(null);
        }
        Font listFont = list.getFont();
        this.myClassNameLabel.setFont(listFont);
        this.myPackageNameLabel.setFont(listFont);
        this.myMethodNameLabel.setFont(listFont);
        if (isSelected) {
            background = list.getSelectionBackground();
            foreground = list.getSelectionForeground();
        } else {
            background = list.getBackground();
            foreground = list.getForeground();
        }
        this.myClassNameLabel.setBackground(background);
        this.myClassNameLabel.setForeground(foreground);
        this.myMethodNameLabel.setBackground(background);
        this.myMethodNameLabel.setForeground(foreground);
        this.myPackageNameLabel.setBackground(background);
        int red = (foreground.getRed() + background.getRed()) / 2;
        int green = (foreground.getGreen() + background.getGreen()) / 2;
        int blue = (foreground.getBlue() + background.getBlue()) / 2;
        this.myPackageNameLabel.setForeground(new Color(red, green, blue));
        return this.myComponent;
    }

    private void setupClassName(PsiClass aClass) {
        int index;
        String name = aClass.getName();
        this.myClassNameLabel.setText(name);
        this.myClassNameLabel.setIcon(aClass.getIcon(0));
        String packageName = "";
        String qName = aClass.getQualifiedName();
        if (qName != null && (index = qName.lastIndexOf(46)) >= 0) {
            packageName = " (" + qName.substring(0, index) + ")";
        }
        this.myPackageNameLabel.setText(packageName);
    }
}

