/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.module.view.ejb.InterceptorBindingsDialog;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EJBInterceptorBindingAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)EJBInterceptorBindingAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EJBInterceptorBindingAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EJBInterceptorBindingAction", "isAvailable"));
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
            return false;
        }
        if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
            return false;
        }
        if (targetClass.getDocComment() != null && targetClass.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetClass, PsiErrorElement.class) != null) {
            return false;
        }
        String text = EJBInterceptorBindingAction.getExplanation(targetClass);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.edit.interceptor.binding.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/EJBInterceptorBindingAction", "getFamilyName"));
        }
        return string;
    }

    public static String getExplanation(PsiClass member) {
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)member);
        if (ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) > 0) {
            return null;
        }
        boolean good = false;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(member)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS || !member.equals(role.getInterceptor().getInterceptorClass().getValue())) continue;
            good = true;
            break;
        }
        if (good) {
            return CodeInsightBundle.message((String)"intention.edit.interceptor.binding.text", (Object[])new Object[]{member.getName()});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EJBInterceptorBindingAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EJBInterceptorBindingAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)targetClass);
        InterceptorBindingsDialog dialog = new InterceptorBindingsDialog(project, targetClass.getQualifiedName(), ejbFacet);
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

