/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.j2ee.appServerIntegrations.ApplicationServerConfigurable;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersModelProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerImpl
implements ApplicationServer,
JDOMExternalizable {
    @NonNls
    private static final String DATA_ELEMENT = "DATA";
    @NonNls
    private static final String OLD_GENERIC_SERVER_NAME = "Generic Application Server";
    @NonNls
    private static final String NEW_GENERIC_SERVER_NAME = "JSR45 Compatible Application Server";
    public String SOURCE_INTEGRATION_NAME;
    private final Library myLibrary;
    private final Map<FrameworkType, Library> myFrameworkLibraries;
    private ApplicationServerPersistentData myPersistentData;

    public ApplicationServerImpl(@NotNull Library library, ApplicationServerPersistentData persistentData) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "<init>"));
        }
        this.SOURCE_INTEGRATION_NAME = "";
        this.myFrameworkLibraries = new HashMap<FrameworkType, Library>();
        this.myLibrary = library;
        this.myPersistentData = persistentData;
    }

    public void addFrameworkLibrary(@NotNull FrameworkType frameworkType, @NotNull Library library) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "addFrameworkLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "addFrameworkLibrary"));
        }
        this.myFrameworkLibraries.put(frameworkType, library);
    }

    public void removeFrameworkLibrary(@NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "removeFrameworkLibrary"));
        }
        this.myFrameworkLibraries.remove(frameworkType);
    }

    public String getName() {
        return this.myLibrary.getName();
    }

    public String toString() {
        return this.getName();
    }

    public ApplicationServerConfigurable createConfigurable(ApplicationServersModelProvider modelProvider) {
        return new ApplicationServerConfigurable(this, modelProvider);
    }

    public void readExternal(Element element) throws InvalidDataException {
        AppServerIntegration integration;
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (OLD_GENERIC_SERVER_NAME.equals(this.SOURCE_INTEGRATION_NAME)) {
            this.SOURCE_INTEGRATION_NAME = NEW_GENERIC_SERVER_NAME;
        }
        if ((integration = AppServerIntegrationsManager.getInstance().findIntegrationByName(this.SOURCE_INTEGRATION_NAME)) == null) {
            throw new InvalidDataException("Can't find integration");
        }
        Element dataElement = element.getChild(DATA_ELEMENT);
        ApplicationServerHelper helper = integration.getApplicationServerHelper();
        ApplicationServerPersistentData applicationServerPersistentData = this.myPersistentData = helper == null ? null : helper.createPersistentDataEmptyInstance();
        if (dataElement != null && this.myPersistentData != null) {
            this.myPersistentData.readExternal(dataElement);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String integrationName = this.SOURCE_INTEGRATION_NAME;
        if (NEW_GENERIC_SERVER_NAME.equals(this.SOURCE_INTEGRATION_NAME)) {
            this.SOURCE_INTEGRATION_NAME = OLD_GENERIC_SERVER_NAME;
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.SOURCE_INTEGRATION_NAME = integrationName;
        if (this.myPersistentData != null) {
            Element dataElement = new Element(DATA_ELEMENT);
            element.addContent(dataElement);
            this.myPersistentData.writeExternal(dataElement);
        }
    }

    @Nullable
    public AppServerIntegration getSourceIntegration() {
        return AppServerIntegrationsManager.getInstance().findIntegrationByName(this.SOURCE_INTEGRATION_NAME);
    }

    @NotNull
    public Library getLibrary() {
        Library library = this.myLibrary;
        if (library == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "getLibrary"));
        }
        return library;
    }

    @NotNull
    public Collection<Library> getFrameworkLibraries() {
        Collection<Library> collection = this.myFrameworkLibraries.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "getFrameworkLibraries"));
        }
        return collection;
    }

    @Nullable
    public Library getFrameworkLibrary(@NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServerImpl", "getFrameworkLibrary"));
        }
        return this.myFrameworkLibraries.get(frameworkType);
    }

    public ApplicationServerPersistentData getPersistentData() {
        return this.myPersistentData;
    }

    public boolean isDisposed() {
        return ((LibraryEx)this.myLibrary).isDisposed();
    }

    public void setSourceIntegrationName(String name) {
        this.SOURCE_INTEGRATION_NAME = name;
    }
}

