/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.JavaeeFieldRefactoringSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeRenameProcessor<T extends CommonModelElement>
extends RenamePsiElementProcessor {
    private static final Key<PsiElement> ORIGINAL_PSI_ELEMENT = Key.create((String)"ORIGINAL_PSI_ELEMENT");
    private final JavaeeFieldRefactoringSupport<T> myRefactoringSupport;

    protected JavaeeRenameProcessor(JavaeeFieldRefactoringSupport<T> refactoringSupport) {
        this.myRefactoringSupport = refactoringSupport;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/JavaeeRenameProcessor", "canProcessElement"));
        }
        return this.myRefactoringSupport.getModelElement(element) != null;
    }

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        PsiElement originalElement = (PsiElement)ObjectUtils.assertNotNull((Object)element.getUserData(ORIGINAL_PSI_ELEMENT));
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        boolean b = this.myRefactoringSupport.askUserIfAccessorsShouldBeTakenIntoAccount(modelElement, originalElement);
        if (!b) {
            return super.createRenameDialog(project, originalElement, nameSuggestionContext, editor);
        }
        return new RenameDialog(project, element, null, null){

            protected boolean hasHelpAction() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return true;
            }
        };
    }

    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        PsiElement result = (PsiElement)ObjectUtils.assertNotNull((Object)modelElement.getIdentifyingPsiElement());
        result.putUserData(ORIGINAL_PSI_ELEMENT, (Object)element);
        return result;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        PsiElement originalElement = (PsiElement)element.getUserData(ORIGINAL_PSI_ELEMENT);
        if (originalElement == null) {
            return;
        }
        CommonModelElement modelElement = (CommonModelElement)ObjectUtils.assertNotNull((Object)this.myRefactoringSupport.getModelElement(element));
        Collection accessors = this.myRefactoringSupport.getAccessors(modelElement);
        for (PsiElement accessor : accessors) {
            if (accessor instanceof LightElement) continue;
            if (accessor instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)accessor;
                String prefix = NameUtil.nameToWords((String)method.getName())[0];
                allRenames.put(accessor, prefix + StringUtil.capitalize((String)newName));
                continue;
            }
            if (accessor instanceof PsiField) {
                allRenames.put(accessor, newName);
                continue;
            }
            throw new AssertionError((Object)("Invalid accessor: " + element));
        }
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }
}

