/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbMethod;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbRelationUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbDeclMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbImplMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.EjbLinkResolveConverter;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.javaee.model.annotations.ejb.EnterpriseBeanImpl;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanType;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorSet;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.CmrFieldType;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.model.xml.ejb.EnterpriseBeans;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFile;
import com.intellij.javaee.module.view.ejb.editor.InterceptorAsVirtualFile;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbUtil {
    @NonNls
    private static final String EJB_JAR_2_0_DTD = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    @NonNls
    private static final String EJB_JAR_1_1_DTD = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    @NonNls
    private static final String EJB_JAR_1_0_DTD = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.0//EN";
    private static final Key<CachedValue<Map<PsiClass, PsiMethod[]>>> EJB_IMPLEMENTATIONS_KEY = Key.create((String)"EJB_IMPLEMENTATIONS");
    private static final Key<CachedValue<PsiMethod[]>> EJB_DECLARATIONS_KEY = Key.create((String)"EJB_DECLARATIONS");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.ejb.EjbUtil");
    @NonNls
    public static final String ENUMERATION_CLASS = "java.util.Enumeration";
    @NonNls
    private static final String EJB_FIND = "ejbFind";
    @NonNls
    private static final String FIND_REFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String EJB_CREATE_PREFIX = "ejbCreate";
    @NonNls
    private static final String SERIALIZABLE = "java.io.Serializable";
    @NonNls
    private static final String REMOTE = "java.rmi.Remote";
    @NonNls
    private static final List<String> specialEjbClassMethods = Arrays.asList("setEntityContext", "unsetEntityContext", "setSessionContext", "unsetSessionContext", "ejbActivate", "ejbPassivate", "ejbLoad", "ejbStore", "ejbRemove");

    private EjbUtil() {
    }

    @NotNull
    public static JavaeeVersion getJavaeeVersion(EjbDescriptorVersion ejbVersion) {
        if (ejbVersion == null) {
            JavaeeVersion javaeeVersion = JavaeeVersion.JAVAEE_6;
            if (javaeeVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getJavaeeVersion"));
            }
            return javaeeVersion;
        }
        switch (ejbVersion) {
            case EJB_VERSION_1_X: 
            case EJB_VERSION_2_0: 
            case EJB_VERSION_2_1: {
                JavaeeVersion javaeeVersion = JavaeeVersion.J2EE_1_4;
                if (javaeeVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getJavaeeVersion"));
                }
                return javaeeVersion;
            }
            case EJB_VERSION_3_0: {
                JavaeeVersion javaeeVersion = JavaeeVersion.JAVAEE_5;
                if (javaeeVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getJavaeeVersion"));
                }
                return javaeeVersion;
            }
            case EJB_VERSION_3_1: {
                JavaeeVersion javaeeVersion = JavaeeVersion.JAVAEE_6;
                if (javaeeVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getJavaeeVersion"));
                }
                return javaeeVersion;
            }
            case EJB_VERSION_3_2: {
                JavaeeVersion javaeeVersion = JavaeeVersion.JAVAEE_7;
                if (javaeeVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getJavaeeVersion"));
                }
                return javaeeVersion;
            }
        }
        throw new AssertionError(ejbVersion);
    }

    @Nullable
    public static EjbFacet getEjbFacet(PsiElement element) {
        return EjbModuleUtil.getEjbFacet((PsiElement)element);
    }

    @NotNull
    public static PsiMethod[] getEjbMethodsToImplement(PsiClass aClass) {
        EjbClassRole[] classRoles = EjbHelper.getEjbHelper().getEjbRoles(aClass);
        if (!EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, classRoles)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbMethodsToImplement"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        ArrayList<PsiMethod> methodsArray = new ArrayList<PsiMethod>();
        for (EjbClassRole classRole : classRoles) {
            EnterpriseBean ejb;
            if (classRole.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS || (ejb = classRole.getEnterpriseBean()).getEjbClass().getValue() != aClass) continue;
            if (ejb instanceof EjbWithHome) {
                EjbWithHome elementWithHome = (EjbWithHome)ejb;
                EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)elementWithHome.getHome().getValue(), methodsArray, EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE);
                EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)elementWithHome.getRemote().getValue(), methodsArray, null);
                EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)elementWithHome.getLocalHome().getValue(), methodsArray, EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE);
                EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)elementWithHome.getLocal().getValue(), methodsArray, null);
            }
            if (ejb instanceof SessionBean) {
                EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)((SessionBean)ejb).getServiceEndpoint().getValue(), methodsArray, null);
                for (GenericValue value : ((SessionBean)ejb).getBusinessLocals()) {
                    EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)value.getValue(), methodsArray, null);
                }
                for (GenericValue value : ((SessionBean)ejb).getBusinessRemotes()) {
                    EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)value.getValue(), methodsArray, null);
                }
            }
            if (!(ejb instanceof MessageDrivenBean)) continue;
            EjbUtil.getEjbMethodsToImplementInInterface(ejb, aClass, (PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue(), methodsArray, null);
        }
        PsiMethod[] psiMethodArray = methodsArray.toArray(new PsiMethod[methodsArray.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbMethodsToImplement"));
        }
        return psiMethodArray;
    }

    private static void getEjbMethodsToImplementInInterface(EnterpriseBean ejb, PsiClass aClass, PsiClass anInterface, List<PsiMethod> methodsArray, EjbClassRoleEnum roleTypeOnly) {
        if (anInterface != null) {
            PsiMethod[] methods;
            EjbClassRole classRole = null;
            if (roleTypeOnly != null) {
                for (EjbClassRole role : EjbHelper.getEjbHelper().getEjbRoles(anInterface)) {
                    if (role.getType() != roleTypeOnly || role.getEnterpriseBean() != ejb) continue;
                    classRole = role;
                    break;
                }
            }
            block1: for (PsiMethod method : methods = anInterface.getAllMethods()) {
                EjbDeclMethodRole r;
                EjbMethodRoleImpl methodRole;
                PsiMethod[] implementations = null;
                if (!method.getManager().isInProject((PsiElement)method) || roleTypeOnly != null && classRole != null && (!((methodRole = EjbMethodRoleImpl.suggestMethodRole(classRole, method)) instanceof EjbDeclMethodRole) || (r = (EjbDeclMethodRole)methodRole).isCompletelyImplemented() || (implementations = r.suggestImplementations()).length == 0)) continue;
                if (implementations != null) {
                    for (void var15_18 : implementations) {
                        if (aClass.findMethodBySignature((PsiMethod)var15_18, true) != null) continue;
                        methodsArray.add(method);
                        continue block1;
                    }
                    continue;
                }
                if (aClass.findMethodBySignature(method, true) != null) continue;
                methodsArray.add(method);
            }
        }
    }

    @NotNull
    public static PsiMethod[] findEjbImplementations(PsiMethod method) {
        Map<PsiClass, PsiMethod[]> map = EjbUtil.findEjbImplementationsMap(method);
        if (map.size() == 0) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbImplementations"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = map.get(method.getContainingClass());
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbImplementations"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static Map<PsiClass, PsiMethod[]> findEjbImplementationsMap(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !containingClass.isInterface()) {
            Map<PsiClass, PsiMethod[]> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbImplementationsMap"));
            }
            return map;
        }
        CachedValue cachedValue = (CachedValue)method.getUserData(EJB_IMPLEMENTATIONS_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)method.getProject()).createCachedValue(() -> {
                HashMap<PsiClass, Object[]> methodMap = new HashMap<PsiClass, Object[]>();
                HashSet methodList = new HashSet();
                HashSet<Key> dependencyItemsList = new HashSet<Key>();
                EjbMethodRole[] roles = OldEjbRolesUtil.getEjbRoles(method);
                dependencyItemsList.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                if (roles.length == 0) {
                    for (EjbMethodRole ejbMethodRole : OldEjbRolesUtil.getEjbRoles(method.getContainingClass())) {
                        if (ejbMethodRole.getEnterpriseBean() == null) continue;
                        ContainerUtil.addIfNotNull(dependencyItemsList, (Object)ejbMethodRole.getEnterpriseBean().getEjbClass().getValue());
                        ContainerUtil.addIfNotNull(dependencyItemsList, (Object)ejbMethodRole.getFacet().getModificationTracker());
                    }
                }
                for (EjbMethodRole ejbMethodRole : roles) {
                    if (!(ejbMethodRole instanceof EjbDeclMethodRole)) continue;
                    PsiClass ejbClass = (PsiClass)ejbMethodRole.getEnterpriseBean().getEjbClass().getValue();
                    Object[] psiMethods = ((EjbDeclMethodRole)ejbMethodRole).findImplementationsInEjbClass();
                    methodMap.put(ejbClass, psiMethods);
                    ContainerUtil.addAll(methodList, (Object[])psiMethods);
                    ContainerUtil.addIfNotNull(dependencyItemsList, (Object)ejbClass);
                    ContainerUtil.addAllNotNull(dependencyItemsList, (Iterable)EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejbMethodRole.getEnterpriseBean(), (boolean)false, (boolean)true, (boolean)true));
                    ContainerUtil.addIfNotNull(dependencyItemsList, (Object)ejbMethodRole.getFacet().getModificationTracker());
                }
                dependencyItemsList.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                Object[] methods = methodList.size() == 0 ? PsiMethod.EMPTY_ARRAY : methodList.toArray(new PsiMethod[methodList.size()]);
                methodMap.put(containingClass, methods);
                ContainerUtil.addAllNotNull(dependencyItemsList, (Object[])methods);
                Object[] dependencies = dependencyItemsList.toArray();
                return new CachedValueProvider.Result(methodMap, dependencies);
            }, false);
            method.putUserData(EJB_IMPLEMENTATIONS_KEY, (Object)cachedValue);
        }
        Map map = (Map)cachedValue.getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbImplementationsMap"));
        }
        return map;
    }

    public static boolean isSpecialEjbClassMethod(String methodName) {
        return specialEjbClassMethods.contains(methodName);
    }

    private static boolean showRenameFieldDialog(PsiMethod psiMethod, EjbMethodRole role, String fieldTitle) {
        String name = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)2);
        int response = Messages.showYesNoDialog((String)J2EEBundle.message((String)"message.text.method.name.is.role.do.you.want.to.rename.fieldtitle", (Object[])new Object[]{name, role.getTitle(), fieldTitle}), (String)J2EEBundle.message((String)"message.title.fielddescription.found", (Object[])new Object[]{fieldTitle}), (Icon)Messages.getQuestionIcon());
        return response == 0;
    }

    public static CmpField findCmpField(EnterpriseBean ejb, PsiMethod psiMethod) {
        if (!(ejb instanceof EntityBean)) {
            return null;
        }
        return EjbUtil.findCmpField((EntityBean)ejb, EjbUtil.getEjbFieldNameByAccessor(psiMethod));
    }

    public static CmrField findCmrField(EnterpriseBean ejb, PsiMethod psiMethod) {
        if (!(ejb instanceof EntityBean)) {
            return null;
        }
        return EjbUtil.findCmrField((EntityBean)ejb, EjbUtil.getEjbFieldNameByAccessor(psiMethod));
    }

    public static void tuneMethodForEjb(EjbClassRole classRole, PsiMethod method, PsiMethod result) throws IncorrectOperationException {
        EjbClassRole oldClassRole;
        EjbMethodRoleImpl methodRole;
        if (classRole != null) {
            switch (classRole.getType()) {
                case EJB_CLASS_ROLE_EJB_CLASS: 
                case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: 
                case EJB_CLASS_ROLE_LOCAL_INTERFACE: 
                case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: 
                case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: 
                case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                    PsiUtil.removeException((PsiMethod)result, (String)"java.rmi.RemoteException");
                    break;
                }
                case EJB_CLASS_ROLE_HOME_INTERFACE: 
                case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                    PsiUtil.addException((PsiMethod)result, (String)"java.rmi.RemoteException");
                }
            }
        }
        EjbMethodRoleImpl ejbMethodRoleImpl = methodRole = (oldClassRole = EjbHelper.getEjbHelper().getEjbRole(method.getContainingClass())) == null ? null : EjbMethodRoleImpl.suggestMethodRole(oldClassRole, method);
        if (methodRole == null) {
            return;
        }
        if (methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) {
            EjbUtil.tuneEjbFinderMethod(methodRole, classRole, result);
        } else if (methodRole.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) {
            EjbUtil.tuneEjbCreateMethod(methodRole.getEnterpriseBean(), classRole, result);
        }
    }

    private static void tuneEjbFinderMethod(EjbMethodRole methodRole, EjbClassRole classRole, PsiMethod methodCopy) throws IncorrectOperationException {
        EnterpriseBean bean = methodRole.getEnterpriseBean();
        if (bean instanceof EntityBean && classRole != null) {
            EjbUtil.setReturnType(methodCopy, EjbUtil.getNewEjbFinderReturnType(methodCopy, classRole, (EntityBean)bean));
        }
        PsiUtil.addException((PsiMethod)methodCopy, (String)"javax.ejb.FinderException");
    }

    private static void setReturnType(PsiMethod method, PsiType returnType) throws IncorrectOperationException {
        if (returnType != null) {
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            assert (returnTypeElement != null) : method.getText();
            returnTypeElement.replace((PsiElement)JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createTypeElement(returnType));
        }
    }

    private static PsiType getNewEjbFinderReturnType(PsiMethod methodCopy, EjbClassRole classRole, EntityBean entityBean) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)methodCopy.getProject()).getElementFactory();
        String methodCopyName = methodCopy.getName();
        if (methodCopyName.startsWith(EJB_FIND) && classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) {
            PsiClass primaryKey = (PsiClass)entityBean.getPrimKeyClass().getValue();
            if (primaryKey != null && !EjbUtil.isCollectionFinderMethod(methodCopy)) {
                return factory.createType(primaryKey);
            }
        } else if (methodCopyName.startsWith(FIND_REFIX)) {
            if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) {
                return factory.createType((PsiClass)entityBean.getRemote().getValue());
            }
            if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE) {
                return factory.createType((PsiClass)entityBean.getLocal().getValue());
            }
        }
        return null;
    }

    public static boolean isCollectionFinderMethod(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        return returnType != null && (returnType.equalsToText("java.util.Collection") || returnType.equalsToText(ENUMERATION_CLASS));
    }

    private static void tuneEjbCreateMethod(EnterpriseBean ejb, EjbClassRole classRole, PsiMethod methodCopy) throws IncorrectOperationException {
        EjbUtil.setReturnType(methodCopy, EjbUtil.getNewEjbCreateReturnType(ejb, classRole, methodCopy));
        PsiUtil.addException((PsiMethod)methodCopy, (String)"javax.ejb.CreateException");
    }

    private static PsiType getNewEjbCreateReturnType(EnterpriseBean ejb, EjbClassRole classRole, PsiMethod methodCopy) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)methodCopy.getProject()).getElementFactory();
        if (classRole != null) {
            if (methodCopy.getName().startsWith(EJB_CREATE_PREFIX) && ejb instanceof EntityBean && classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) {
                EntityBean entityBean = (EntityBean)ejb;
                PsiClass primaryKey = (PsiClass)entityBean.getPrimKeyClass().getValue();
                if (primaryKey != null) {
                    return factory.createType(primaryKey);
                }
            } else if (methodCopy.getName().startsWith(CREATE_PREFIX) && ejb instanceof EjbWithHome) {
                EjbWithHome ejbWithHome = (EjbWithHome)ejb;
                if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) {
                    return factory.createType((PsiClass)ejbWithHome.getRemote().getValue());
                }
                if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE) {
                    return factory.createType((PsiClass)ejbWithHome.getLocal().getValue());
                }
            }
        }
        return PsiType.VOID;
    }

    public static boolean isTypeRMICompatible(PsiType type, Project project) {
        if (type == null || type instanceof PsiPrimitiveType) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
        if (aClass == null) {
            return true;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(SERIALIZABLE, scope);
        PsiClass remoteClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(REMOTE, scope);
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)serializableClass, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)remoteClass, (boolean)true) || aClass.isInterface();
    }

    public static PsiMethod[] suggestImplementations(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        EjbClassRole classRole = containingClass == null ? null : EjbHelper.getEjbHelper().getEjbRole(containingClass);
        EjbMethodRoleImpl methodRole = classRole == null ? null : EjbMethodRoleImpl.suggestMethodRole(classRole, method);
        return methodRole instanceof EjbDeclMethodRoleImpl ? ((EjbDeclMethodRole)methodRole).suggestImplementations() : PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiMethod getEjbCreateMethodPrototype(String methodName, EnterpriseBean ejb, PsiMethod srcMethod) {
        if (ejb == null) {
            return null;
        }
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        if (ejbClass == null) {
            return null;
        }
        try {
            PsiManager psiManager = ejbClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiType returnType = EjbUtil.getReturnType(ejb, methodName, factory);
            if (srcMethod == null || srcMethod.getReturnTypeElement() == null) {
                srcMethod = factory.createMethodFromText("public void a() {}", null);
            }
            PsiMethod createMethod = (PsiMethod)srcMethod.copy();
            EjbUtil.setReturnType(createMethod, returnType);
            createMethod.getNameIdentifier().replace((PsiElement)factory.createIdentifier(methodName));
            EjbClassRoleImpl role = new EjbClassRoleImpl(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, ejb, null);
            EjbUtil.tuneEjbCreateMethod(ejb, role, createMethod);
            String bodyText = returnType.equals(PsiType.VOID) ? "{}" : "{return null;}";
            EjbUtil.setMethodBody(createMethod, factory.createCodeBlockFromText(bodyText, (PsiElement)createMethod));
            PsiUtil.addException((PsiMethod)createMethod, (String)"javax.ejb.CreateException");
            PsiUtil.removeException((PsiMethod)createMethod, (String)"java.rmi.RemoteException");
            createMethod = (PsiMethod)JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).shortenClassReferences((PsiElement)createMethod);
            createMethod = (PsiMethod)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)createMethod);
            return createMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void setMethodBody(PsiMethod method, PsiCodeBlock body) throws IncorrectOperationException {
        PsiCodeBlock createMethodBody = method.getBody();
        if (createMethodBody != null) {
            if (body == null) {
                createMethodBody.delete();
            } else {
                createMethodBody.replace((PsiElement)body);
            }
        } else if (body != null) {
            method.add((PsiElement)body);
        }
    }

    private static PsiType getReturnType(EnterpriseBean ejb, String methodName, PsiElementFactory factory) {
        PsiClass pkClass;
        if (ejb instanceof EntityBean && methodName.startsWith(EJB_CREATE_PREFIX) && (pkClass = (PsiClass)((EntityBean)ejb).getPrimKeyClass().getValue()) != null) {
            return factory.createType(pkClass);
        }
        return PsiType.VOID;
    }

    @Nullable
    public static PsiMethod getEjbCMPAccessorPrototype(CmpField cmpField, boolean isGetter) {
        EntityBean ejb = cmpField.getEntityBean();
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        if (ejbClass == null) {
            return null;
        }
        try {
            String bodyText;
            PsiMethod accessor;
            PsiManager psiManager = ejbClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiType cmpType = EjbUtil.findType(cmpField);
            if (cmpType == null) {
                cmpType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
            }
            String cmpFieldName = (String)cmpField.getFieldName().getValue();
            if (isGetter) {
                accessor = factory.createMethod(JavaeeUtil.suggestGetterName(cmpFieldName), cmpType);
                bodyText = "{ return " + PsiTypesUtil.getDefaultValueOfType((PsiType)cmpType) + "; }";
            } else {
                accessor = factory.createMethod(JavaeeUtil.suggestSetterName(cmpFieldName), (PsiType)PsiType.VOID);
                PsiParameter parameter = factory.createParameter("value", cmpType);
                accessor.getParameterList().add((PsiElement)parameter);
                bodyText = "{ }";
            }
            if (ejb.getCmpVersion().getValue() == CmpVersion.CmpVersion_2_X) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"abstract", (boolean)true);
                EjbUtil.setMethodBody(accessor, null);
            } else {
                EjbUtil.setMethodBody(accessor, factory.createCodeBlockFromText(bodyText, (PsiElement)accessor));
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"public", (boolean)true);
            return accessor;
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static PsiMethod getEjbCMRAccessorPrototype(CmrField cmrField, boolean isGetter, PsiClass ejbClass) {
        String name = (String)cmrField.getCmrFieldName().getValue();
        return name == null ? null : EjbUtil.getEjbCMRAccessorPrototype(ejbClass, EjbUtil.findClass(cmrField), isGetter, name);
    }

    private static PsiMethod getEjbCMRAccessorPrototype(PsiClass ejbClass, PsiClass cmrFieldClass, boolean isGetter, String name) {
        try {
            PsiMethod accessor;
            if (cmrFieldClass == null) {
                return null;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ejbClass.getProject()).getElementFactory();
            PsiClassType cmrType = factory.createType(cmrFieldClass);
            if (isGetter) {
                accessor = factory.createMethod(JavaeeUtil.suggestGetterName(name), (PsiType)cmrType);
            } else {
                accessor = factory.createMethod(JavaeeUtil.suggestSetterName(name), (PsiType)PsiType.VOID);
                PsiParameter parameter = factory.createParameter("value", (PsiType)cmrType);
                accessor.getParameterList().add((PsiElement)parameter);
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"abstract", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"public", (boolean)true);
            EjbUtil.setMethodBody(accessor, null);
            return accessor;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static PsiMethod[] getFieldAccessors(EntityBean ejb, String name, PsiType type) {
        ArrayList result = new ArrayList();
        ContainerUtil.addAll(result, (Object[])EjbUtil.getFieldAccessors((PsiClass)ejb.getLocal().getValue(), name, type));
        ContainerUtil.addAll(result, (Object[])EjbUtil.getFieldAccessors((PsiClass)ejb.getRemote().getValue(), name, type));
        ContainerUtil.addAll(result, (Object[])EjbUtil.getFieldAccessors((PsiClass)ejb.getEjbClass().getValue(), name, type));
        return result.toArray(new PsiMethod[result.size()]);
    }

    private static PsiMethod[] getFieldAccessors(PsiClass aClass, String name, PsiType type) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        if (aClass != null) {
            PsiMethod setter;
            PsiMethod getter = EjbUtil.findGetter(aClass, name, type, true);
            if (getter != null) {
                result.add(getter);
            }
            if ((setter = EjbUtil.findSetter(aClass, name, type, true)) != null) {
                result.add(setter);
            }
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @Nullable
    public static PsiMethod findGetter(PsiClass aClass, String name, PsiType type, boolean checkSuperClasses) {
        if (aClass == null || Comparing.strEqual((String)name, null)) {
            return null;
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)JavaeeUtil.suggestGetterName(name), (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiMethod method = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)methodSignature, (boolean)checkSuperClasses);
        if (method == null) {
            return null;
        }
        return type == null || Comparing.equal((Object)type, (Object)method.getReturnType()) ? method : null;
    }

    @Nullable
    public static PsiMethod findSetter(PsiClass aClass, String name, PsiType type, boolean checkSuperClasses) {
        PsiMethod method;
        if (aClass == null || Comparing.strEqual((String)name, null)) {
            return null;
        }
        if (type != null) {
            MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)JavaeeUtil.suggestSetterName(name), (PsiType[])new PsiType[]{type}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            method = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)methodSignature, (boolean)checkSuperClasses);
        } else {
            PsiMethod[] methods = aClass.findMethodsByName(JavaeeUtil.suggestSetterName(name), checkSuperClasses);
            PsiMethod psiMethod = method = methods.length == 0 ? null : methods[0];
        }
        if (method == null) {
            return null;
        }
        return PsiType.VOID.equals((Object)method.getReturnType()) ? method : null;
    }

    @Nullable
    public static String getEjbFieldNameByAccessor(PsiMethod accessor) {
        String fieldName;
        if (accessor == null) {
            return null;
        }
        String methodName = accessor.getName();
        if (methodName.startsWith("get")) {
            if (accessor.isConstructor()) {
                return null;
            }
            if (accessor.getParameterList().getParametersCount() != 0) {
                return null;
            }
            if (PsiType.VOID.equals((Object)accessor.getReturnType())) {
                return null;
            }
            fieldName = methodName.substring(3);
        } else if (methodName.startsWith("set")) {
            if (accessor.isConstructor()) {
                return null;
            }
            if (accessor.getParameterList().getParametersCount() != 1) {
                return null;
            }
            if (!PsiType.VOID.equals((Object)accessor.getReturnType())) {
                return null;
            }
            fieldName = methodName.substring(3);
        } else {
            return null;
        }
        if (fieldName.length() == 0) {
            return null;
        }
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
    }

    public static boolean isEjbFieldAccessor(PsiMethod method) {
        return EjbUtil.getEjbFieldNameByAccessor(method) != null;
    }

    public static boolean isCMP(EnterpriseBean ejb, CmpVersion cmpVersion) {
        return ejb instanceof EntityBean && ((EntityBean)ejb).getPersistenceType().getValue() == PersistenceType.CONTAINER && (cmpVersion == null || ((EntityBean)ejb).getCmpVersion().getValue() == cmpVersion || cmpVersion == CmpVersion.CmpVersion_1_X && ejb.getEjbVersion() == EjbDescriptorVersion.EJB_VERSION_1_X);
    }

    @Nullable
    public static PsiType findType(CmpField cmpField) {
        PsiParameter[] params;
        PsiClass ejbClass;
        PsiClass remote;
        EntityBean ejb = cmpField.getEntityBean();
        String fieldName = (String)cmpField.getFieldName().getValue();
        if (fieldName == null || ejb == null) {
            return null;
        }
        PsiMethod getter = null;
        PsiClass local = (PsiClass)ejb.getLocal().getValue();
        if (local != null) {
            getter = EjbUtil.findGetter(local, fieldName, null, true);
        }
        if (!((remote = (PsiClass)ejb.getRemote().getValue()) == null || getter != null && getter.hasModifierProperty("public"))) {
            getter = EjbUtil.findGetter(remote, fieldName, null, true);
        }
        if (!((ejbClass = (PsiClass)ejb.getEjbClass().getValue()) == null || getter != null && getter.hasModifierProperty("public"))) {
            getter = EjbUtil.findGetter(ejbClass, fieldName, null, true);
        }
        if (getter != null && getter.hasModifierProperty("public")) {
            return getter.getReturnType();
        }
        PsiMethod setter = null;
        if (local != null) {
            setter = EjbUtil.findSetter(local, fieldName, null, true);
        }
        if (!(remote == null || setter != null && setter.hasModifierProperty("public"))) {
            setter = EjbUtil.findSetter(remote, fieldName, null, true);
        }
        if (!(ejbClass == null || setter != null && setter.hasModifierProperty("public"))) {
            setter = EjbUtil.findSetter(ejbClass, fieldName, null, true);
        }
        if (setter != null && setter.hasModifierProperty("public") && (params = setter.getParameterList().getParameters()).length == 1) {
            return params[0].getType();
        }
        return null;
    }

    public static Collection<EjbFacet> getAllEjbFacets(Project project) {
        return JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, project);
    }

    @Nullable
    public static EjbFacet getEjbFacet(JavaeeModelElement element) {
        return element != null ? EjbModuleUtil.getEjbFacet((JavaeeModelElement)element) : null;
    }

    public static boolean isEjbVersion1x(JavaeeModelElement bean) {
        return EjbUtil.getVersion(bean) == EjbDescriptorVersion.EJB_VERSION_1_X;
    }

    @NotNull
    public static EjbDescriptorVersion getVersion(JavaeeModelElement element) {
        EjbFacet ejbFacet = EjbUtil.getEjbFacet(element);
        EjbDescriptorVersion ejbDescriptorVersion = ejbFacet != null ? EjbUtil.getVersion(ejbFacet) : (EjbUtil.areEjb31ClassesAvailable(element.getPsiManager().getProject()) ? EjbDescriptorVersion.EJB_VERSION_3_1 : EjbDescriptorVersion.EJB_VERSION_3_0);
        if (ejbDescriptorVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getVersion"));
        }
        return ejbDescriptorVersion;
    }

    @NotNull
    public static EjbDescriptorVersion getVersion(@NotNull EjbFacet ejbFacet) {
        if (ejbFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejbFacet", "com/intellij/javaee/ejb/EjbUtil", "getVersion"));
        }
        EjbJar ejbJar = ejbFacet.getXmlRoot();
        if (ejbJar == null) {
            Project project = ejbFacet.getModule().getProject();
            EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.areEjb31ClassesAvailable(project) ? EjbDescriptorVersion.EJB_VERSION_3_1 : EjbDescriptorVersion.EJB_VERSION_3_0;
            if (ejbDescriptorVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getVersion"));
            }
            return ejbDescriptorVersion;
        }
        EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.getEjbJarVersion(DomService.getInstance().getContainingFile((DomElement)ejbJar));
        if (ejbDescriptorVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getVersion"));
        }
        return ejbDescriptorVersion;
    }

    private static boolean areEjb31ClassesAvailable(Project project) {
        return JamCommonUtil.isClassAvailable((Project)project, (String)"javax.ejb.Singleton");
    }

    @NotNull
    public static EjbDescriptorVersion getEjbJarVersion(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
        }
        XmlDocument document = file.getDocument();
        if (document != null) {
            XmlDoctype doctype;
            XmlProlog prolog;
            XmlTag tag = document.getRootTag();
            if (tag != null && tag.isValid()) {
                String namespace = tag.getNamespace();
                if ("http://java.sun.com/xml/ns/javaee".equals(namespace)) {
                    String version = tag.getAttributeValue("version");
                    if ("3.0".equals(version)) {
                        EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_3_0;
                        if (ejbDescriptorVersion == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                        }
                        return ejbDescriptorVersion;
                    }
                    if ("3.1".equals(version)) {
                        EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_3_1;
                        if (ejbDescriptorVersion == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                        }
                        return ejbDescriptorVersion;
                    }
                    EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.areEjb31ClassesAvailable(file.getProject()) ? EjbDescriptorVersion.EJB_VERSION_3_1 : EjbDescriptorVersion.EJB_VERSION_3_0;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if ("http://java.sun.com/xml/ns/j2ee".equals(namespace)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_2_1;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if ("http://java.sun.com/dtd/ejb-jar_2_0.dtd".equals(namespace)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_2_0;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if ("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd".equals(namespace)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_1_X;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if ("http://java.sun.com/j2ee/dtds/ejb-jar_1_0.dtd".equals(namespace)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_1_X;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
            }
            if ((prolog = document.getProlog()) != null && (doctype = prolog.getDoctype()) != null && doctype.isValid()) {
                String publicId = doctype.getPublicId();
                if (EJB_JAR_2_0_DTD.equals(publicId)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_2_0;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if (EJB_JAR_1_1_DTD.equals(publicId)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_1_X;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                if (EJB_JAR_1_0_DTD.equals(publicId)) {
                    EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_1_X;
                    if (ejbDescriptorVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                    }
                    return ejbDescriptorVersion;
                }
                EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_2_0;
                if (ejbDescriptorVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
                }
                return ejbDescriptorVersion;
            }
        }
        EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.areEjb31ClassesAvailable(file.getProject()) ? EjbDescriptorVersion.EJB_VERSION_3_1 : EjbDescriptorVersion.EJB_VERSION_3_0;
        if (ejbDescriptorVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbJarVersion"));
        }
        return ejbDescriptorVersion;
    }

    @Nullable
    public static PsiType findType(CmrField cmrField) {
        PsiClass aClass = EjbUtil.findClass(cmrField);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
    }

    @Nullable
    public static PsiClass findClass(CmrField cmrField) {
        CmrFieldType fieldType = (CmrFieldType)cmrField.getCmrFieldType().getValue();
        if (fieldType != null) {
            PsiManager psiManager = cmrField.getPsiManager();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage("java.util");
            if (psiPackage == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(fieldType.getValue(), PackageScope.packageScope((PsiPackage)psiPackage, (boolean)false));
        }
        EntityBean targetEjb = cmrField.getOppositeEntity();
        return targetEjb == null ? null : (PsiClass)targetEjb.getLocal().getValue();
    }

    @Nullable
    public static CmrField findCmrField(EntityBean ejb, String name) {
        if (name == null) {
            return null;
        }
        ejb = (EntityBean)ModelMergerUtil.getImplementation((Object)ejb, com.intellij.javaee.model.xml.ejb.EntityBean.class);
        for (CmrField cmrField : ejb.getCmrFields()) {
            if (!Comparing.equal((String)((String)cmrField.getCmrFieldName().getValue()), (String)name)) continue;
            return cmrField;
        }
        return null;
    }

    @Nullable
    public static <T extends CmpField> T findCmpField(EntityBean ejb, String name) {
        if (name == null) {
            return null;
        }
        ejb = (EntityBean)ModelMergerUtil.getImplementation((Object)ejb, com.intellij.javaee.model.xml.ejb.EntityBean.class);
        for (CmpField field : ejb.getCmpFields()) {
            if (!Comparing.equal((String)((String)field.getFieldName().getValue()), (String)name)) continue;
            return (T)field;
        }
        return null;
    }

    public static boolean isPK(CmpField field) {
        PsiClass pkClass;
        EntityBean bean = field.getEntityBean();
        if (bean == null) {
            return false;
        }
        CmpField primkeyField = (CmpField)bean.getPrimkeyField().getValue();
        if (primkeyField != null) {
            return primkeyField.equals(field);
        }
        String name = (String)field.getFieldName().getValue();
        if (name != null && (pkClass = (PsiClass)bean.getPrimKeyClass().getValue()) != null) {
            for (PsiField field1 : pkClass.getFields()) {
                if (!name.equalsIgnoreCase(field1.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static EnterpriseBean findEjbByLink(JavaeeFacet facet, PsiClass psiInterface, String beanName) {
        List<EnterpriseBean> list = EjbUtil.findEjbsByLink(facet, psiInterface, beanName);
        return list.size() > 0 ? list.get(0) : null;
    }

    @NotNull
    public static List<EnterpriseBean> findEjbsByLink(@Nullable JavaeeFacet facet, PsiClass psiInterface, String beanName) {
        EnterpriseBean bean = EjbLinkResolveConverter.resolveEnterpriseBean((String)beanName, (JavaeeFacet)facet);
        if (bean != null) {
            List<EnterpriseBean> list = Collections.singletonList(bean);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbsByLink"));
            }
            return list;
        }
        if (psiInterface != null) {
            LinkedHashSet<EnterpriseBean> result = new LinkedHashSet<EnterpriseBean>();
            block3: for (EjbClassRole ejbClassRole : OldEjbRolesUtil.getEjbRoles(psiInterface)) {
                switch (ejbClassRole.getType()) {
                    case EJB_CLASS_ROLE_EJB_CLASS: 
                    case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: 
                    case EJB_CLASS_ROLE_LOCAL_INTERFACE: 
                    case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: 
                    case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: 
                    case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: 
                    case EJB_CLASS_ROLE_HOME_INTERFACE: 
                    case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                        EnterpriseBean ejb = ejbClassRole.getEnterpriseBean();
                        if (!StringUtil.isEmpty((String)beanName) && !Comparing.equal((String)beanName, (String)((String)ejb.getEjbName().getValue()))) continue block3;
                        result.add(ejb);
                    }
                }
            }
            ArrayList<EnterpriseBean> arrayList = new ArrayList<EnterpriseBean>(result);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbsByLink"));
            }
            return arrayList;
        }
        List<EnterpriseBean> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "findEjbsByLink"));
        }
        return list;
    }

    public static <T> T selectValue(EnterpriseBean ejb, T entityValue, T sessionValue, T messageDrivenValue) {
        if (ejb instanceof EntityBean) {
            return entityValue;
        }
        if (ejb instanceof SessionBean) {
            return sessionValue;
        }
        if (ejb instanceof MessageDrivenBean) {
            return messageDrivenValue;
        }
        throw new AssertionError((Object)ejb.getClass().getName());
    }

    public static <T> T selectValue(EnterpriseBean ejb, Function<EntityBean, T> entityValue, Function<SessionBean, T> sessionValue, Function<MessageDrivenBean, T> messageDrivenValue) {
        if (ejb instanceof EntityBean) {
            return (T)entityValue.fun((Object)((EntityBean)ejb));
        }
        if (ejb instanceof SessionBean) {
            return (T)sessionValue.fun((Object)((SessionBean)ejb));
        }
        if (ejb instanceof MessageDrivenBean) {
            return (T)messageDrivenValue.fun((Object)((MessageDrivenBean)ejb));
        }
        throw new AssertionError((Object)ejb.getClass().getName());
    }

    @Nullable
    public static <T extends EnterpriseBean> T findEjbByName(Module module, String name) {
        return (T)EjbUtil.findEjbByName(module.getProject(), module, name);
    }

    @Nullable
    public static Interceptor findInterceptorByClassName(InterceptorSet interceptorSet, String name) {
        if (name == null) {
            return null;
        }
        for (Interceptor interceptor : interceptorSet.getInterceptors()) {
            if (!name.equals(interceptor.getInterceptorClass().getStringValue())) continue;
            return interceptor;
        }
        return null;
    }

    @Nullable
    private static EnterpriseBean findEjbByName(Project project, @Nullable Module module, String name) {
        if (name == null) {
            return null;
        }
        for (EnterpriseBean enterpriseBean : EjbCommonModelUtil.getAllEjbs((Project)project, (Module)module, null)) {
            if (!name.equals(enterpriseBean.getEjbName().getValue())) continue;
            return enterpriseBean;
        }
        return null;
    }

    @Nullable
    public static EnterpriseBean findCommonEjbByName(@Nullable EjbFacet ejbFacet, String name) {
        if (ejbFacet != null) {
            return EjbUtil.findEjbByName(ejbFacet.getModule(), name);
        }
        return null;
    }

    public static List<CmpField> getPkFields(EntityBean ejb) {
        return ContainerUtil.findAll((Collection)ejb.getCmpFields(), object -> EjbUtil.isPK(object));
    }

    @Nullable
    public static EjbRelation findRelation(List<EjbRelation> list, String name) {
        return (EjbRelation)ContainerUtil.find(list.iterator(), object -> name.equals(object.getEjbRelationName().getValue()));
    }

    public static EntityBean getEntityBean(CmrField field) {
        return field.getOppositeField().getOppositeEntity();
    }

    public static void deleteModelElement(JavaeeModelElement element, JamUserResponse userResponse) {
        CommonModelManager.getInstance().deleteModelElement((CommonModelElement)element, userResponse);
    }

    @Nullable
    public static String getDisplayName(Object element) {
        return JamCommonUtil.getDisplayName((Object)element);
    }

    public static Collection<PsiElement> collectFieldAccessors(CmpField cmpField) {
        String name = (String)cmpField.getFieldName().getValue();
        if (name == null) {
            return Collections.emptyList();
        }
        EntityBean ejb = cmpField.getEntityBean();
        if (ejb == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (ejb.getCmpVersion().getValue() == CmpVersion.CmpVersion_1_X) {
            EjbUtil.collectProperty(result, (PsiClass)ejb.getEjbClass().getValue(), name);
        }
        PsiType type = EjbUtil.findType(cmpField);
        EjbUtil.collectPropertyAccessors(result, (PsiClass)ejb.getLocal().getValue(), false, name, type);
        EjbUtil.collectPropertyAccessors(result, (PsiClass)ejb.getRemote().getValue(), true, name, type);
        EjbUtil.collectPropertyAccessors(result, (PsiClass)ejb.getEjbClass().getValue(), false, name, type);
        return result;
    }

    private static void collectPropertyAccessors(ArrayList<PsiElement> result, PsiClass aClass, boolean isRemote, String name, PsiType type) {
        PsiMethod setter;
        if (aClass == null) {
            return;
        }
        PsiMethod getter = EjbUtil.findGetter(aClass, name, type, isRemote);
        if (getter != null) {
            result.add((PsiElement)getter);
        }
        if ((setter = EjbUtil.findSetter(aClass, name, type, isRemote)) != null) {
            result.add((PsiElement)setter);
        }
    }

    private static void collectProperty(List<PsiElement> list, PsiClass aClass, String name) {
        if (aClass == null) {
            return;
        }
        PsiField field = aClass.findFieldByName(name, false);
        if (field != null) {
            list.add((PsiElement)field);
        }
    }

    public static List<PsiElement> collectFieldAccessors(CmrField cmrField) {
        SmartList list = new SmartList();
        list.addAll(EjbRelationUtil.getGetters(cmrField));
        list.addAll(EjbRelationUtil.getSetters(cmrField));
        return list;
    }

    public static Collection<? extends EnvironmentGroup> getEnterpriseBeansAndInterceptors(VirtualFile virtualFile, Project project) {
        if (virtualFile instanceof EjbAsVirtualFile) {
            EjbAsVirtualFile ejbAsVirtualFile = (EjbAsVirtualFile)virtualFile;
            EnterpriseBean ejb = ejbAsVirtualFile.findElement(project);
            if (ejb != null) {
                return Collections.singletonList(ejb);
            }
        } else if (virtualFile instanceof InterceptorAsVirtualFile) {
            InterceptorAsVirtualFile ejbAsVirtualFile = (InterceptorAsVirtualFile)virtualFile;
            Interceptor interceptor = ejbAsVirtualFile.findElement(project);
            if (interceptor != null) {
                return Collections.singletonList(interceptor);
            }
        } else {
            ConfigFile descriptor;
            EjbFacet facet;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile instanceof PsiJavaFile) {
                return EjbUtil.getEnterpriseBeansAndInterceptors(psiFile);
            }
            if (psiFile != null && (facet = EjbUtil.getEjbFacet((PsiElement)psiFile)) != null && (descriptor = facet.getEjbJarDescriptor()) != null && descriptor.getXmlFile() == psiFile) {
                return EjbUtil.getAllEnvironmentGroups(project, null, facet);
            }
        }
        return Collections.emptyList();
    }

    public static Collection<EnvironmentGroup> getAllEnvironmentGroups(Project project, Module module, EjbFacet facet) {
        return EjbCommonModelUtil.mapEjbClassRoles(new ArrayList(), (Project)project, (Module)module, (EjbFacet)facet, (Function)((NullableFunction)ejbClassRole -> ejbClassRole.getInterceptor() == null ? ejbClassRole.getEnterpriseBean() : ejbClassRole.getInterceptor()));
    }

    @NotNull
    public static Set<? extends EnvironmentGroup> getEnterpriseBeansAndInterceptors(PsiFile psiFile) {
        if (!(psiFile instanceof PsiJavaFile) || !StdLanguages.JAVA.equals(psiFile.getLanguage())) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEnterpriseBeansAndInterceptors"));
            }
            return set;
        }
        HashSet<Object> result = new HashSet<Object>();
        PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
        for (PsiClass psiClass : psiJavaFile.getClasses()) {
            for (EjbClassRole ejbClassRole : OldEjbRolesUtil.getEjbRoles(psiClass)) {
                if (ejbClassRole.getEnterpriseBean() != null) {
                    result.add(ejbClassRole.getEnterpriseBean());
                    continue;
                }
                if (ejbClassRole.getInterceptor() == null) continue;
                result.add(ejbClassRole.getInterceptor());
            }
        }
        HashSet<Object> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEnterpriseBeansAndInterceptors"));
        }
        return hashSet;
    }

    public static PsiMethod[] findEjbDeclarations(PsiMethod method) {
        CachedValue cachedValue = (CachedValue)method.getUserData(EJB_DECLARATIONS_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)method.getProject()).createCachedValue(() -> {
                HashSet methodList = new HashSet();
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                EjbMethodRole[] roles = OldEjbRolesUtil.getEjbRoles(method);
                if (roles.length == 0) {
                    for (EjbMethodRole ejbMethodRole : OldEjbRolesUtil.getEjbRoles(method.getContainingClass())) {
                        EnterpriseBean ejb = ejbMethodRole.getEnterpriseBean();
                        if (ejb == null) continue;
                        dependencyItemsList.add(ejb.getEjbClass().getValue());
                        EjbFacet ejbFacet = ejbMethodRole.getFacet();
                        dependencyItemsList.add(ejbFacet.getModificationTracker());
                    }
                }
                for (EjbMethodRole ejbMethodRole : roles) {
                    if (!(ejbMethodRole instanceof EjbImplMethodRoleImpl)) continue;
                    ContainerUtil.addAll(methodList, (Object[])((EjbImplMethodRole)ejbMethodRole).findDeclarationsInEjb());
                    dependencyItemsList.add(ejbMethodRole.getEnterpriseBean().getEjbClass().getValue());
                    dependencyItemsList.add(ejbMethodRole.getFacet().getModificationTracker());
                }
                dependencyItemsList.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                PsiMethod[] methods = methodList.size() == 0 ? PsiMethod.EMPTY_ARRAY : methodList.toArray(new PsiMethod[methodList.size()]);
                Object[] dependencies = dependencyItemsList.toArray();
                return new CachedValueProvider.Result((Object)methods, dependencies);
            }, false);
            method.putUserData(EJB_DECLARATIONS_KEY, (Object)cachedValue);
        }
        return (PsiMethod[])cachedValue.getValue();
    }

    public static List<EjbClassRole> getEjbClassRolesByClass(PsiClass aClass, EnterpriseBean ejb) {
        EjbFacet facet = EjbUtil.getEjbFacet((PsiElement)aClass);
        SmartList list = new SmartList();
        boolean intf = aClass.isInterface();
        for (EjbClassRoleEnum type : EjbClassRoleEnum.values()) {
            boolean good = false;
            block0 : switch (type) {
                case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: {
                    PsiClass ejbClass;
                    if (!intf || !(ejb instanceof SessionBean)) break;
                    for (GenericValue value : ((SessionBean)ejb).getBusinessLocals()) {
                        ejbClass = (PsiClass)value.getValue();
                        if (ejbClass == null || ejbClass != aClass && !ejbClass.isInheritor(aClass, true)) continue;
                        good = true;
                        break block0;
                    }
                    break;
                }
                case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: {
                    PsiClass ejbClass;
                    if (!intf || !(ejb instanceof SessionBean)) break;
                    for (GenericValue value : ((SessionBean)ejb).getBusinessRemotes()) {
                        ejbClass = (PsiClass)value.getValue();
                        if (ejbClass == null || ejbClass != aClass && !ejbClass.isInheritor(aClass, true)) continue;
                        good = true;
                        break block0;
                    }
                    break;
                }
                case EJB_CLASS_ROLE_EJB_CLASS: {
                    if (intf) break;
                    PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
                    good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                    break;
                }
                case EJB_CLASS_ROLE_HOME_INTERFACE: {
                    if (!intf || !(ejb instanceof EjbWithHome)) break;
                    PsiClass ejbClass = (PsiClass)((EjbWithHome)ejb).getHome().getValue();
                    good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                    break;
                }
                case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                    if (!intf || !(ejb instanceof EjbWithHome)) break;
                    PsiClass ejbClass = (PsiClass)((EjbWithHome)ejb).getLocalHome().getValue();
                    good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                    break;
                }
                case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                    PsiClass ejbClass;
                    if (intf && ejb instanceof EjbWithHome) {
                        ejbClass = (PsiClass)((EjbWithHome)ejb).getLocal().getValue();
                        good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                        break;
                    }
                    if (!intf || !(ejb instanceof MessageDrivenBean) || (ejbClass = (PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue()) == null || ejbClass != aClass && !ejbClass.isInheritor(aClass, true)) break;
                    good = true;
                    break;
                }
                case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                    if (!intf || !(ejb instanceof EjbWithHome)) break;
                    PsiClass ejbClass = (PsiClass)((EjbWithHome)ejb).getRemote().getValue();
                    good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                    break;
                }
                case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                    if (!intf || !(ejb instanceof SessionBean)) break;
                    PsiClass ejbClass = (PsiClass)((SessionBean)ejb).getServiceEndpoint().getValue();
                    good = ejbClass != null && (ejbClass == aClass || ejbClass.isInheritor(aClass, true));
                    break;
                }
                case EJB_CLASS_ROLE_INTERCEPTOR_CLASS: {
                    break;
                }
            }
            if (!good) continue;
            list.add((Object)new EjbClassRoleImpl(type, ejb, facet));
        }
        return list;
    }

    public static boolean isTopLevelClass(PsiClass aClass, EjbClassRoleEnum type, EjbClassRole[] classRoles) {
        block11: for (EjbClassRole role : classRoles) {
            if (role.getType() != type) continue;
            EnterpriseBean ejb = role.getEnterpriseBean();
            Interceptor interceptor = role.getInterceptor();
            switch (type) {
                case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: {
                    if (!(ejb instanceof SessionBean)) continue block11;
                    for (GenericValue value : ((SessionBean)ejb).getBusinessLocals()) {
                        if (aClass != value.getValue()) continue;
                        return true;
                    }
                    continue block11;
                }
                case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: {
                    if (!(ejb instanceof SessionBean)) continue block11;
                    for (GenericValue value : ((SessionBean)ejb).getBusinessRemotes()) {
                        if (aClass != value.getValue()) continue;
                        return true;
                    }
                    continue block11;
                }
                case EJB_CLASS_ROLE_EJB_CLASS: {
                    if (aClass != ejb.getEjbClass().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_HOME_INTERFACE: {
                    if (!(ejb instanceof EjbWithHome) || aClass != ((EjbWithHome)ejb).getHome().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                    if (!(ejb instanceof EjbWithHome) || aClass != ((EjbWithHome)ejb).getLocalHome().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                    if (!(ejb instanceof EjbWithHome) || aClass != ((EjbWithHome)ejb).getLocal().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                    if (!(ejb instanceof EjbWithHome) || aClass != ((EjbWithHome)ejb).getRemote().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                    if (!(ejb instanceof SessionBean) || aClass != ((SessionBean)ejb).getServiceEndpoint().getValue()) continue block11;
                    return true;
                }
                case EJB_CLASS_ROLE_INTERCEPTOR_CLASS: {
                    if (aClass != interceptor.getInterceptorClass().getValue()) continue block11;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isInheritedFromInterface(PsiMethod psiMethod, PsiClass psiClass) {
        PsiMethod method = psiClass.findMethodBySignature(psiMethod, true);
        return method != null && psiMethod != method && !"java.lang.Object".equals(method.getContainingClass().getQualifiedName());
    }

    public static boolean isInheritedFromBusinessInterface(PsiMethod psiMethod, Collection<PsiClass> interfaces) {
        if (interfaces.contains(psiMethod.getContainingClass())) {
            return true;
        }
        for (PsiClass psiClass : interfaces) {
            if (!EjbUtil.isInheritedFromInterface(psiMethod, psiClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsStandardEjbInterface(EnterpriseBean ejb) {
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        String baseEjbInterface = EnterpriseBeanType.getEnterpriseBeanType(ejb).getStandardInterface();
        if (ejbClass == null || baseEjbInterface == null) {
            return false;
        }
        PsiClass basePsiClass = JavaPsiFacade.getInstance((Project)ejbClass.getProject()).findClass(baseEjbInterface, GlobalSearchScope.allScope((Project)ejbClass.getProject()));
        return basePsiClass != null && ejbClass.isInheritor(basePsiClass, true);
    }

    public static boolean isEjbModuleDescriptor(Project project, VirtualFile file) {
        Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project);
        if (moduleForFile == null) {
            return false;
        }
        EjbFacet facet = EjbModuleUtil.getEjbFacet((Project)project, (VirtualFile)file);
        if (facet == null) {
            return false;
        }
        ConfigFile deploymentDescriptor = facet.getEjbJarDescriptor();
        return deploymentDescriptor != null ? file.equals(deploymentDescriptor.getVirtualFile()) : false;
    }

    @Nullable
    public static CmpField getCmpField(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(xmlTag);
            if (CmpField.class.isInstance(domElement)) {
                return (CmpField)domElement;
            }
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            EjbMethodRole role = EjbHelper.getEjbHelper().getEjbRole(method);
            if (role == null || role.getEnterpriseBean() == null) {
                return null;
            }
            EjbMethodRoleEnum type = role.getType();
            if (type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_DECL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_IMPL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_DECL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_IMPL) {
                return null;
            }
            return EjbUtil.findCmpField(role.getEnterpriseBean(), method);
        }
        return null;
    }

    @Nullable
    public static CmrField getCmrField(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(xmlTag);
            if (CmrField.class.isInstance(domElement)) {
                return (CmrField)domElement;
            }
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            EjbMethodRole role = EjbHelper.getEjbHelper().getEjbRole(method);
            if (role == null || role.getEnterpriseBean() == null) {
                return null;
            }
            EjbMethodRoleEnum type = role.getType();
            if (type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_DECL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_IMPL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_DECL && type != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_IMPL) {
                return null;
            }
            return EjbUtil.findCmrField(role.getEnterpriseBean(), method);
        }
        return null;
    }

    public static void setEjbNameParameter(EnterpriseBean ejb, final @NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/javaee/ejb/EjbUtil", "setEjbNameParameter"));
        }
        final EjbBase domElement = (EjbBase)ModelMergerUtil.getImplementation((Object)ejb, EjbBase.class);
        final EnterpriseBeanImpl annoElement = (EnterpriseBeanImpl)((Object)ModelMergerUtil.getImplementation((Object)ejb, EnterpriseBeanImpl.class));
        new WriteCommandAction(ejb.getPsiManager().getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/ejb/EjbUtil$1", "run"));
                }
                EjbUtil.setEjbNameParameter(newName, domElement, annoElement);
            }
        }.execute();
    }

    private static void setEjbNameParameter(String newName, EjbBase domElement, EnterpriseBeanImpl annoElement) throws IncorrectOperationException {
        if (domElement != null && domElement.isValid() && !Comparing.equal((String)domElement.getEjbName().getStringValue(), (String)newName)) {
            domElement.getEjbName().setValue((Object)newName);
        }
        if (annoElement != null && annoElement.isValid() && annoElement.getEjbName() instanceof JamStringAttributeElement && !Comparing.equal((String)((String)annoElement.getEjbName().getValue()), (String)newName)) {
            annoElement.getEjbName().setStringValue(newName);
        }
    }

    @NotNull
    public static List<? extends EjbMethod> getEjbMethods(EnterpriseBean ejb) {
        List list = ejb.getEjbMethods();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getEjbMethods"));
        }
        return list;
    }

    @NotNull
    public static List<PsiClass> getComponentInterfaces(EnterpriseBean ejb, boolean remote) {
        List list = EjbCommonModelUtil.collectEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)false, (boolean)true, s -> ((EjbClassRoleEnum)s.getSecond()).isRemote() != remote ? null : (PsiClass)((GenericValue)s.getFirst()).getValue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/EjbUtil", "getComponentInterfaces"));
        }
        return list;
    }

    public static List<EjbBase> getAllEjbs(EnterpriseBeans set) {
        return EjbUtil.getAllEjbs((EnterpriseBeanSet)set);
    }

    public static List<EnterpriseBean> getAllEjbs(EnterpriseBeanSet set) {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        result.addAll(set.getEntities());
        result.addAll(set.getSessions());
        result.addAll(set.getMessageDrivens());
        return result;
    }

    @Nullable
    public static <T extends EnterpriseBean> T findEjbByName(EnterpriseBeans beanSet, String name) {
        for (EnterpriseBean enterpriseBean : EjbUtil.getAllEjbs(beanSet)) {
            if (!Comparing.equal((String)((String)enterpriseBean.getEjbName().getValue()), (String)name)) continue;
            return (T)enterpriseBean;
        }
        return null;
    }

    public static Set<String> getAllowedResourceTypeNames(PsiClass aClass) {
        String[] resourceTypes = new String[]{"java.lang.String", "char", "java.lang.Character", "int", "java.lang.Integer", "boolean", "java.lang.Boolean", "double", "java.lang.Double", "byte", "java.lang.Byte", "short", "java.lang.Short", "long", "java.lang.Long", "float", "java.lang.Float", "javax.sql.DataSource", "javax.resource.cci.ConnectionFactory", "javax.jms.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.jms.Destination", "javax.jms.Queue", "javax.jms.Topic", "javax.transaction.UserTransaction", "javax.transaction.TransactionSynchronizationRegistry", "javax.ejb.EJBContext", "javax.ejb.TimerService", "javax.mail.Session", "javax.naming.Context", "org.omg.CORBA.ORB"};
        TreeSet<String> typeSet = new TreeSet<String>(Arrays.asList(resourceTypes));
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(aClass)) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) {
                typeSet.add(EnterpriseBeanType.getEnterpriseBeanType(role.getEnterpriseBean()).getContextClassName());
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            for (EnterpriseBeanType t : EnterpriseBeanType.values()) {
                typeSet.add(t.getContextClassName());
            }
        }
        return typeSet;
    }

    @Nullable
    public static EjbDescriptorVersion getMaxEjbVersion(PsiClass psiClass) {
        EjbDescriptorVersion maxVersion = null;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EnterpriseBean environmentGroup = role.getInterceptor() == null ? role.getEnterpriseBean() : role.getInterceptor();
            EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.getVersion((JavaeeModelElement)environmentGroup);
            if (maxVersion != null && maxVersion.compareTo((Enum)ejbDescriptorVersion) >= 0) continue;
            maxVersion = ejbDescriptorVersion;
        }
        return maxVersion;
    }

    public static ConfigFileVersion getDescriptorVersion(EjbDescriptorVersion version) {
        return EjbUtil.getDescriptorVersion(version.getValue());
    }

    public static ConfigFileVersion getDescriptorVersion(String version) {
        return ConfigFileUtil.getVersionByName((ConfigFileMetaData)EjbRootDescriptor.EJB_JAR_META_DATA, (String)version);
    }
}

