/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb;

import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.EjbType;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbClassesPropertiesPanel;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CreateNewEjbDialog
extends DialogWrapper {
    private final EjbDataHolder myEjbInfo;
    private final EjbClassesPropertiesPanel myEjbClassesPropertiesPanel;

    public CreateNewEjbDialog(Project project, EjbDataHolder ejbInfo, EjbFacet ejbFacet) {
        super(project, true);
        this.myEjbInfo = ejbInfo;
        this.myEjbClassesPropertiesPanel = new EjbClassesPropertiesPanel(ejbFacet.getMergedRoot(), this.myEjbInfo, project, true, true){

            @Override
            protected void updateOKAction() {
                CreateNewEjbDialog.this.setOKActionEnabled(this.isOKActionEnabled());
            }
        };
        this.setTitle(J2EEBundle.message((String)"dialog.title.new.typename", (Object[])new Object[]{this.getCreatedTypeName()}));
        this.init();
    }

    private String getCreatedTypeName() {
        switch (this.myEjbInfo.getEjbType()) {
            case Entity: {
                if (this.myEjbInfo.getPersistenceType() == PersistenceType.BEAN) {
                    return J2EEBundle.message((String)"ejb.type.bmp.entity.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getPersistenceType() == PersistenceType.CONTAINER) {
                    return J2EEBundle.message((String)"ejb.type.cmp.entity.bean", (Object[])new Object[0]);
                }
                return J2EEBundle.message((String)"ejb.type.entity.bean", (Object[])new Object[0]);
            }
            case Session: {
                if (this.myEjbInfo.getSessionType() == SessionType.STATEFUL) {
                    return J2EEBundle.message((String)"ejb.type.stateful.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getSessionType() == SessionType.STATELESS) {
                    return J2EEBundle.message((String)"ejb.type.stateless.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getSessionType() == SessionType.SINGLETON) {
                    return J2EEBundle.message((String)"ejb.type.singleton.bean", (Object[])new Object[0]);
                }
                return J2EEBundle.message((String)"ejb.type.session.bean", (Object[])new Object[0]);
            }
        }
        return J2EEBundle.message((String)"ejb.type.message.bean", (Object[])new Object[0]);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/CreateNewEjbDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        String helpId = this.myEjbInfo.getEjbType() == EjbType.Message ? "reference.javaee.new-message-bean" : (this.myEjbInfo.getEjbType() == EjbType.Session ? "reference.javaee.new-session-bean" : (this.myEjbInfo.getPersistenceType() == PersistenceType.BEAN ? "reference.javaee.new-bmp-bean" : "reference.javaee.new-cmp-bean"));
        HelpManager.getInstance().invokeHelp(helpId);
    }

    protected void doOKAction() {
        this.myEjbClassesPropertiesPanel.saveEjbInfo();
        if (!this.myEjbClassesPropertiesPanel.isDataValid()) {
            return;
        }
        super.doOKAction();
    }

    public EjbDataHolder getEjbInfo() {
        return this.myEjbInfo;
    }

    protected JComponent createCenterPanel() {
        return this.myEjbClassesPropertiesPanel.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEjbClassesPropertiesPanel.getPreferredFocusedComponent();
    }
}

