/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.actions;

import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.module.view.ejb.InterceptorBindingsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;

public class EditInterceptorBindingsAction
extends AnAction {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Interceptor target = (Interceptor)dataContext.getData("InterceptorImpl");
        boolean enabled = project != null && target != null && target.getInterceptorClass().getValue() != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Interceptor target = (Interceptor)dataContext.getData("InterceptorImpl");
        assert (target != null);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass targetClass = (PsiClass)target.getInterceptorClass().getValue();
        assert (targetClass != null);
        EjbFacet ejbFacet = null;
        for (EjbClassRole role : EjbHelper.getEjbHelper().getEjbRoles(targetClass)) {
            if (role.getInterceptor() != target) continue;
            ejbFacet = role.getFacet();
            break;
        }
        assert (ejbFacet != null);
        InterceptorBindingsDialog dialog = new InterceptorBindingsDialog(project, targetClass.getQualifiedName(), ejbFacet);
        dialog.show();
    }
}

