/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.server.AppServerLibrariesProviderImpl;
import com.intellij.javaee.oss.server.JavaeeDeploymentModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeIntegration
extends AppServerIntegration {
    private static final Logger LOG = Logger.getInstance(JavaeeIntegration.class);
    private JavaeeServerHelper myServerHelper;
    private JavaeeDescriptorsManager myDescriptorsManager;
    private ApplicationServerUrlMapping myUrlMapping;

    public String getPresentableName() {
        return JavaeeBundle.getText("Integration.name", this.getName());
    }

    @NotNull
    public ApplicationServerHelper getApplicationServerHelper() {
        if (this.myServerHelper == null) {
            this.myServerHelper = this.createServerHelper();
        }
        JavaeeServerHelper javaeeServerHelper = this.myServerHelper;
        if (javaeeServerHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeIntegration", "getApplicationServerHelper"));
        }
        return javaeeServerHelper;
    }

    protected JavaeeServerHelper createServerHelper() {
        return new JavaeeServerHelper(this);
    }

    public ApplicationServerPersistentDataEditor createNewServerEditor() {
        return this.getApplicationServerHelper().createConfigurable();
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JavaeeDeploymentProvider();
    }

    @NotNull
    public ApplicationServerUrlMapping getDeployedFileUrlProvider() {
        if (this.myUrlMapping == null) {
            final WebFacetContextProvider webFacetContextProvider = new WebFacetContextProvider(){

                protected String getContextServerSpecific(@NotNull DeploymentModel deploymentModel, @NotNull WebFacet facet) {
                    if (deploymentModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/oss/server/JavaeeIntegration$1", "getContextServerSpecific"));
                    }
                    if (facet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/oss/server/JavaeeIntegration$1", "getContextServerSpecific"));
                    }
                    String facetContext = JavaeeIntegration.this.getContextRoot((JavaeeFacet)facet);
                    if (StringUtil.isNotEmpty((String)facetContext)) {
                        return facetContext;
                    }
                    return ((JavaeeServerModel)deploymentModel.getServerModel()).getServerSpecificContext(deploymentModel);
                }
            };
            this.myUrlMapping = new ApplicationServerUrlMapping(){

                protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
                    super.collectFacetContextProviders(facetContextProvider);
                    facetContextProvider.add((FacetContextProvider)webFacetContextProvider);
                }

                protected void collectWebModuleContextProviders(List<WebModuleContextProvider> webModuleContextProviders) {
                    if (JavaeeIntegration.this instanceof WebModuleContextProvider) {
                        webModuleContextProviders.add((WebModuleContextProvider)JavaeeIntegration.this);
                    }
                    super.collectWebModuleContextProviders(webModuleContextProviders);
                }
            };
        }
        ApplicationServerUrlMapping applicationServerUrlMapping = this.myUrlMapping;
        if (applicationServerUrlMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeIntegration", "getDeployedFileUrlProvider"));
        }
        return applicationServerUrlMapping;
    }

    public JavaeeDescriptorsManager getDescriptorsManager() {
        if (this.myDescriptorsManager == null) {
            this.myDescriptorsManager = new JavaeeDescriptorsManager(this);
            this.collectDescriptors(this.myDescriptorsManager);
        }
        return this.myDescriptorsManager;
    }

    @Nullable
    public AppServerLibrariesProvider createLibrariesProvider(@NotNull ApplicationServerPersistentData persistentData) {
        if (persistentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentData", "com/intellij/javaee/oss/server/JavaeeIntegration", "createLibrariesProvider"));
        }
        if (!(persistentData instanceof JavaeePersistentData)) {
            return null;
        }
        if (this.getFrameworkLibrariesDescriptionPath() == null && this.getFrameworkLibrariesDescriptionRemoteName() == null) {
            return null;
        }
        return new AppServerLibrariesProviderImpl(this, (JavaeePersistentData)persistentData);
    }

    protected abstract void collectDescriptors(JavaeeDescriptorsManager var1);

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract Icon getBigIcon();

    @Nullable
    @NonNls
    public abstract String getNameFromTemplate(String var1) throws Exception;

    @Nullable
    @NonNls
    public abstract String getVersionFromTemplate(String var1) throws Exception;

    @NotNull
    @NonNls
    public abstract String getServerVersion(JavaeePersistentData var1) throws Exception;

    @NotNull
    @NonNls
    public String getServerVersionSilently(JavaeePersistentData persistentData) {
        String string;
        try {
            string = this.getServerVersion(persistentData);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeIntegration", "getServerVersionSilently"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeIntegration", "getServerVersionSilently"));
        }
        return string;
    }

    protected abstract void checkValidServerHome(String var1, String var2) throws Exception;

    protected void addLibraryLocations(JavaeePersistentData persistentData, List<File> locations) {
        this.addLibraryLocations(persistentData.HOME, locations);
    }

    protected abstract void addLibraryLocations(String var1, List<File> var2);

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return classes.isEmpty();
    }

    protected static boolean allLibrariesExceptEjbFound(Collection<String> classes, Function<String, String> mapper) {
        boolean all = classes.isEmpty();
        if (!all && classes.size() == 1) {
            all = ((String)mapper.fun((Object)"javax.ejb.EntityBean")).equals(classes.iterator().next());
        }
        return all;
    }

    public static void checkFile(@NonNls String home, @NonNls String path) throws IOException {
        if (!new File(home, path).exists()) {
            throw new FileNotFoundException(JavaeeBundle.getText("Error.fileNotFound", path));
        }
    }

    public static void checkDir(File dir) throws FileNotFoundException {
        if (!dir.isDirectory()) {
            throw new FileNotFoundException(JavaeeBundle.getText("JavaeeIntegration.message.text.cant.find.directory", dir.getAbsolutePath()));
        }
    }

    @Nullable
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new JavaeeDeploymentModel(commonModel, source);
    }

    @NotNull
    public String detectVersion(JavaeePersistentData data) throws Exception {
        String result = this.getServerVersion(data);
        this.checkValidServerHome(data.HOME, result);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeIntegration", "detectVersion"));
        }
        return string;
    }

    @Nullable
    public abstract String getContextRoot(JavaeeFacet var1);

    public boolean isStartupScriptTerminating(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupScript", "com/intellij/javaee/oss/server/JavaeeIntegration", "isStartupScriptTerminating"));
        }
        return this.isStartupScriptTerminating();
    }

    public boolean isStartupScriptTerminating() {
        return false;
    }

    public boolean isAsyncWrapped() {
        return false;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionPath() {
        String directoryName = this.getFrameworkLibrariesDescriptionRemoteName();
        return directoryName != null ? "/libraries/" + directoryName + ".xml" : null;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionRemoteName() {
        return null;
    }
}

