/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.localRun;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.localRun.ScriptParser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class UserScriptPanel {
    private final TextFieldWithBrowseButton myPathField = new TextFieldWithBrowseButton();
    private final JPanel myPanel;
    private final FixedSizeButton mySetParametersButton;
    private String myInitialProgramParameters;

    public UserScriptPanel(String title, FileChooserDescriptor fileChooserDescriptor) {
        this.myPathField.addBrowseFolderListener(title, null, null, fileChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return new ScriptParser(component.getText()).getPath();
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javaee/run/localRun/UserScriptPanel$1", "setText"));
                }
                ScriptParser scriptParser = new ScriptParser(component.getText());
                String parameters = scriptParser.isValid() ? scriptParser.getParameters() : UserScriptPanel.this.myInitialProgramParameters;
                component.setText(new ScriptParser(text, parameters).combine());
            }
        });
        FileChooserFactory.getInstance().installFileCompletion(this.myPathField.getTextField(), fileChooserDescriptor, true, null);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myPathField, "Center");
        this.mySetParametersButton = new FixedSizeButton((JComponent)this.myPathField.getTextField());
        this.mySetParametersButton.setIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        this.mySetParametersButton.setToolTipText(J2EEBundle.message((String)"tooltip.text.script.parameters", (Object[])new Object[0]));
        this.myPanel.add((Component)this.mySetParametersButton, "East");
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public JTextField getTextField() {
        return this.myPathField.getTextField();
    }

    public void setText(String text) {
        this.myPathField.getTextField().setText(text);
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public void addCustomizeParametersActionListener(ActionListener actionListener) {
        this.mySetParametersButton.addActionListener(actionListener);
    }

    public void setInitialProgramParameters(String initialProgramParameters) {
        this.myInitialProgramParameters = initialProgramParameters;
    }

    public ScriptParser createScriptParser() {
        return new ScriptParser(this.getText());
    }
}

