/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFrameworkSupportContributorBase
extends JavaeeFrameworkSupportContributor {
    protected boolean isApplicable(JavaeeFrameworkSupportContributionModel model) {
        return true;
    }

    protected void setupWebXml(WebApp webApp, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupEjbJarXml(EjbJar ejbJar, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupApplicationXml(JavaeeApplication application, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupExplodedWarArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/supportProvider/JavaeeFrameworkSupportContributorBase", "setupExplodedWarArtifact"));
        }
    }

    protected void setupExplodedEarArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/supportProvider/JavaeeFrameworkSupportContributorBase", "setupExplodedEarArtifact"));
        }
    }

    protected void setupExplodedEjbArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/supportProvider/JavaeeFrameworkSupportContributorBase", "setupExplodedEjbArtifact"));
        }
    }

    protected void setupServerRunConfiguration(@NotNull CommonModel commonModel, JavaeeFrameworkSupportContributionModel model) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/supportProvider/JavaeeFrameworkSupportContributorBase", "setupServerRunConfiguration"));
        }
    }

    protected void setupAppFacet(JavaeeApplicationFacet appFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupEjbFacet(EjbFacet ejbFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupWebFacet(WebFacet webFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    public void setupFrameworkSupport(JavaeeFrameworkSupportContributionModel model) {
        if (!this.isApplicable(model)) {
            return;
        }
        this.setupArtifacts(model);
        this.setupFacets(model);
        CommonModel runConfiguration = model.getRunConfiguration();
        if (runConfiguration != null) {
            this.setupServerRunConfiguration(runConfiguration, model);
        }
    }

    private void setupFacets(JavaeeFrameworkSupportContributionModel model) {
        JavaeeApplicationFacet appFacet;
        EjbFacet ejbFacet;
        WebFacet webFacet = (WebFacet)model.getFacet(WebFacet.ID);
        if (webFacet != null) {
            this.setupWebFacet(webFacet, model);
        }
        if ((ejbFacet = (EjbFacet)model.getFacet(EjbFacet.ID)) != null) {
            this.setupEjbFacet(ejbFacet, model);
        }
        if ((appFacet = (JavaeeApplicationFacet)model.getFacet(JavaeeApplicationFacet.ID)) != null) {
            this.setupAppFacet(appFacet, model);
        }
        StartupManager.getInstance((Project)model.getProject()).runWhenProjectIsInitialized(() -> {
            JavaeeApplication root;
            EjbJar ejbJar;
            WebApp webApp;
            if (webFacet != null && (webApp = webFacet.getRoot()) != null) {
                this.setupWebXml(webApp, model);
            }
            if (ejbFacet != null && (ejbJar = ejbFacet.getXmlRoot()) != null) {
                this.setupEjbJarXml(ejbJar, model);
            }
            if (appFacet != null && (root = appFacet.getRoot()) != null) {
                this.setupApplicationXml(root, model);
            }
        });
    }

    private void setupArtifacts(JavaeeFrameworkSupportContributionModel model) {
        ModifiableArtifact earArtifact;
        ModifiableArtifact ejbArtifact;
        ModifiableArtifact warArtifact = model.getModifiableExplodedWarArtifact();
        if (warArtifact != null) {
            this.setupExplodedWarArtifact(warArtifact, model);
        }
        if ((ejbArtifact = model.getModifiableExplodedEjbArtifact()) != null) {
            this.setupExplodedEjbArtifact(ejbArtifact, model);
        }
        if ((earArtifact = model.getModifiableExplodedEarArtifact()) != null) {
            this.setupExplodedEarArtifact(earArtifact, model);
        }
    }
}

