/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerDescriptorsMetaDataProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAppServerDescriptorDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JComboBox myAppServerBox;
    private JComboBox myVersionBox;
    private JComboBox myDescriptorBox;
    private final MultiValuesMap<AppServerIntegration, ConfigFileMetaData> myIntegration2MetaData;

    public CreateAppServerDescriptorDialog(Component parent, AppServerDescriptorsMetaDataProvider metaDataProvider, @NotNull DescriptorMetaDataFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/javaee/ui/CreateAppServerDescriptorDialog", "<init>"));
        }
        super(parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(J2EEBundle.message((String)"dialog.title.create.appserver.specific.descriptor", (Object[])objectArray));
        this.init();
        this.myIntegration2MetaData = CreateAppServerDescriptorDialog.createIntegration2MetadatasMap(metaDataProvider, filter);
        this.myAppServerBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String name = value != null ? ((AppServerIntegration)value).getPresentableName() : null;
                this.setText(name);
            }
        });
        this.myDescriptorBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String title = value != null ? ((ConfigFileMetaData)value).getTitle() : null;
                this.setText(title);
            }
        });
        this.myVersionBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String name = value != null ? ((ConfigFileVersion)value).getName() : null;
                this.setText(name);
            }
        });
        for (AppServerIntegration integration : this.myIntegration2MetaData.keySet()) {
            this.myAppServerBox.addItem(integration);
        }
        this.myAppServerBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAppServerDescriptorDialog.this.appServerChanged();
            }
        });
        this.myDescriptorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAppServerDescriptorDialog.this.descriptorChanged();
            }
        });
        CreateAppServerDescriptorDialog.selectFirstItem(this.myAppServerBox);
        this.setMinimumWidth();
    }

    private void setMinimumWidth() {
        int width = this.myDescriptorBox.getMinimumSize().width;
        AppServerIntegration serverIntegration = this.getSelectedServer();
        if (serverIntegration == null) {
            return;
        }
        ConfigFileMetaData descriptorMetaData = this.getDescriptorMetaData();
        if (descriptorMetaData == null) {
            return;
        }
        FontMetrics fontMetrics = this.myDescriptorBox.getFontMetrics(this.myDescriptorBox.getFont());
        int maxTitleWidth = Integer.MIN_VALUE;
        for (ConfigFileMetaData metaData : this.myIntegration2MetaData.values()) {
            maxTitleWidth = Math.max(maxTitleWidth, fontMetrics.stringWidth(metaData.getTitle()));
        }
        Dimension min = new Dimension(width - fontMetrics.stringWidth(descriptorMetaData.getTitle()) + maxTitleWidth, this.myDescriptorBox.getMinimumSize().height);
        this.myDescriptorBox.setMinimumSize(min);
        this.myDescriptorBox.setPreferredSize(min);
    }

    private static MultiValuesMap<AppServerIntegration, ConfigFileMetaData> createIntegration2MetadatasMap(AppServerDescriptorsMetaDataProvider metaDataProvider, DescriptorMetaDataFilter filter) {
        AppServerIntegration[] integrations;
        MultiValuesMap map = new MultiValuesMap();
        for (AppServerIntegration appServerIntegration : integrations = AppServerIntegrationsManager.getInstance().getAllIntegrations()) {
            Collection metaData = metaDataProvider.getMetaData(appServerIntegration);
            for (ConfigFileMetaData descriptorMetaData : metaData) {
                if (!filter.isSuitable(descriptorMetaData)) continue;
                map.put((Object)appServerIntegration, (Object)descriptorMetaData);
            }
        }
        return map;
    }

    public static boolean hasDescriptorsToCreate(AppServerDescriptorsMetaDataProvider metaDataProvider, DescriptorMetaDataFilter filter) {
        return !CreateAppServerDescriptorDialog.createIntegration2MetadatasMap(metaDataProvider, filter).isEmpty();
    }

    private void descriptorChanged() {
        this.myVersionBox.removeAllItems();
        ConfigFileMetaData metaData = this.getDescriptorMetaData();
        if (metaData == null) {
            return;
        }
        for (ConfigFileVersion version : metaData.getVersions()) {
            this.myVersionBox.addItem(version);
        }
        if (this.myVersionBox.getItemCount() > 0) {
            this.myVersionBox.setSelectedIndex(this.myVersionBox.getItemCount() - 1);
        }
    }

    private void appServerChanged() {
        AppServerIntegration integration = this.getSelectedServer();
        this.myDescriptorBox.removeAllItems();
        if (integration == null) {
            return;
        }
        Collection metaData = this.myIntegration2MetaData.get((Object)integration);
        if (metaData == null) {
            return;
        }
        for (ConfigFileMetaData data : metaData) {
            this.myDescriptorBox.addItem(data);
        }
        CreateAppServerDescriptorDialog.selectFirstItem(this.myDescriptorBox);
    }

    private AppServerIntegration getSelectedServer() {
        return (AppServerIntegration)this.myAppServerBox.getSelectedItem();
    }

    private static void selectFirstItem(JComboBox comboBox) {
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public ConfigFileMetaData getDescriptorMetaData() {
        return (ConfigFileMetaData)this.myDescriptorBox.getSelectedItem();
    }

    @Nullable
    public ConfigFileVersion getVersion() {
        return (ConfigFileVersion)this.myVersionBox.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.appserver.text"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppServerBox = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myVersionBox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.descriptor.type.text"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescriptorBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.descriptor.version.text"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface DescriptorMetaDataFilter {
        public boolean isSuitable(ConfigFileMetaData var1);
    }
}

