/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcePathReferenceProvider
extends PathReferenceProviderBase {
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, final boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javaee/web/ResourcePathReferenceProvider", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/javaee/web/ResourcePathReferenceProvider", "createReferences"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return false;
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("META-INF.resources");
        if (psiPackage == null) {
            return false;
        }
        PsiDirectory[] directories = psiPackage.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false));
        if (directories.length == 0) {
            return false;
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true){

            protected boolean isUrlEncoded() {
                return true;
            }

            protected boolean isSoft() {
                return soft;
            }
        };
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> Arrays.asList(directories));
        references.addAll(Arrays.asList(set.getAllReferences()));
        return false;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/ResourcePathReferenceProvider", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/web/ResourcePathReferenceProvider", "getPathReference"));
        }
        return null;
    }
}

