/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebContextConfigurable
extends PerFileConfigurableBase<String> {
    public WebContextConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/web/WebContextConfigurable", "<init>"));
        }
        super(project, (PerFileMappings)new MyMappings(project));
    }

    @Nls
    public String getDisplayName() {
        return WebBundle.message("web.contexts", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.settings.webcontexts";
    }

    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/javaee/web/WebContextConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return WebBundle.message("web.contexts.caption", ApplicationNamesInfo.getInstance().getProductName());
        }
        if (key == MAPPING_TITLE) {
            return WebBundle.message("web.context", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return "There are web contexts specified for the subdirectories. Override them?";
        }
        if (key == OVERRIDE_TITLE) {
            return "Override Web Contexts";
        }
        if (key == EMPTY_TEXT) {
            return WebBundle.message("web.contexts.no.contexts", new Object[0]);
        }
        return null;
    }

    protected boolean canRemoveTarget(Object target) {
        return !this.isWebRoot(target);
    }

    protected void renderValue(@Nullable Object target, @NotNull String s, @NotNull ColoredTextContainer renderer) {
        WebDirectoryElement element;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/web/WebContextConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javaee/web/WebContextConfigurable", "renderValue"));
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(s);
        WebDirectoryElement webDirectoryElement = element = file == null ? null : WebUtil.findWebDirectoryByFile((VirtualFile)file, (Project)this.myProject);
        if (element != null) {
            renderer.append(element.getPath(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    protected void renderTarget(@Nullable Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javaee/web/WebContextConfigurable", "renderTarget"));
        }
        super.renderTarget(target, renderer);
        if (this.isWebRoot(target)) {
            renderer.setIcon(AllIcons.Modules.WebRoot);
        }
    }

    private boolean isWebRoot(@Nullable Object target) {
        return ((MyMappings)this.myMappings).roots.contains(target);
    }

    @NotNull
    protected Collection<String> getValueVariants(@Nullable Object target) {
        Collection<String> collection = ((MyMappings)this.myMappings).getValueVariants((VirtualFile)target);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable", "getValueVariants"));
        }
        return collection;
    }

    private static class MyMappings
    implements PerFileMappings<String> {
        final Project project;
        final Set<VirtualFile> roots = ContainerUtil.newLinkedHashSet();

        MyMappings(Project project) {
            this.project = project;
        }

        @NotNull
        public Map<VirtualFile, String> getMappings() {
            HashMap mappings = ContainerUtil.newHashMap((Map)WebContextManager.getInstance((Project)this.project).getMappings());
            for (Module module : ModuleManager.getInstance((Project)this.project).getModules()) {
                for (WebFacet facet : WebFacet.getInstances((Module)module)) {
                    for (WebRoot root : facet.getWebRoots()) {
                        VirtualFile file = root.getFile();
                        if (file == null) continue;
                        this.roots.add(file);
                        if (mappings.containsKey(file)) continue;
                        mappings.put(file, null);
                    }
                }
            }
            HashMap hashMap = mappings;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable$MyMappings", "getMappings"));
            }
            return hashMap;
        }

        public void setMappings(@NotNull Map<VirtualFile, String> mappings) {
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/javaee/web/WebContextConfigurable$MyMappings", "setMappings"));
            }
            WebContextManager.getInstance((Project)this.project).setMappings(mappings);
        }

        public void setMapping(VirtualFile file, String value) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<String> getValueVariants(@Nullable VirtualFile file) {
            WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)this.project);
            if (webFacet != null) {
                VirtualFile virtualFile;
                Collection items;
                VirtualFile originalVirtualFile;
                WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement("/", webFacet);
                if (element != null && (originalVirtualFile = element.getOriginalVirtualFile()) != null) {
                    List<String> list = Collections.singletonList(originalVirtualFile.getUrl());
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable$MyMappings", "getValueVariants"));
                    }
                    return list;
                }
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.project);
                if (module != null && !(items = WebUtil.getWebUtil().getContextsByPath("/", module)).isEmpty() && (virtualFile = ((PsiFileSystemItem)items.iterator().next()).getVirtualFile()) != null) {
                    List<String> list = Collections.singletonList(virtualFile.getUrl());
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable$MyMappings", "getValueVariants"));
                    }
                    return list;
                }
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable$MyMappings", "getValueVariants"));
            }
            return list;
        }

        public String getDefaultMapping(@Nullable VirtualFile file) {
            return null;
        }

        @Nullable
        public String getMapping(@Nullable VirtualFile file) {
            Map<VirtualFile, String> mappings = this.getMappings();
            for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
                String s = mappings.get(cur);
                if (s == null) continue;
                return s;
            }
            return null;
        }
    }
}

