/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRootData {
    private final String myRelativePath;
    private final String myUrl;

    public WebRootData(Element element) throws InvalidDataException {
        String url = element.getAttributeValue("url");
        this.myUrl = url == null ? "" : url;
        String relativePath = element.getAttributeValue("relative");
        if (relativePath == null) {
            throw new InvalidDataException("No relative attribute in Web Root element " + element);
        }
        this.myRelativePath = relativePath;
    }

    public WebRootData(@NotNull String url, @NotNull String relativePath) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/facet/WebRootData", "<init>"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javaee/web/facet/WebRootData", "<init>"));
        }
        this.myRelativePath = relativePath;
        this.myUrl = url;
    }

    public void writeExternal(Element element) {
        element.setAttribute("url", this.myUrl);
        element.setAttribute("relative", this.myRelativePath);
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public String getUrl() {
        return this.myUrl;
    }

    @Nullable
    public VirtualFile findFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebRootData)) {
            return false;
        }
        WebRootData that = (WebRootData)o;
        return this.myRelativePath.equals(that.myRelativePath) && this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        return 31 * this.myRelativePath.hashCode() + this.myUrl.hashCode();
    }
}

