/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.JamChief;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;

public class RemoveQuickFix
implements LocalQuickFix {
    private final Object myTarget;

    public RemoveQuickFix(Object target) {
        this.myTarget = target;
    }

    @NotNull
    public String getName() {
        String string = JpaHighlightingMessages.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription(this.myTarget, (Function<DomElement, DomElement>)FunctionUtil.id()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/RemoveQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaHighlightingMessages.message("intention.family.remove.attribute", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/RemoveQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation target;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/highlighting/RemoveQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/highlighting/RemoveQuickFix", "applyFix"));
        }
        if (this.myTarget instanceof AnnotationGenericValue) {
            target = ((AnnotationGenericValue)((Object)this.myTarget)).getIdentifyingAnnotation();
        } else if (this.myTarget instanceof DomElement) {
            target = ((DomElement)this.myTarget).getXmlElement();
        } else if (this.myTarget instanceof JamChief) {
            target = ((JamChief)this.myTarget).getPsiElement();
        } else if (this.myTarget instanceof PsiElement) {
            target = (PsiElement)this.myTarget;
        } else {
            return;
        }
        if (target == null || !target.isValid()) {
            return;
        }
        if (descriptor.getStartElement().getContainingFile() != target.getContainingFile()) {
            new WriteCommandAction(project, new PsiFile[]{target.getContainingFile()}, (PsiElement)target){
                final /* synthetic */ PsiElement val$target;
                {
                    this.val$target = psiElement;
                    super(arg0, arg1);
                }

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/highlighting/RemoveQuickFix$1", "run"));
                    }
                    this.val$target.delete();
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                protected boolean isGlobalUndoAction() {
                    return true;
                }
            }.execute();
        } else {
            try {
                target.delete();
            }
            catch (IncorrectOperationException e) {
                JpaInspectionUtil.LOG.error((Throwable)e);
            }
        }
    }
}

