/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJpaInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = JpaMessages.message((String)"group.names.jpa.issues", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/AbstractJpaInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/AbstractJpaInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/jpa/inspections/AbstractJpaInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/jpa/inspections/AbstractJpaInspection", "checkClass"));
        }
        PersistenceClassRole[] roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass);
        if (roles.length == 0) {
            return super.checkClass(aClass, manager, isOnTheFly);
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly){
            private final Set<Pair<TextRange, String>> myUniqueCheck;
            {
                this.myUniqueCheck = new THashSet();
            }

            public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
                if (problemDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/jpa/inspections/AbstractJpaInspection$1", "registerProblem"));
                }
                if (this.myUniqueCheck.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)problemDescriptor).getTextRange(), (Object)problemDescriptor.getDescriptionTemplate()))) {
                    super.registerProblem(problemDescriptor);
                }
            }
        };
        this.checkClassAllRoles(aClass, roles, holder, isOnTheFly);
        for (PersistenceClassRole role : roles) {
            this.checkClass(aClass, role, holder, isOnTheFly);
        }
        return holder.getResultsArray();
    }

    protected void checkClassAllRoles(PsiClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
    }

    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
    }
}

