/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.annotations;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.ScopeQlModel;
import com.intellij.jpa.ql.psi.QlAggregateExpression;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlAndExpression;
import com.intellij.jpa.ql.psi.QlArrayItemExpression;
import com.intellij.jpa.ql.psi.QlBetweenExpression;
import com.intellij.jpa.ql.psi.QlBinaryExpression;
import com.intellij.jpa.ql.psi.QlCaseExpression;
import com.intellij.jpa.ql.psi.QlCollectionExpression;
import com.intellij.jpa.ql.psi.QlComparisonExpression;
import com.intellij.jpa.ql.psi.QlConcatFunctionExpression;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlDerivedCollectionMemberDeclaration;
import com.intellij.jpa.ql.psi.QlElementExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlFromClause;
import com.intellij.jpa.ql.psi.QlInExpression;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlIndicesExpression;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlIsEmptyExpression;
import com.intellij.jpa.ql.psi.QlIsNullExpression;
import com.intellij.jpa.ql.psi.QlKeyValueExpression;
import com.intellij.jpa.ql.psi.QlLikeExpression;
import com.intellij.jpa.ql.psi.QlMemberOfExpression;
import com.intellij.jpa.ql.psi.QlMulDivExpression;
import com.intellij.jpa.ql.psi.QlNotExpression;
import com.intellij.jpa.ql.psi.QlNumericFunctionExpression;
import com.intellij.jpa.ql.psi.QlNumericLiteral;
import com.intellij.jpa.ql.psi.QlObjectSelectExpression;
import com.intellij.jpa.ql.psi.QlOrExpression;
import com.intellij.jpa.ql.psi.QlOrderByClause;
import com.intellij.jpa.ql.psi.QlPlusMinusExpression;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlRowConstructorExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlSelectStatement;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlUnaryArithmeticExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.jpa.ql.psi.QlWhenClause;
import com.intellij.jpa.ql.psi.QlWhereClause;
import com.intellij.jpa.ql.psi.impl.QlCompositeElementImpl;
import com.intellij.jpa.ql.types.QlClassType;
import com.intellij.jpa.ql.types.QlCollectionType;
import com.intellij.jpa.ql.types.QlIndexedCollectionType;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlAnnotationVisitor
extends QlVisitor {
    private static final String ERROR_ID_VAR_EXPECTED = "Identification variable expected";
    private static final String ERROR_ORD_ATTR_EXPECTED = "Orderable attribute expected";
    private static final String ERROR_DUPLICATE_IDENTIFIER = "Duplicate identifier";
    private static final String ERROR_TYPE_MISMATCH = "Type mismatch: {0} type expected";
    private static final String ERROR_CONSTANT_OR_PARAMETER_EXPECTED = "{0} constant expected";
    private AnnotationHolder myAnnotationService;

    public QlAnnotationVisitor(AnnotationHolder service) {
        this.myAnnotationService = service;
    }

    protected final void addError(@NotNull PsiElement element, @NotNull String errorMessage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "addError"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "addError"));
        }
        this.myAnnotationService.createErrorAnnotation(element, errorMessage);
    }

    private void addError(@NotNull PsiElement element, String errorMessage, Object ... args) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "addError"));
        }
        this.myAnnotationService.createErrorAnnotation(element, MessageFormat.format(errorMessage, args));
    }

    private boolean checkType(@Nullable QlExpression expression, @NotNull QlType type) {
        PsiClass typeTargetClass;
        PsiClass tTargetClass;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "checkType"));
        }
        if (expression == null) {
            return false;
        }
        QlType t = expression.getType();
        if (t instanceof QlClassType && type instanceof QlClassType && (tTargetClass = ((QlClassType)t).getTargetClass()).equals(typeTargetClass = ((QlClassType)type).getTargetClass()) && tTargetClass.isEnum()) {
            return true;
        }
        if (t instanceof QlClassType && type == QlType.ENTITY || t == QlType.ENTITY && type instanceof QlClassType) {
            return true;
        }
        if (t != null && !t.equals(type)) {
            QlExpression expr = expression;
            while (expr instanceof QlCollectionExpression) {
                expr = ((QlCollectionExpression)expr).getExpression();
            }
            if (expr instanceof QlQueryExpression && t instanceof QlIndexedCollectionType && type.equals(((QlIndexedCollectionType)t).getComponentType())) {
                return true;
            }
            if (QlAnnotationVisitor.isHibernate(expr) && (type == QlType.NUMBER && t == QlType.DATETIME || t == QlType.NUMBER && type == QlType.DATETIME)) {
                return true;
            }
            this.addError(expression, ERROR_TYPE_MISMATCH, type.getName());
            return false;
        }
        return true;
    }

    private boolean checkCollectionType(@Nullable QlExpression expression) {
        if (expression == null) {
            return false;
        }
        QlType t = expression.getType();
        if (t != null && !(t instanceof QlCollectionType)) {
            this.addError(expression, ERROR_TYPE_MISMATCH, QlType.COLLECTION.getName());
            return false;
        }
        return true;
    }

    private static boolean checkEnumType(QlExpression lOperand, QlType lType, QlType rType) {
        if (lType instanceof QlClassType && ((QlClassType)lType).getTargetClass().isEnum()) {
            boolean enumAsString;
            Object o = lOperand instanceof QlReferenceExpression ? ((QlReferenceExpression)lOperand).resolve() : null;
            boolean bl = enumAsString = o instanceof QlAttribute && ((QlAttribute)o).isEnumAsString();
            if (enumAsString && rType == QlType.STRING || !enumAsString && rType == QlType.NUMBER) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitBetweenExpression(@NotNull QlBetweenExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitBetweenExpression"));
        }
        QlExpression upper = o.getUpperBound();
        if (upper == null) {
            return;
        }
        QlExpression operand = o.getOperand();
        QlType type = operand.getType();
        if (type == null) {
            return;
        }
        if (type != QlType.NUMBER && type != QlType.DATETIME && type != QlType.STRING) {
            this.addError(operand, "Type mismatch: number, date or string expected");
            return;
        }
        this.checkType(o.getLowerBound(), type);
        this.checkType(upper, type);
    }

    @Override
    public void visitObjectSelectExpression(@NotNull QlObjectSelectExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitObjectSelectExpression"));
        }
        QlReferenceExpression expression = o.getReferenceExpression();
        if (expression != null && expression.getQualifier() != null) {
            this.addError(expression, ERROR_ID_VAR_EXPECTED);
        }
    }

    @Override
    public void visitKeyValueExpression(@NotNull QlKeyValueExpression o) {
        IElementType firstElementType;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitKeyValueExpression"));
        }
        QlReferenceExpression mapExpression = o.getReferenceExpression();
        QlType mapType = mapExpression.getType();
        if (mapType == null) {
            return;
        }
        if (!(mapType instanceof QlIndexedCollectionType)) {
            this.addError(mapExpression, "Type mismatch: map type expected");
        }
        if ((firstElementType = QlAnnotationVisitor.getFirstElementType(o)) == QlTypes.QL_ENTRY && !(o.getParent() instanceof QlSelectClause)) {
            this.addError(o, "Entry reference is allowed only in SELECT clause");
        }
    }

    @Override
    public void visitDerivedCollectionMemberDeclaration(@NotNull QlDerivedCollectionMemberDeclaration o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitDerivedCollectionMemberDeclaration"));
        }
        QlReferenceExpression referenceExpression = o.getReferenceExpression();
        if (referenceExpression == null) {
            return;
        }
        Object target = referenceExpression.resolve();
        if (!QlAttribute.isRelationshipEnd(target)) {
            this.addError(referenceExpression, "Relationship expected");
        }
    }

    @Override
    public void visitLikeExpression(@NotNull QlLikeExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitLikeExpression"));
        }
        List<QlExpression> list = o.getExpressionList();
        if (list.size() >= 2) {
            this.checkType(list.get(0), QlType.STRING);
            if (!this.checkType(list.get(1), QlType.STRING)) {
                return;
            }
            if (list.size() == 3) {
                this.checkConstantOrParameterExpression(list.get(2), QlType.STRING);
            }
        }
    }

    @Override
    public void visitNumericFunctionExpression(@NotNull QlNumericFunctionExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitNumericFunctionExpression"));
        }
        IElementType type = QlAnnotationVisitor.getFirstElementType(o);
        List<QlExpression> list = o.getExpressionList();
        if (type == QlTypes.QL_ABS || type == QlTypes.QL_SQRT) {
            if (list.size() == 1) {
                this.checkType(list.get(0), QlType.NUMBER);
            }
        } else if (type == QlTypes.QL_MOD) {
            if (list.size() == 2) {
                this.checkType(list.get(0), QlType.NUMBER);
                this.checkType(list.get(1), QlType.NUMBER);
            }
        } else if (type == QlTypes.QL_LENGTH) {
            if (list.size() == 1) {
                this.checkType(list.get(0), QlType.STRING);
            }
        } else if (type == QlTypes.QL_LOCATE) {
            if (list.size() >= 2) {
                this.checkType(list.get(0), QlType.STRING);
                this.checkType(list.get(1), QlType.STRING);
                QlExpression third = list.size() == 3 ? list.get(2) : null;
                this.checkType(third, QlType.NUMBER);
            }
        } else if (list.size() == 1) {
            this.checkCollectionType(list.get(0));
        }
    }

    @Override
    public void visitAggregateExpression(@NotNull QlAggregateExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitAggregateExpression"));
        }
        QlExpression expression = o.getExpression();
        IElementType type = QlAnnotationVisitor.getFirstElementType(o);
        if (type == QlTypes.QL_SUM && expression != null && !expression.getText().equals("*")) {
            this.checkType(expression, QlType.NUMBER);
        }
    }

    private static IElementType getFirstElementType(QlExpression o) {
        return QlCompositeElementImpl.getFirstElementType(o);
    }

    @Override
    public void visitConstructorExpression(@NotNull QlConstructorExpression constructorCall) {
        if (constructorCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorCall", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitConstructorExpression"));
        }
        List<PsiType> parameterTypes = constructorCall.getParameterTypes();
        for (PsiType type : parameterTypes) {
            if (type != null) continue;
            return;
        }
        QlReferenceExpression refExpression = constructorCall.getReferenceExpression();
        if (refExpression != null && refExpression.resolve() instanceof PsiMethod) {
            return;
        }
        PsiMethod psiMethod = constructorCall.resolveConstructor();
        if (psiMethod == null && refExpression != null) {
            PsiPolyVariantReference reference = refExpression.getReference();
            TextRange range = new TextRange(reference.getRangeInElement().getEndOffset() + reference.getElement().getTextRange().getStartOffset(), constructorCall.getTextRange().getEndOffset());
            String name = refExpression.getText() + QlAnnotationVisitor.buildArgTypesList(parameterTypes);
            this.myAnnotationService.createErrorAnnotation(range, JavaErrorMessages.message((String)"cannot.resolve.constructor", (Object[])new Object[]{name}));
        }
    }

    private static String buildArgTypesList(List<PsiType> list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            PsiType argType = list.get(i);
            builder.append(JavaHighlightUtil.formatType((PsiType)argType));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void visitOrderByClause(@NotNull QlOrderByClause o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitOrderByClause"));
        }
        for (PsiElement element : o.getChildren()) {
            if (!(element instanceof QlReferenceExpression)) continue;
            this.checkOrderByItem((QlReferenceExpression)element);
        }
    }

    public void checkOrderByItem(@NotNull QlReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "checkOrderByItem"));
        }
        QlModel model = ((QlFile)expression.getContainingFile()).getQlModel();
        if (model instanceof ScopeQlModel) {
            ScopeQlModel scopeModel = (ScopeQlModel)model;
            if (!scopeModel.isEmptyModel() && !(expression.resolve() instanceof QlAttribute)) {
                this.addError(expression, ERROR_ORD_ATTR_EXPECTED);
            }
        } else {
            Object target;
            QlExpression aliasedExpression;
            Object pathStart;
            QlExpression _q1 = expression.getQualifier();
            QlReferenceExpression q1 = null;
            while (_q1 != null && _q1 instanceof QlReferenceExpression) {
                q1 = (QlReferenceExpression)_q1;
                _q1 = q1.getQualifier();
            }
            Object object = pathStart = q1 == null ? null : q1.resolve();
            if (pathStart != null && !(pathStart instanceof QlAliasDefinition) && !QlAttribute.isRelationshipEnd(pathStart)) {
                if (pathStart instanceof QlAttribute && ((QlAttribute)pathStart).isEmbeddable()) {
                    return;
                }
                this.addError(expression, ERROR_ORD_ATTR_EXPECTED);
                return;
            }
            Object resolve = expression.resolve();
            QlExpression qlExpression = aliasedExpression = resolve instanceof QlAliasDefinition ? ((QlAliasDefinition)resolve).getExpression() : null;
            Object object2 = aliasedExpression instanceof QlReferenceExpression ? ((QlReferenceExpression)aliasedExpression).resolve() : (target = aliasedExpression instanceof QlAggregateExpression ? aliasedExpression : resolve);
            if (target instanceof QlElement) {
                PsiType psiType = ((QlElement)target).getPsiType();
                if (InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.lang.Comparable") || psiType instanceof PsiPrimitiveType) {
                    return;
                }
                this.addError(expression, ERROR_ORD_ATTR_EXPECTED);
            } else if (target != null && !(target instanceof QlAggregateExpression)) {
                this.addError(expression, ERROR_ORD_ATTR_EXPECTED);
            }
        }
    }

    @Override
    public void visitArrayItemExpression(@NotNull QlArrayItemExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitArrayItemExpression"));
        }
        if (o.getType() == null) {
            return;
        }
        QlExpression right = o.getRight();
        if (right != null) {
            QlIndexedCollectionType type;
            QlExpression left = o.getLeft();
            QlIndexedCollectionType qlIndexedCollectionType = type = left.getType() instanceof QlCollectionType ? (QlIndexedCollectionType)left.getType() : null;
            if (type != null) {
                this.checkType(right, type.getIndexType());
            }
        }
    }

    @Override
    public void visitInputParameter(@NotNull QlInputParameter o) {
        String name;
        boolean positional;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitInputParameter"));
        }
        PsiElement number = o.getNumber();
        boolean bl = positional = number != null;
        if (positional && StringUtil.isNotEmpty((String)(name = number.getText()))) {
            try {
                int i = Integer.parseInt(name);
                if (i <= 0) {
                    this.addError(o, "Query parameters are numerated starting with 1");
                } else {
                    int count = ((QlFile)o.getContainingFile()).getQlModel().getParametersCount();
                    if (count >= 0 && i > count) {
                        this.addError(o, count == 0 ? "Query has no parameters" : (count == 1 ? "Query has only one parameter" : "There are only " + count + " query parameters"));
                    }
                }
            }
            catch (NumberFormatException e) {
                this.addError(o, "Number expected");
            }
        }
    }

    @Override
    public void visitWhenClause(@NotNull QlWhenClause o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitWhenClause"));
        }
        PsiElement caseExpression = o.getParent();
        if (caseExpression instanceof QlCaseExpression) {
            QlType type;
            QlExpression expression = ((QlCaseExpression)caseExpression).getExpression();
            QlType qlType = type = expression == null ? QlType.BOOLEAN : expression.getType();
            if (type != null) {
                this.checkType(o.getExpression(), type);
            }
        }
    }

    @Override
    public void visitStatement(@NotNull QlStatement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitStatement"));
        }
        final HashMap name2declaration = new HashMap();
        o.accept(new QlRecursiveVisitor(){

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor$1", "visitAliasDefinition"));
                }
                QlAnnotationVisitor.this.processDeclaration(name2declaration, o.getIdentifier(), o.getIdentifier().getText());
            }

            @Override
            public void visitQueryExpression(@NotNull QlQueryExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor$1", "visitQueryExpression"));
                }
                if (o.getParent() instanceof QlSelectStatement) {
                    super.visitQueryExpression(o);
                }
            }
        });
    }

    private void processDeclaration(@NotNull Map<String, PsiElement> name2declaration, @NotNull PsiElement declaration, String name) {
        if (name2declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name2declaration", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "processDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "processDeclaration"));
        }
        if (name2declaration.containsKey(name)) {
            PsiElement dcl = name2declaration.get(name);
            assert (dcl != null);
            this.addError(dcl, ERROR_DUPLICATE_IDENTIFIER);
            this.addError(declaration, ERROR_DUPLICATE_IDENTIFIER);
            return;
        }
        name2declaration.put(name, declaration);
    }

    @Override
    public void visitWhereClause(@NotNull QlWhereClause o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitWhereClause"));
        }
        this.checkType(o.getExpression(), QlType.BOOLEAN);
    }

    @Override
    public void visitIsNullExpression(@NotNull QlIsNullExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitIsNullExpression"));
        }
        QlExpression operand = o.getExpression();
        if (operand.getType() instanceof QlCollectionType) {
            this.addError(operand, ERROR_TYPE_MISMATCH, "single-valued");
        }
    }

    @Override
    public void visitMemberOfExpression(@NotNull QlMemberOfExpression o) {
        QlType rightType;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitMemberOfExpression"));
        }
        QlExpression right = o.getRight();
        QlType qlType = rightType = right != null ? right.getType() : null;
        if (rightType instanceof QlIndexedCollectionType) {
            QlType type = ((QlIndexedCollectionType)rightType).getComponentType();
            this.checkType(o.getLeft(), type);
        }
        if (rightType == QlType.NUMBER) {
            return;
        }
        this.checkCollectionType(right);
    }

    @Override
    public void visitInVariableExpression(@NotNull QlInVariableExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitInVariableExpression"));
        }
        QlReferenceExpression referenceExpression = o.getReferenceExpression();
        if (referenceExpression == null) {
            return;
        }
        Object target = referenceExpression.resolve();
        if (!QlAttribute.isRelationshipEnd(target)) {
            this.addError(referenceExpression, "Relationship expected");
        }
    }

    @Override
    public void visitInExpression(@NotNull QlInExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitInExpression"));
        }
        List<QlExpression> list = o.getExpressionList();
        if (list.size() > 1) {
            QlExpression expression = list.get(0);
            QlType type = expression.getType();
            if (type == null) {
                return;
            }
            for (int i = 1; i < list.size(); ++i) {
                QlExpression e = list.get(i);
                if (e instanceof QlCollectionExpression || e instanceof QlElementExpression || e instanceof QlIndicesExpression || e instanceof QlRowConstructorExpression) continue;
                this.checkType(e, type);
            }
        }
    }

    private void checkConstantOrParameterExpression(QlExpression e, @NotNull QlType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "checkConstantOrParameterExpression"));
        }
        if (e instanceof QlNumericLiteral || e instanceof QlStringLiteral || e instanceof QlInputParameter) {
            this.checkType(e, type);
        } else if (e instanceof QlReferenceExpression) {
            QlReferenceExpression referenceExpression = (QlReferenceExpression)e;
            Object o = referenceExpression.resolve();
            if (!(o instanceof QlAliasDefinition)) {
                this.addError(e, ERROR_CONSTANT_OR_PARAMETER_EXPECTED, StringUtil.capitalize((String)type.getName()));
            } else {
                this.checkType(e, type);
            }
        } else {
            QlType qlType = e.getType();
            if (type.equals(qlType)) {
                return;
            }
            if (qlType instanceof QlCollectionType && type.equals(((QlCollectionType)qlType).getComponentType())) {
                return;
            }
            this.addError(e, ERROR_CONSTANT_OR_PARAMETER_EXPECTED, StringUtil.capitalize((String)type.getName()));
        }
    }

    @Override
    public void visitNotExpression(@NotNull QlNotExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitNotExpression"));
        }
        this.checkType(o.getExpression(), QlType.BOOLEAN);
    }

    @Override
    public void visitIsEmptyExpression(@NotNull QlIsEmptyExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitIsEmptyExpression"));
        }
        this.checkCollectionType(o.getExpression());
    }

    @Override
    public void visitConcatFunctionExpression(@NotNull QlConcatFunctionExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitConcatFunctionExpression"));
        }
        if (QlAnnotationVisitor.isHibernate(o)) {
            return;
        }
        List<QlExpression> list = o.getExpressionList();
        if (list.size() == 2) {
            this.checkType(list.get(0), QlType.STRING);
            this.checkType(list.get(1), QlType.STRING);
        }
    }

    @Override
    public void visitUnaryArithmeticExpression(@NotNull QlUnaryArithmeticExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitUnaryArithmeticExpression"));
        }
        this.checkType(o.getExpression(), QlType.NUMBER);
    }

    @Override
    public void visitPlusMinusExpression(@NotNull QlPlusMinusExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitPlusMinusExpression"));
        }
        IElementType operator = o.getOperator();
        if (operator == QlTypes.QL_OP_CONCAT) {
            if (QlAnnotationVisitor.isHibernate(o)) {
                return;
            }
            this.checkBinaryExpression(o, QlType.STRING);
        } else if (operator == QlTypes.QL_OP_PLUS || operator == QlTypes.QL_OP_MINUS) {
            this.checkBinaryExpression(o, QlType.NUMBER);
        }
    }

    private void checkBinaryExpression(QlBinaryExpression o, QlType type) {
        QlExpression right = o.getRight();
        if (right == null) {
            return;
        }
        this.checkType(o.getLeft(), type);
        this.checkType(right, type);
    }

    @Override
    public void visitMulDivExpression(@NotNull QlMulDivExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitMulDivExpression"));
        }
        this.checkBinaryExpression(o, QlType.NUMBER);
    }

    @Override
    public void visitAndExpression(@NotNull QlAndExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitAndExpression"));
        }
        this.checkBinaryExpression(o, QlType.BOOLEAN);
    }

    @Override
    public void visitOrExpression(@NotNull QlOrExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitOrExpression"));
        }
        this.checkBinaryExpression(o, QlType.BOOLEAN);
    }

    @Override
    public void visitComparisonExpression(@NotNull QlComparisonExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitComparisonExpression"));
        }
        QlExpression rOperand = o.getRight();
        if (rOperand != null) {
            QlExpression lOperand = o.getLeft();
            QlType lType = lOperand.getType();
            QlType rType = rOperand.getType();
            if (lType == null || rType == null) {
                return;
            }
            if (lType == QlType.DATETIME && rType == QlType.STRING || lType == QlType.STRING && rType == QlType.DATETIME) {
                return;
            }
            if (lType instanceof QlClassType && rType instanceof QlClassType) {
                return;
            }
            if (lType instanceof QlClassType && rType == QlType.ENTITY || lType == QlType.ENTITY && rType instanceof QlClassType) {
                return;
            }
            if (QlAnnotationVisitor.checkEnumType(lOperand, lType, rType) || QlAnnotationVisitor.checkEnumType(rOperand, rType, lType)) {
                return;
            }
            if (lType instanceof QlClassType && rType == QlType.STRING || lType == QlType.STRING && rType instanceof QlClassType) {
                return;
            }
            if (lType != rType) {
                this.checkType(rOperand, lType);
            }
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull QlReferenceExpression o) {
        PsiElement parent;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/annotations/QlAnnotationVisitor", "visitReferenceExpression"));
        }
        if (!QlAnnotationVisitor.shouldCheckResolve(o)) {
            return;
        }
        Object result = o.resolve();
        if (result == null) {
            this.myAnnotationService.createErrorAnnotation(QlAnnotationVisitor.getReferenceRange((PsiReference)o.getReference()), MessageFormat.format("Can''t resolve symbol ''{0}''", o.getIdentifier().getText()));
        } else if (result instanceof PsiClass && ((parent = o.getParent()) instanceof QlAliasDefinition || parent instanceof QlFromClause) && !QlAnnotationVisitor.isHibernate(o)) {
            this.myAnnotationService.createErrorAnnotation(QlAnnotationVisitor.getReferenceRange((PsiReference)o.getReference()), MessageFormat.format("Class ''{0}'' is not an entity", o.getIdentifier().getText()));
        }
    }

    private static boolean isHibernate(PsiElement o) {
        return o.getContainingFile().getLanguage() == JpqlLanguage.HQL;
    }

    private static TextRange getReferenceRange(PsiReference reference) {
        return reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset());
    }

    private static boolean shouldCheckResolve(QlReferenceExpression o) {
        QlExpression qualifier = o.getQualifier();
        if (qualifier != null && !(qualifier instanceof QlKeyValueExpression)) {
            PsiReference r;
            QlExpression referenceExpression;
            PsiElement qualifierResolve;
            PsiReference qualifierReference = qualifier.getReference();
            PsiElement psiElement = qualifierResolve = qualifierReference == null ? null : qualifierReference.resolve();
            if (qualifierResolve == null) {
                return false;
            }
            if (qualifierResolve instanceof QlAliasDefinition && (referenceExpression = ((QlAliasDefinition)qualifierResolve).getExpression()) instanceof QlReferenceExpression && (r = referenceExpression.getReference()) != null && r.resolve() == null) {
                return false;
            }
        }
        return true;
    }
}

