/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.jpa.ql.psi.QlAggregateExpression;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlAndExpression;
import com.intellij.jpa.ql.psi.QlArrayItemExpression;
import com.intellij.jpa.ql.psi.QlBetweenExpression;
import com.intellij.jpa.ql.psi.QlBooleanLiteral;
import com.intellij.jpa.ql.psi.QlCaseExpression;
import com.intellij.jpa.ql.psi.QlCastExpression;
import com.intellij.jpa.ql.psi.QlCoalesceExpression;
import com.intellij.jpa.ql.psi.QlCollectionExpression;
import com.intellij.jpa.ql.psi.QlComparisonExpression;
import com.intellij.jpa.ql.psi.QlConcatFunctionExpression;
import com.intellij.jpa.ql.psi.QlConditionalExpression;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlDateTimeLiteral;
import com.intellij.jpa.ql.psi.QlDatetimeFunctionExpression;
import com.intellij.jpa.ql.psi.QlElementExpression;
import com.intellij.jpa.ql.psi.QlElseClause;
import com.intellij.jpa.ql.psi.QlExistsExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlExpressionBase;
import com.intellij.jpa.ql.psi.QlExtractExpression;
import com.intellij.jpa.ql.psi.QlFromClause;
import com.intellij.jpa.ql.psi.QlHqlDatetimeTypeExpression;
import com.intellij.jpa.ql.psi.QlHqlTypeExpression;
import com.intellij.jpa.ql.psi.QlInExpression;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlIndicesExpression;
import com.intellij.jpa.ql.psi.QlIsEmptyExpression;
import com.intellij.jpa.ql.psi.QlIsNullExpression;
import com.intellij.jpa.ql.psi.QlKeyValueExpression;
import com.intellij.jpa.ql.psi.QlLikeExpression;
import com.intellij.jpa.ql.psi.QlMemberOfExpression;
import com.intellij.jpa.ql.psi.QlMulDivExpression;
import com.intellij.jpa.ql.psi.QlNewExpression;
import com.intellij.jpa.ql.psi.QlNullExpression;
import com.intellij.jpa.ql.psi.QlNullifExpression;
import com.intellij.jpa.ql.psi.QlNumericFunctionExpression;
import com.intellij.jpa.ql.psi.QlNumericLiteral;
import com.intellij.jpa.ql.psi.QlOrExpression;
import com.intellij.jpa.ql.psi.QlParenthesizedArithmeticExpression;
import com.intellij.jpa.ql.psi.QlPlusMinusExpression;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlStringFunctionExpression;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlThenClause;
import com.intellij.jpa.ql.psi.QlTypeExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.jpa.ql.psi.QlWhereClause;
import com.intellij.jpa.ql.psi.impl.QlCompositeElementImpl;
import com.intellij.jpa.ql.types.QlCollectionType;
import com.intellij.jpa.ql.types.QlIndexedCollectionType;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlExpressionBaseImpl
extends QlCompositeElementImpl
implements QlExpressionBase {
    public QlExpressionBaseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public final IElementType getOperator() {
        PsiElement token = this.findChildByFilter(QlLexer.QL_BINARY_OPERATORS);
        return token == null ? null : token.getNode().getElementType();
    }

    @Override
    @NotNull
    public List<QlExpression> getOperands() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, QlExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl", "getOperands"));
        }
        return list;
    }

    @Override
    public QlType getType() {
        final Ref type = Ref.create(null);
        this.accept(new QlVisitor(){

            @Override
            public void visitDateTimeLiteral(@NotNull QlDateTimeLiteral o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitDateTimeLiteral"));
                }
                type.set((Object)QlType.DATETIME);
            }

            @Override
            public void visitNumericFunctionExpression(@NotNull QlNumericFunctionExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitNumericFunctionExpression"));
                }
                type.set((Object)QlType.NUMBER);
            }

            @Override
            public void visitStringFunctionExpression(@NotNull QlStringFunctionExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitStringFunctionExpression"));
                }
                type.set((Object)QlType.STRING);
            }

            @Override
            public void visitReferenceExpression(@NotNull QlReferenceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitReferenceExpression"));
                }
                QlType qlType = QlCompositeElementImpl.getQlTypeByPsiType(o.getPsiType());
                if (qlType instanceof QlCollectionType) {
                    QlWhereClause whereClause = (QlWhereClause)PsiTreeUtil.getParentOfType((PsiElement)o, QlWhereClause.class);
                    PsiElement parent = o.getParent();
                    if (parent instanceof QlComparisonExpression && whereClause != null) {
                        QlType componentType = ((QlCollectionType)qlType).getComponentType();
                        type.set((Object)componentType);
                    } else {
                        type.set((Object)qlType);
                    }
                } else {
                    type.set((Object)qlType);
                }
            }

            @Override
            public void visitAndExpression(@NotNull QlAndExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitAndExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitTypeExpression(@NotNull QlTypeExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitTypeExpression"));
                }
                type.set((Object)QlType.ENTITY);
            }

            @Override
            public void visitCoalesceExpression(@NotNull QlCoalesceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitCoalesceExpression"));
                }
                for (QlExpression arg : o.getExpressionList()) {
                    QlType t = arg.getType();
                    if (t == null) continue;
                    type.set((Object)t);
                    return;
                }
            }

            @Override
            public void visitNullifExpression(@NotNull QlNullifExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitNullifExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitMemberOfExpression(@NotNull QlMemberOfExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitMemberOfExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitComparisonExpression(@NotNull QlComparisonExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitComparisonExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitBetweenExpression(@NotNull QlBetweenExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitBetweenExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitDatetimeFunctionExpression(@NotNull QlDatetimeFunctionExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitDatetimeFunctionExpression"));
                }
                type.set((Object)QlType.DATETIME);
            }

            @Override
            public void visitMulDivExpression(@NotNull QlMulDivExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitMulDivExpression"));
                }
                type.set((Object)QlType.NUMBER);
            }

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitAliasDefinition"));
                }
                type.set((Object)o.getExpression().getType());
            }

            @Override
            public void visitBooleanLiteral(@NotNull QlBooleanLiteral o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitBooleanLiteral"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitPlusMinusExpression(@NotNull QlPlusMinusExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitPlusMinusExpression"));
                }
                if (o.getOperator() == QlTypes.QL_OP_CONCAT) {
                    type.set((Object)QlType.STRING);
                } else {
                    type.set((Object)QlType.NUMBER);
                }
            }

            @Override
            public void visitCollectionExpression(@NotNull QlCollectionExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitCollectionExpression"));
                }
                QlExpression expression = o.getExpression();
                type.set((Object)expression.getType());
            }

            @Override
            public void visitAggregateExpression(@NotNull QlAggregateExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitAggregateExpression"));
                }
                type.set((Object)QlCompositeElementImpl.getQlTypeByPsiType(QlExpressionBaseImpl.getAggregateExpressionPsiType(o)));
            }

            @Override
            public void visitQueryExpression(@NotNull QlQueryExpression o) {
                List<QlExpression> expressions;
                QlFromClause from;
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitQueryExpression"));
                }
                QlSelectClause select = o.getSelectClause();
                if (select != null) {
                    List<QlExpression> expressions2 = select.getExpressionList();
                    if (expressions2.size() == 1) {
                        QlType expressionType;
                        QlExpression expression = expressions2.get(0);
                        if (expression instanceof QlAggregateExpression) {
                            type.set((Object)expression.getType());
                            return;
                        }
                        if (expression != null && (expressionType = expression.getType()) != null) {
                            type.set((Object)new QlIndexedCollectionType(QlType.NUMBER, expressionType));
                            return;
                        }
                    }
                    type.set((Object)QlType.COLLECTION);
                    return;
                }
                if (QlExpressionBaseImpl.this.getContainingFile().getLanguage() == JpqlLanguage.HQL && (from = o.getFromClause()) != null && (expressions = from.getExpressionList()).size() == 1) {
                    QlExpression expression = expressions.get(0);
                    QlType expressionType = null;
                    if (expression instanceof QlReferenceExpression) {
                        expressionType = expression.getType();
                    } else if (expression instanceof QlAliasDefinition) {
                        QlExpression target = ((QlAliasDefinition)expression).getExpression();
                        QlType qlType = expressionType = target == null ? null : target.getType();
                    }
                    if (expressionType != null) {
                        type.set((Object)new QlIndexedCollectionType(QlType.NUMBER, expressionType));
                        return;
                    }
                }
                type.set((Object)QlType.COLLECTION);
            }

            @Override
            public void visitOrExpression(@NotNull QlOrExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitOrExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitConcatFunctionExpression(@NotNull QlConcatFunctionExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitConcatFunctionExpression"));
                }
                type.set((Object)QlType.STRING);
            }

            @Override
            public void visitNumericLiteral(@NotNull QlNumericLiteral o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitNumericLiteral"));
                }
                type.set((Object)QlType.NUMBER);
            }

            @Override
            public void visitStringLiteral(@NotNull QlStringLiteral o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitStringLiteral"));
                }
                type.set((Object)QlType.STRING);
            }

            @Override
            public void visitParenthesizedArithmeticExpression(@NotNull QlParenthesizedArithmeticExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitParenthesizedArithmeticExpression"));
                }
                type.set((Object)o.getExpression().getType());
            }

            @Override
            public void visitCastExpression(@NotNull QlCastExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitCastExpression"));
                }
                List<QlExpression> list = o.getExpressionList();
                if (list.size() == 2) {
                    type.set((Object)list.get(1).getType());
                }
            }

            @Override
            public void visitConditionalExpression(@NotNull QlConditionalExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitConditionalExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitCaseExpression(@NotNull QlCaseExpression o) {
                QlExpression expression;
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitCaseExpression"));
                }
                for (QlThenClause thenClause : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)o, QlThenClause.class)) {
                    expression = thenClause.getExpression();
                    if (expression == null || expression.getType() == null) continue;
                    type.set((Object)expression.getType());
                    return;
                }
                for (QlElseClause elseClause : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)o, QlElseClause.class)) {
                    expression = elseClause.getExpression();
                    if (expression == null || expression.getType() == null) continue;
                    type.set((Object)expression.getType());
                    return;
                }
            }

            @Override
            public void visitConstructorExpression(@NotNull QlConstructorExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitConstructorExpression"));
                }
                super.visitConstructorExpression(o);
            }

            @Override
            public void visitInExpression(@NotNull QlInExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitInExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitArrayItemExpression(@NotNull QlArrayItemExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitArrayItemExpression"));
                }
                QlType arrayType = o.getLeft().getType();
                if (arrayType instanceof QlIndexedCollectionType) {
                    type.set((Object)((QlIndexedCollectionType)arrayType).getComponentType());
                }
            }

            @Override
            public void visitKeyValueExpression(@NotNull QlKeyValueExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitKeyValueExpression"));
                }
                QlReferenceExpression mapExpression = o.getReferenceExpression();
                IElementType elementType = QlCompositeElementImpl.getFirstElementType(o);
                QlType mapType = mapExpression.getType();
                if (!(mapType instanceof QlIndexedCollectionType)) {
                    return;
                }
                QlIndexedCollectionType qlMapType = (QlIndexedCollectionType)mapType;
                if (elementType.equals(QlTypes.QL_KEY)) {
                    type.set((Object)qlMapType.getIndexType());
                } else if (elementType.equals(QlTypes.QL_VALUE)) {
                    type.set((Object)qlMapType.getComponentType());
                } else if (elementType.equals(QlTypes.QL_ENTRY)) {
                    type.set((Object)qlMapType.getEntryType());
                }
            }

            @Override
            public void visitIsEmptyExpression(@NotNull QlIsEmptyExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitIsEmptyExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitExistsExpression(@NotNull QlExistsExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitExistsExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitIsNullExpression(@NotNull QlIsNullExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitIsNullExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitLikeExpression(@NotNull QlLikeExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitLikeExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitNullExpression(@NotNull QlNullExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitNullExpression"));
                }
            }

            @Override
            public void visitExtractExpression(@NotNull QlExtractExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitExtractExpression"));
                }
                List<QlExpression> list = o.getExpressionList();
                if (list.size() > 0) {
                    type.set((Object)list.get(0).getType());
                }
            }

            @Override
            public void visitInVariableExpression(@NotNull QlInVariableExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitInVariableExpression"));
                }
                type.set((Object)QlType.BOOLEAN);
            }

            @Override
            public void visitNewExpression(@NotNull QlNewExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitNewExpression"));
                }
                for (PsiElement element : o.getChildren()) {
                    if (element != QlTypes.QL_LIST && element != QlTypes.QL_MAP) continue;
                    type.set((Object)QlType.COLLECTION);
                    return;
                }
            }

            @Override
            public void visitElementExpression(@NotNull QlElementExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitElementExpression"));
                }
                type.set(null);
            }

            @Override
            public void visitIndicesExpression(@NotNull QlIndicesExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitIndicesExpression"));
                }
                type.set(null);
            }

            @Override
            public void visitHqlTypeExpression(@NotNull QlHqlTypeExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitHqlTypeExpression"));
                }
                String text = o.getText();
                if (text.equals("string")) {
                    type.set((Object)QlType.STRING);
                } else if (text.equals("boolean")) {
                    type.set((Object)QlType.BOOLEAN);
                } else if (QlLexer.HQL_DATETIME_TYPES.contains(text)) {
                    type.set((Object)QlType.DATETIME);
                } else if (QlLexer.HQL_NUMERIC_TYPES.contains(text)) {
                    type.set((Object)QlType.NUMBER);
                }
            }

            @Override
            public void visitHqlDatetimeTypeExpression(@NotNull QlHqlDatetimeTypeExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlExpressionBaseImpl$1", "visitHqlDatetimeTypeExpression"));
                }
                type.set((Object)QlType.DATETIME);
            }
        });
        return (QlType)type.get();
    }

    @Nullable
    public static PsiType getPsiType(@Nullable QlExpression parameter) {
        if (parameter == null) {
            return null;
        }
        if (parameter instanceof QlReferenceExpression) {
            return ((QlReferenceExpression)parameter).getPsiType();
        }
        if (parameter instanceof QlAggregateExpression) {
            return QlExpressionBaseImpl.getAggregateExpressionPsiType((QlAggregateExpression)parameter);
        }
        QlType type = parameter.getType();
        if (type == QlType.BOOLEAN) {
            return PsiType.BOOLEAN;
        }
        if (type == QlType.NUMBER) {
            return PsiType.INT;
        }
        if (type == QlType.STRING) {
            return PsiType.getJavaLangString((PsiManager)parameter.getManager(), (GlobalSearchScope)parameter.getResolveScope());
        }
        return null;
    }

    @Nullable
    private static PsiType getAggregateExpressionPsiType(QlAggregateExpression parameter) {
        IElementType type = QlExpressionBaseImpl.getFirstElementType(parameter);
        if (type == QlTypes.QL_COUNT) {
            return QlExpressionBaseImpl.createType(parameter, "java.lang.Long");
        }
        if (type == QlTypes.QL_AVG) {
            return QlExpressionBaseImpl.createType(parameter, "java.lang.Double");
        }
        QlExpression expression = parameter.getExpression();
        PsiType psiType = QlExpressionBaseImpl.getPsiType(expression);
        if (psiType == null || type == QlTypes.QL_MAX || type == QlTypes.QL_MIN) {
            return psiType;
        }
        if (psiType.equalsToText("java.lang.Byte") || psiType.equalsToText("java.lang.Short") || psiType.equalsToText("java.lang.Character") || psiType.equalsToText("java.lang.Integer") || psiType.equalsToText("java.lang.Long") || PsiType.LONG.isAssignableFrom(psiType)) {
            return QlExpressionBaseImpl.createType(parameter, "java.lang.Long");
        }
        if (psiType.equalsToText("java.lang.Float") || psiType.equalsToText("java.lang.Double") || PsiType.DOUBLE.isAssignableFrom(psiType)) {
            return QlExpressionBaseImpl.createType(parameter, "java.lang.Double");
        }
        return psiType;
    }

    private static PsiType createType(PsiElement psiElement, String className) {
        return JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createTypeFromText(className, psiElement);
    }
}

