/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;

public class ManifestPermissionAttributeDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ISSUE = Issue.create("InvalidPermission", "Invalid Permission Attribute", "Not all elements support the permission attribute. If a permission is set on an invalid element, it is a no-op and ignored. Ensure that this permission attribute was set on the correct element to protect the correct component.", Category.SECURITY, 5, Severity.ERROR, new Implementation(ManifestPermissionAttributeDetector.class, Scope.MANIFEST_SCOPE));

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("permission");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        String parent;
        switch (parent = attribute.getOwnerElement().getTagName()) {
            case "activity": 
            case "application": 
            case "provider": 
            case "service": 
            case "receiver": 
            case "activity-alias": 
            case "permission": {
                return;
            }
        }
        String message = "Protecting an unsupported element with a permission is a no-op and potentially dangerous.";
        context.report(ISSUE, attribute, context.getLocation(attribute), message);
    }
}

