/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public class JspxLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final int PREVIEW_RIGHT_MARGIN = 120;

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        return defaultSettings;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/application/options/JspxLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/application/options/JspxLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN"});
            consumer.showStandardOptions(new String[]{"WRAP_ON_TYPING"});
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @NotNull
    public Language getLanguage() {
        JSPXLanguage jSPXLanguage = JSPXLanguage.INSTANCE;
        if (jSPXLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JspxLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return jSPXLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/application/options/JspxLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)this.getSample());
    }

    protected String getSample() {
        return "preview.jspx.template";
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/application/options/JspxLanguageCodeStyleSettingsProvider", "getRightMargin"));
        }
        return 120;
    }
}

