/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.index;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.parsing.jsp.JspLexer2;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.Collections;
import net.n3.nanoxml.IXMLBuilder;

public abstract class JspDirectiveProcessor {
    protected final PsiManager psiManager;
    protected final BaseJspFile originalFile;
    private final boolean isJspx;

    public JspDirectiveProcessor(PsiManager psiManager, boolean jspx) {
        this.psiManager = psiManager;
        this.isJspx = jspx;
        this.originalFile = null;
    }

    public JspDirectiveProcessor(BaseJspFile original) {
        this.originalFile = original;
        this.isJspx = original.getFileType().equals(StdFileTypes.JSPX);
        this.psiManager = original.getManager();
    }

    protected abstract void processDirective(XmlTag var1, JspDirectiveKind var2, int var3);

    public void processDirectives(CharSequence chars) {
        if (this.isJspx) {
            this.processJspx(chars);
        } else {
            this.processJsp(chars);
        }
    }

    private void processJsp(CharSequence chars) {
        IElementType type;
        JspLexer2 lexer = new JspLexer2(Collections.singleton("xml"), false, false);
        lexer.start(chars);
        boolean isInclude = false;
        boolean isFileAttr = false;
        while ((type = lexer.getTokenType()) != null) {
            if (type == BaseJspElementType.JSP_DIRECTIVE) {
                this.processDirective(lexer.getTokenSequence(), lexer.getTokenStart());
            } else if (type == XmlTokenType.XML_NAME) {
                if (isInclude) {
                    isFileAttr = "file".contentEquals(lexer.getTokenSequence());
                } else if ("jsp:directive.include".contentEquals(lexer.getTokenSequence())) {
                    isInclude = true;
                }
            } else if (isFileAttr && type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                this.processDirective("<%@include file=\"" + lexer.getTokenSequence() + "\"%>", lexer.getTokenStart());
                isInclude = false;
                isFileAttr = false;
            } else if (type == XmlTokenType.XML_EMPTY_ELEMENT_END || type == XmlTokenType.XML_TAG_END) {
                isInclude = false;
                isFileAttr = false;
            }
            lexer.advance();
        }
    }

    private void processDirective(CharSequence bufferSequence, int start) {
        DummyHolder dummyHolder = new DummyHolder(this.psiManager, null, BaseJspElementType.JSP_DIRECTIVE.getLanguage());
        if (this.originalFile != null) {
            dummyHolder.setOriginalFile((PsiFile)this.originalFile);
        }
        FileElement holderElement = dummyHolder.getTreeElement();
        JspDirective directive = (JspDirective)BaseJspElementType.JSP_DIRECTIVE.parse(bufferSequence, (CharTable)IdentityCharTable.INSTANCE);
        holderElement.rawAddChildren((TreeElement)directive);
        CodeEditUtil.setNodeGenerated((ASTNode)((TreeElement)directive), (boolean)true);
        JspDirectiveKind directiveKind = BaseJspUtil.getDirectiveKindByTag((XmlTag)directive);
        if (directiveKind != null) {
            this.processDirective((XmlTag)directive, directiveKind, start);
        }
    }

    private void processJspx(CharSequence chars) {
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)chars), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
            final StringBuilder buf = new StringBuilder(50);
            JspDirectiveKind directiveKind;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                if ("http://java.sun.com/JSP/Page".equals(nsURI)) {
                    this.directiveKind = BaseJspUtil.getDirectiveKindByName(name);
                    if (this.directiveKind != null) {
                        this.buf.append("<%@").append(name);
                    }
                }
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (this.directiveKind != null) {
                    this.buf.append(' ').append(key).append("=\"").append(value).append('\"');
                }
            }

            public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                if (this.directiveKind != null) {
                    this.buf.append("%>");
                    JspDirectiveProcessor.this.processDirective(this.buf, 0);
                    this.buf.setLength(0);
                }
            }
        });
    }
}

