/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.jsp.JspFileViewProvider;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.JspxFileViewProviderImpl;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspFileViewProviderImpl
extends JspxFileViewProviderImpl
implements JspFileViewProvider,
ModificationTracker {
    private volatile Set<Language> myLanguages;
    private Set<Language> myFixedLanguages;
    private final CachedValue<PrefixesWithLanguage> myLocalPrefixes;
    private final CachedValue<Language> myTemplateLanguage;
    private final SimpleModificationTracker myContentModificationCount = new SimpleModificationTracker();

    public Set<String> getXmlNsPrefixes(CharSequence buffer) {
        return ((PrefixesWithLanguage)this.myLocalPrefixes.getValue()).getKnownPrefixes();
    }

    public long getModificationCount() {
        return this.myContentModificationCount.getModificationCount();
    }

    JspFileViewProviderImpl(PsiManager manager, VirtualFile virtualFile, boolean isPhysical) {
        super(manager, virtualFile, isPhysical);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)manager.getProject());
        this.myLocalPrefixes = cachedValuesManager.createCachedValue(() -> {
            PrefixesWithLanguage prefixes = JspWithOtherWorldIntegrationService.getInstance().getLocalPrefixes(this, this.getContents());
            return CachedValueProvider.Result.create((Object)prefixes, (Object[])new Object[]{this, this.getVirtualFile()});
        }, false);
        this.myTemplateLanguage = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)this.getKeyPrefixes(null).getTemplateLanguage(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @Override
    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = (Language)ReadAction.compute(() -> (Language)this.myTemplateLanguage.getValue());
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl", "getTemplateDataLanguage"));
        }
        return language;
    }

    @NotNull
    protected PrefixesWithLanguage getKeyPrefixes(@Nullable CharSequence newContent) {
        PrefixesWithLanguage prefixesWithLanguage = newContent == null ? (PrefixesWithLanguage)this.myLocalPrefixes.getValue() : JspWithOtherWorldIntegrationService.getInstance().getLocalPrefixes(this, newContent);
        if (prefixesWithLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl", "getKeyPrefixes"));
        }
        return prefixesWithLanguage;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        NewJspLanguage newJspLanguage = NewJspLanguage.INSTANCE;
        if (newJspLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl", "getBaseLanguage"));
        }
        return newJspLanguage;
    }

    @Override
    protected JspFileViewProviderImpl cloneInner(VirtualFile copy) {
        return new JspFileViewProviderImpl(this.getManager(), copy, false){

            @Override
            @NotNull
            protected PrefixesWithLanguage getKeyPrefixes(CharSequence newContent) {
                PrefixesWithLanguage prefixesWithLanguage = JspFileViewProviderImpl.this.getKeyPrefixes(newContent);
                if (prefixesWithLanguage == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl$1", "getKeyPrefixes"));
                }
                return prefixesWithLanguage;
            }
        };
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Object> languages = this.myFixedLanguages;
        if (languages != null) {
            LinkedHashSet linkedHashSet = languages;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl", "getLanguages"));
            }
            return linkedHashSet;
        }
        languages = this.myLanguages;
        if (languages == null) {
            this.myLanguages = languages = ContainerUtil.newLinkedHashSet((Object[])new Language[]{NewJspLanguage.INSTANCE, this.getTemplateDataLanguage(), JspWithOtherWorldIntegrationService.getJavaLanguage()});
        }
        LinkedHashSet linkedHashSet = languages;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl", "getLanguages"));
        }
        return linkedHashSet;
    }

    public void beforeContentsSynchronized() {
        super.beforeContentsSynchronized();
        this.myFixedLanguages = this.myLanguages;
        this.clearCaches();
    }

    public void clearCaches() {
        this.myLanguages = null;
        this.myContentModificationCount.incModificationCount();
    }

    public void contentsSynchronized() {
        super.contentsSynchronized();
        this.myFixedLanguages = null;
    }

    @Override
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/jsp/JspFileViewProviderImpl", "createFile"));
        }
        PsiFile psiFile = super.createFile(lang);
        if (psiFile == null && lang == this.getTemplateDataLanguage()) {
            return new JspXmlFile((FileViewProvider)this);
        }
        return psiFile;
    }

    public static class PrefixesWithLanguage {
        private final Set<String> myKnownPrefixes = ContainerUtil.newConcurrentSet();
        private Language myTemplateLanguage;

        public PrefixesWithLanguage() {
            this.myKnownPrefixes.add("xml");
        }

        public void setTemplateLanguage(Language templateLanguage) {
            this.myTemplateLanguage = templateLanguage;
        }

        public void addKnownPrefixes(Collection<String> prefixes) {
            this.myKnownPrefixes.addAll(prefixes);
        }

        public Language getTemplateLanguage() {
            return this.isLanguageSet() ? this.myTemplateLanguage : HTMLLanguage.INSTANCE;
        }

        public Set<String> getKnownPrefixes() {
            return this.myKnownPrefixes;
        }

        private boolean isLanguageSet() {
            return this.myTemplateLanguage != null && this.myTemplateLanguage != Language.ANY;
        }
    }
}

