/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.extractTag;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.lang.jsp.extractTag.ExtractJspTagDialog;
import com.intellij.refactoring.lang.jsp.extractTag.ExtractTagHandler;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractJspTagAction
extends AnAction {
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(true);
        DataContext context = e.getDataContext();
        ExtractTagHandler handler = ExtractJspTagAction.getHandler(context);
        if (handler == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setText(handler.getActionName());
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        e.getPresentation().setEnabled(editor != null && editor.getSelectionModel().hasSelection());
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)CommonDataKeys.PSI_FILE.getData(context));
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        assert (jspFile != null);
        Project project = jspFile.getProject();
        String tagName = null;
        String path = ExtractJspTagAction.guessLocation(jspFile, ExtractTagHandler.getHandler(jspFile));
        ExtractJspTagDialog dialog;
        while ((dialog = new ExtractJspTagDialog(jspFile, tagName, path)).showAndGet()) {
            tagName = dialog.getTagName();
            path = dialog.getLocationPath();
            VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (dir == null) {
                if (Messages.showOkCancelDialog((Project)project, (String)(path + " does not exist. Do you want to create it?"), (String)"Directory Not Exist", (Icon)Messages.getQuestionIcon()) == 0) {
                    final String finalPath = path;
                    RunResult result = new WriteCommandAction<VirtualFile>(project, new PsiFile[0]){

                        protected void run(@NotNull Result<VirtualFile> virtualFileResult) throws Throwable {
                            if (virtualFileResult == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileResult", "com/intellij/refactoring/lang/jsp/extractTag/ExtractJspTagAction$1", "run"));
                            }
                            virtualFileResult.setResult((Object)VfsUtil.createDirectoryIfMissing((String)finalPath));
                        }
                    }.execute();
                    if (result.hasException()) {
                        Messages.showErrorDialog((Project)project, (String)result.getThrowable().getMessage(), (String)"Error");
                        continue;
                    }
                    dir = (VirtualFile)result.getResultObject();
                } else {
                    return;
                }
            }
            try {
                ExtractJspTagAction.doCreateTag(jspFile, editor, tagName, dir);
                return;
            }
            catch (IncorrectOperationException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)"Error");
                continue;
            }
            break;
        }
        return;
    }

    public static PsiFile doCreateTag(final BaseJspFile jspFile, final Editor editor, final String tagName, final VirtualFile dir) throws IncorrectOperationException {
        final ExtractTagHandler handler = ExtractTagHandler.getHandler(jspFile);
        assert (handler != null);
        final Project project = jspFile.getProject();
        final PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(dir);
        assert (psiDirectory != null);
        RunResult result = new WriteCommandAction<PsiFile>(project, handler.getActionName(), new PsiFile[]{jspFile}){

            protected void run(@NotNull Result<PsiFile> psiFileResult) throws Throwable {
                if (psiFileResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileResult", "com/intellij/refactoring/lang/jsp/extractTag/ExtractJspTagAction$2", "run"));
                }
                PsiFile tagFile = psiDirectory.createFile(tagName + "." + handler.getTagExtension());
                psiFileResult.setResult((Object)tagFile);
                String tagFileText = handler.getTagFileText(editor, (PsiFile)jspFile);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document doc = documentManager.getDocument(tagFile);
                assert (doc != null);
                doc.replaceString(0, doc.getTextLength(), (CharSequence)(tagFileText == null ? "" : tagFileText));
                String path = dir.getPath() + "/";
                int pos = path.lastIndexOf(handler.getTagFileLocation() + "/");
                String tagdir = path.substring(pos, path.length() - 1);
                String prefix = handler.getExistingPrefix(jspFile, tagdir);
                if (prefix == null) {
                    String[] strings = dir.getPath().split("/");
                    prefix = strings[strings.length - 1];
                    XmlTag rootTag = jspFile.getRootTag();
                    handler.addDeclaration(rootTag, jspFile, prefix, tagdir);
                }
                Document jspDoc = documentManager.getDocument((PsiFile)jspFile);
                assert (jspDoc != null);
                documentManager.doPostponedOperationsAndUnblockDocument(jspDoc);
                int start = editor.getSelectionModel().getSelectionStart();
                int end = editor.getSelectionModel().getSelectionEnd();
                jspDoc.replaceString(start, end, (CharSequence)("<" + prefix + ":" + tagName + "/>"));
                editor.getSelectionModel().removeSelection();
            }
        }.execute();
        if (result.hasException()) {
            result.throwException();
        }
        return (PsiFile)result.getResultObject();
    }

    @Nullable
    private static ExtractTagHandler getHandler(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            return null;
        }
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)file);
        return jspFile == null ? null : ExtractTagHandler.getHandler(jspFile);
    }

    private static String guessLocation(BaseJspFile context, ExtractTagHandler handler) {
        VirtualFile file;
        WebDirectoryElement element;
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
        if (webFacet != null && (element = WebUtil.getWebUtil().findWebDirectoryElement("/", webFacet)) != null && (file = element.getOriginalVirtualFile()) != null) {
            return handler.guessLocation(file);
        }
        VirtualFile file2 = context.getVirtualFile();
        assert (file2 != null);
        return file2.getParent().getPath();
    }
}

