/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.quickfix.RenameVariableFix;
import org.intellij.lang.xpath.xslt.validation.DeclarationChecker;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.NotNull;

public class VariableShadowingInspection
extends XsltInspection {
    @NotNull
    public String getDisplayName() {
        if ("Variable Shadowing" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "getDisplayName"));
        }
        return "Variable Shadowing";
    }

    @NotNull
    public String getShortName() {
        if ("XsltVariableShadowing" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "getShortName"));
        }
        return "XsltVariableShadowing";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "buildVisitor"));
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlTag shadowedVariable;
                XmlAttribute nameAttr = tag.getAttribute("name", null);
                if (nameAttr == null || PsiTreeUtil.hasErrorElements((PsiElement)nameAttr)) {
                    return;
                }
                if (XsltSupport.isVariableOrParam(tag) && (shadowedVariable = DeclarationChecker.getInstance((XmlFile)tag.getContainingFile()).getShadowedVariable(tag)) != null) {
                    String innerKind = XsltSupport.isParam(tag) ? "Parameter" : "Variable";
                    String outerKind = XsltSupport.isParam(shadowedVariable) ? "parameter" : "variable";
                    LocalQuickFix fix1 = new RenameVariableFix(tag, "local").createQuickFix(isOnTheFly);
                    LocalQuickFix fix2 = new RenameVariableFix(shadowedVariable, "outer").createQuickFix(isOnTheFly);
                    XmlAttribute name = tag.getAttribute("name");
                    assert (name != null);
                    PsiElement token = XsltSupport.getAttValueToken(name);
                    assert (token != null);
                    holder.registerProblem(token, innerKind + " '" + name.getValue() + "' shadows " + outerKind, AbstractFix.createFixes(fix1, fix2));
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

