/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPsiUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.xpathView.util.MyPsiUtil");

    private MyPsiUtil() {
    }

    @Nullable
    public static XmlElement findContextNode(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        PsiElement contextNode;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/intellij/plugins/xpathView/util/MyPsiUtil", "findContextNode"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/xpathView/util/MyPsiUtil", "findContextNode"));
        }
        for (contextNode = psiFile.findElementAt(editor.getCaretModel().getOffset()); contextNode != null && !MyPsiUtil.isValidContextNode(contextNode); contextNode = contextNode.getParent()) {
        }
        assert (contextNode == null || contextNode instanceof XmlElement);
        return (XmlElement)contextNode;
    }

    public static boolean isValidContextNode(@Nullable PsiElement contextNode) {
        return contextNode instanceof XmlTag || contextNode instanceof XmlDocument;
    }

    @NotNull
    public static PsiElement getNameElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/plugins/xpathView/util/MyPsiUtil", "getNameElement"));
        }
        PsiElement element = MyPsiUtil.findNameElement(tag);
        if (element != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/util/MyPsiUtil", "getNameElement"));
            }
            return psiElement;
        }
        LOG.error("Name element not found for " + tag);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/util/MyPsiUtil", "getNameElement"));
        }
        return xmlTag;
    }

    @Nullable
    public static PsiElement findNameElement(@NotNull XmlTag tag) {
        PsiElement[] children;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/plugins/xpathView/util/MyPsiUtil", "findNameElement"));
        }
        for (PsiElement child : children = tag.getChildren()) {
            if (!MyPsiUtil.isNameElement(child)) continue;
            return child;
        }
        return null;
    }

    public static boolean isNameElement(@Nullable PsiElement child) {
        if (child != null && child.getParent() instanceof XmlTag) {
            if (child instanceof XmlToken) {
                if (((XmlToken)child).getTokenType() == XmlTokenType.XML_NAME) {
                    return true;
                }
            } else if (child instanceof ASTNode) {
                return ((ASTNode)child).getElementType() == XmlTokenType.XML_NAME;
            }
        }
        return false;
    }

    public static String getAttributePrefix(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/plugins/xpathView/util/MyPsiUtil", "getAttributePrefix"));
        }
        String name = attribute.getName();
        if (name.indexOf(58) == -1) {
            return "";
        }
        return name.substring(0, name.indexOf(58));
    }

    public static boolean isStartTag(PsiElement contextNode) {
        if (contextNode instanceof PsiWhiteSpace) {
            PsiElement sibling;
            for (sibling = contextNode.getPrevSibling(); sibling != null && !MyPsiUtil.isNameElement(sibling); sibling = sibling.getPrevSibling()) {
            }
            return sibling != null;
        }
        if (contextNode instanceof XmlToken) {
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_START_TAG_START) {
                return true;
            }
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_TAG_END) {
                return true;
            }
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndTag(PsiElement contextNode) {
        if (contextNode instanceof PsiWhiteSpace) {
            PsiElement sibling;
            for (sibling = contextNode.getPrevSibling(); sibling != null && !MyPsiUtil.isNameElement(sibling); sibling = sibling.getPrevSibling()) {
            }
            return sibling != null;
        }
        return contextNode instanceof XmlToken && ((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_END_TAG_START;
    }

    public static boolean isInDeclaredNamespace(XmlTag context, String nsUri, String nsPrefix) {
        if (nsUri == null || nsUri.length() == 0 || nsPrefix != null && nsPrefix.length() > 0) {
            return true;
        }
        do {
            if (!context.getLocalNamespaceDeclarations().containsValue(nsUri)) continue;
            return true;
        } while ((context = (XmlTag)(context.getParent() instanceof XmlTag ? context.getParent() : null)) != null);
        return false;
    }

    public static String checkFile(final PsiFile file) {
        final String[] error = new String[1];
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                error[0] = element.getErrorDescription();
            }
        });
        if (error[0] != null) {
            return error[0];
        }
        final Annotator annotator = (Annotator)LanguageAnnotators.INSTANCE.forLanguage(file.getLanguage());
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                annotator.annotate(element, (AnnotationHolder)new AnnotationHolderImpl(new AnnotationSession(file)){

                    public Annotation createErrorAnnotation(@NotNull ASTNode astNode, String string) {
                        if (astNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "org/intellij/plugins/xpathView/util/MyPsiUtil$2$1", "createErrorAnnotation"));
                        }
                        error[0] = string;
                        return super.createErrorAnnotation(astNode, string);
                    }

                    public Annotation createErrorAnnotation(@NotNull PsiElement element, String string) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/xpathView/util/MyPsiUtil$2$1", "createErrorAnnotation"));
                        }
                        error[0] = string;
                        return super.createErrorAnnotation(element, string);
                    }

                    public Annotation createErrorAnnotation(@NotNull TextRange textRange, String string) {
                        if (textRange == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/intellij/plugins/xpathView/util/MyPsiUtil$2$1", "createErrorAnnotation"));
                        }
                        error[0] = string;
                        return super.createErrorAnnotation(textRange, string);
                    }
                });
                super.visitElement(element);
            }
        });
        return error[0];
    }
}

