/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.XmlDuplicatesProfile;
import com.intellij.dupLocator.XmlDuplocatorSettingsEditor;
import com.intellij.dupLocator.XmlDuplocatorState;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.FileBasedCodeFragmentType;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDuplicatesPresentation
implements DuplicatesPresentation {
    private final XmlDuplicatesProfile myProfile;

    public XmlDuplicatesPresentation(XmlDuplicatesProfile xmlDuplicatesProfile) {
        this.myProfile = xmlDuplicatesProfile;
    }

    @Override
    @NotNull
    public DuplicatesProfile getProfile() {
        XmlDuplicatesProfile xmlDuplicatesProfile = this.myProfile;
        if (xmlDuplicatesProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/XmlDuplicatesPresentation", "getProfile"));
        }
        return xmlDuplicatesProfile;
    }

    @Override
    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/XmlDuplicatesPresentation", "getType"));
        }
        return new FileBasedCodeFragmentType(node.getVirtualFile(), node.getProject());
    }

    @Override
    public boolean isFixAbilityProvided() {
        return false;
    }

    @Override
    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/XmlDuplicatesPresentation", "isFixAvailable"));
        }
        return false;
    }

    @Override
    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/XmlDuplicatesPresentation", "applyFix"));
        }
    }

    @Override
    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/XmlDuplicatesPresentation", "createView"));
        }
        BaseDuplicatesView baseDuplicatesView = new BaseDuplicatesView(project);
        if (baseDuplicatesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/XmlDuplicatesPresentation", "createView"));
        }
        return baseDuplicatesView;
    }

    @Override
    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/XmlDuplicatesPresentation", "createEditor"));
        }
        XmlDuplocatorSettingsEditor xmlDuplocatorSettingsEditor = new XmlDuplocatorSettingsEditor((XmlDuplocatorState)state);
        if (xmlDuplocatorSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/XmlDuplicatesPresentation", "createEditor"));
        }
        return xmlDuplocatorSettingsEditor;
    }
}

