/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    private static final Set<String> PRIMITIVE_TYPES = new THashSet(Arrays.asList("short", "boolean", "double", "long", "int", "float", "char", "byte"));

    @Override
    public String getText(PsiElement match, int start, int end) {
        PsiElement parent;
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement && !(parent instanceof PsiExpression)) {
            match = parent;
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @Override
    public Class getElementContextByPsi(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (element instanceof PsiMember) {
            return PsiMember.class;
        }
        return PsiExpression.class;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        String text;
        if (element instanceof PsiNamedElement) {
            text = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text = referenceElement == null ? null : referenceElement.getQualifiedName();
        } else if (element instanceof PsiNameValuePair) {
            text = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text, (char)'@')) {
                text = text.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                text = text.substring(0, text.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text.indexOf(59)) != -1) {
                text = text.substring(0, i);
            }
        }
        if (text == null) {
            text = element.getText();
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getTypedVarString"));
        }
        return string;
    }

    @Override
    public String getMeaningfulText(PsiElement element) {
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text;
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text = referencedElement != null ? referencedElement.getText() : "";
            if (resolve == null && text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return element.getText();
            }
            return text;
        }
        return super.getMeaningfulText(element);
    }

    @Override
    public PsiElement updateCurrentNode(PsiElement targetNode) {
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatements().length == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchedByDownUp(PsiElement targetNode) {
        PsiElement parent;
        if (targetNode instanceof PsiIdentifier && ((parent = (targetNode = targetNode.getParent()).getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement)) {
            targetNode = parent;
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        if (file instanceof PsiIdentifier) {
            file = file.getParent();
        }
        return file;
    }

    @Override
    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiMethodCallExpression) {
                PsiElement psiElement = parent2;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getPresentableElement"));
                }
                return psiElement;
            }
        } else if (element instanceof PsiJavaCodeReferenceElement && ((parent = element.getParent()) instanceof PsiTypeElement || parent instanceof PsiNewExpression || parent instanceof PsiAnnotation)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getPresentableElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getPresentableElement"));
        }
        return psiElement;
    }

    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "compile"));
        }
        elements[0].getParent().accept((PsiElementVisitor)new JavaCompilingVisitor(globalVisitor));
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createMatchingVisitor"));
        }
        JavaMatchingVisitor javaMatchingVisitor = new JavaMatchingVisitor(globalVisitor);
        if (javaMatchingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createMatchingVisitor"));
        }
        return javaMatchingVisitor;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JavaStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getLexicalNodesFilter"));
        }
        return nodeFilter;
    }

    private static boolean isLexicalNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiJavaToken) {
            return !(element instanceof PsiKeyword) || !PRIMITIVE_TYPES.contains(element.getText()) || !(element.getParent() instanceof PsiNewExpression);
        }
        return false;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        JavaCompiledPattern javaCompiledPattern = new JavaCompiledPattern();
        if (javaCompiledPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createCompiledPattern"));
        }
        return javaCompiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "isMyLanguage"));
        }
        return language == JavaLanguage.INSTANCE;
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getReplaceHandler"));
        }
        return new JavaReplaceHandler(context);
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project, boolean physical) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        if (physical) {
            throw new UnsupportedOperationException(this.getClass() + " cannot create physical PSI");
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (context == PatternTreeContext.Block) {
            PsiStatement element = elementFactory.createStatementFromText("{\n" + text + "\n}", null);
            PsiElement[] children = ((PsiBlockStatement)element).getCodeBlock().getChildren();
            int extraChildCount = 4;
            if (children.length > 4) {
                PsiElement[] classPattern;
                PsiElement[] result = new PsiElement[children.length - 4];
                System.arraycopy(children, 2, result, 0, children.length - 4);
                if (JavaStructuralSearchProfile.shouldTryExpressionPattern(result)) {
                    try {
                        PsiElement[] expressionPattern = this.createPatternTree(text, PatternTreeContext.Expression, fileType, language, contextName, extension, project, false);
                        if (expressionPattern.length == 1) {
                            result = expressionPattern;
                        }
                    }
                    catch (IncorrectOperationException expressionPattern) {}
                } else if (JavaStructuralSearchProfile.shouldTryClassPattern(result) && (classPattern = this.createPatternTree(text, PatternTreeContext.Class, fileType, language, contextName, extension, project, false)).length == 1) {
                    result = classPattern;
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
                }
                return result;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context == PatternTreeContext.Class) {
            PsiElement endChild;
            PsiClass clazz = elementFactory.createClassFromText(text, null);
            PsiElement startChild = clazz.getLBrace();
            if (startChild != null) {
                startChild = startChild.getNextSibling();
            }
            if ((endChild = clazz.getRBrace()) != null) {
                endChild = endChild.getPrevSibling();
            }
            if (startChild == endChild) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            PsiCodeBlock codeBlock = elementFactory.createCodeBlock();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(3);
            assert (startChild != null);
            for (PsiElement el = startChild.getNextSibling(); el != endChild && el != null; el = el.getNextSibling()) {
                if (el instanceof PsiErrorElement) continue;
                result.add(codeBlock.add(el));
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Expression) {
            PsiExpression expression = elementFactory.createExpressionFromText(text, null);
            PsiBlockStatement statement = (PsiBlockStatement)elementFactory.createStatementFromText("{\na\n}", null);
            PsiElement[] children = statement.getCodeBlock().getChildren();
            if (children.length != 5) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            PsiExpressionStatement childStatement = (PsiExpressionStatement)children[2];
            childStatement.getExpression().replace((PsiElement)expression);
            PsiElement[] psiElementArray = new PsiElement[]{childStatement};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text).getChildren();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createPatternTree"));
        }
        return psiElementArray;
    }

    private static boolean shouldTryExpressionPattern(PsiElement[] elements) {
        PsiElement lastChild;
        PsiElement firstElement;
        return elements.length >= 1 && elements.length <= 3 && (firstElement = elements[0]) instanceof PsiDeclarationStatement && (lastChild = firstElement.getLastChild()) instanceof PsiErrorElement && PsiTreeUtil.prevLeaf((PsiElement)lastChild) instanceof PsiErrorElement;
    }

    private static boolean shouldTryClassPattern(PsiElement[] elements) {
        if (elements.length < 2) {
            return false;
        }
        PsiElement firstElement = elements[0];
        PsiElement secondElement = elements[1];
        if (firstElement instanceof PsiDocComment) {
            return true;
        }
        if (firstElement instanceof PsiDeclarationStatement && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiErrorElement && secondElement instanceof PsiExpressionStatement && PsiTreeUtil.lastChild((PsiElement)secondElement) instanceof PsiErrorElement) {
            return true;
        }
        return elements.length == 3 && "static".equals(firstElement.getText()) && secondElement instanceof PsiWhiteSpace && elements[2] instanceof PsiBlockStatement;
    }

    @Override
    @NotNull
    public Editor createEditor(@NotNull SearchContext searchContext, @NotNull FileType fileType, Language dialect, String text, boolean useLastConfiguration) {
        Editor selectedEditor;
        if (searchContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchContext", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        PsiFile element = searchContext.getFile();
        if (element != null && !useLastConfiguration && (selectedEditor = FileEditorManager.getInstance((Project)searchContext.getProject()).getSelectedTextEditor()) != null) {
            int caretPosition = selectedEditor.getCaretModel().getOffset();
            PsiElement positionedElement = searchContext.getFile().findElementAt(caretPosition);
            if (positionedElement == null) {
                positionedElement = searchContext.getFile().findElementAt(caretPosition + 1);
            }
            if (positionedElement != null) {
                element = PsiTreeUtil.getParentOfType((PsiElement)positionedElement, (Class[])new Class[]{PsiClass.class, PsiCodeBlock.class});
            }
        }
        PsiManager psimanager = PsiManager.getInstance((Project)searchContext.getProject());
        Project project = psimanager.getProject();
        PsiCodeFragment file = this.createCodeFragment(project, text, (PsiElement)element);
        Document doc = PsiDocumentManager.getInstance((Project)searchContext.getProject()).getDocument((PsiFile)file);
        DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).setHighlightingEnabled((PsiFile)file, false);
        Editor editor = UIUtil.createEditor(doc, searchContext.getProject(), true, true, this.getTemplateContextType());
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "createEditor"));
        }
        return editor;
    }

    @Override
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaCodeContextType.class;
    }

    @Override
    public PsiCodeFragment createCodeFragment(Project project, String text, PsiElement context) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        return factory.createCodeBlockCodeFragment(text, context, true);
    }

    @Override
    public void checkSearchPattern(Project project, MatchOptions options) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(project, options);
        int nodeCount = compiledPattern.getNodeCount();
        NodeIterator nodes = compiledPattern.getNodes();
        while (nodes.hasNext()) {
            PsiElement current = nodes.current();
            visitor.setCurrent(nodeCount == 1 && (current instanceof PsiExpressionStatement || current instanceof PsiDeclarationStatement) ? current : null);
            current.accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        PsiElement[] statements = MatcherImplUtil.createTreeFromText(matchOptions.getSearchPattern(), PatternTreeContext.Block, fileType, project);
        boolean searchIsExpression = statements.length == 1 && statements[0].getLastChild() instanceof PsiErrorElement;
        PsiElement[] statements2 = MatcherImplUtil.createTreeFromText(options.getReplacement(), PatternTreeContext.Block, fileType, project);
        boolean replaceIsExpression = statements2.length == 1 && statements2[0].getLastChild() instanceof PsiErrorElement;
        ValidatingVisitor visitor = new ValidatingVisitor();
        for (PsiElement statement : statements2) {
            visitor.setCurrent(statements.length == 1 && (statement instanceof PsiExpressionStatement || statement instanceof PsiDeclarationStatement) ? statement : null);
            statement.accept((PsiElementVisitor)visitor);
        }
        if (searchIsExpression && statements[0].getFirstChild() instanceof PsiModifierList && statements2.length == 0) {
            return;
        }
        boolean targetFound = false;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (!constraint.isPartOfSearchResults()) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replaceIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message("replacement.template.is.not.expression.error.message", new Object[0]) : SSRBundle.message("search.template.is.not.expression.error.message", new Object[0]));
        }
    }

    @Override
    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return StdFileTypes.JAVA;
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return JavaPredefinedConfigurations.createPredefinedTemplates();
    }

    @Override
    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, final ReplacementBuilder builder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "provideAdditionalReplaceOptions"));
        }
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                String name = parameter.getName();
                String type = parameter.getType().getCanonicalText();
                if (StructuralSearchUtil.isTypedVariable(name)) {
                    name = Replacer.stripTypedVariableDecoration(name);
                    if (StructuralSearchUtil.isTypedVariable(type)) {
                        type = Replacer.stripTypedVariableDecoration(type);
                    }
                    ParameterInfo nameInfo = builder.findParameterization(name);
                    ParameterInfo typeInfo = builder.findParameterization(type);
                    PsiElement scope = parameter.getDeclarationScope();
                    if (nameInfo != null && typeInfo != null && !(scope instanceof PsiCatchSection) && !(scope instanceof PsiForeachStatement)) {
                        nameInfo.setArgumentContext(false);
                        typeInfo.setArgumentContext(false);
                        typeInfo.setMethodParameterContext(true);
                        nameInfo.setMethodParameterContext(true);
                        typeInfo.setElement((PsiElement)parameter.getTypeElement());
                    }
                }
            }
        });
    }

    @Override
    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, int offset, HashMap<String, MatchResult> matchMap) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean forceAddingNewLine = false;
            if (info.isMethodParameterContext()) {
                StringBuilder buf = new StringBuilder();
                JavaStructuralSearchProfile.handleMethodParameter(buf, info, matchMap);
                replacementString = buf.toString();
            } else if (match.hasSons() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                MatchResult previous = null;
                boolean stripSemicolon = false;
                for (MatchResult matchResult : match.getAllSons()) {
                    PsiElement currentElement = matchResult.getMatch();
                    boolean bl = stripSemicolon = !(currentElement instanceof PsiField);
                    if (previous != null) {
                        PsiElement prevSibling;
                        PsiElement parent = currentElement.getParent();
                        if (parent instanceof PsiVariable) {
                            prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)parent, (Class[])new Class[]{PsiWhiteSpace.class});
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            }
                        } else if (info.isStatementContext()) {
                            prevSibling = currentElement.getPrevSibling();
                            if (prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() == previous.getMatch()) {
                                buf.append(prevSibling.getText());
                            } else {
                                buf.append('\n');
                            }
                        } else if (info.isArgumentContext()) {
                            buf.append(',');
                        } else if (parent instanceof PsiClass) {
                            prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)currentElement, (Class[])new Class[]{PsiWhiteSpace.class});
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            } else {
                                buf.append('\n');
                            }
                        } else if (parent instanceof PsiReferenceList) {
                            buf.append(',');
                        } else if (parent instanceof PsiPolyadicExpression) {
                            PsiPolyadicExpression expression = (PsiPolyadicExpression)parent;
                            PsiJavaToken token = expression.getTokenBeforeOperand(expression.getOperands()[1]);
                            if (token != null) {
                                buf.append(token.getText());
                            }
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                    previous = matchResult;
                }
                replacementString = stripSemicolon ? StringUtil.trimEnd((String)buf.toString(), (char)';') : buf.toString();
            } else {
                PsiElement matchElement = match.getMatch();
                if (info.isStatementContext()) {
                    forceAddingNewLine = matchElement instanceof PsiComment;
                }
                String matchImage = match.getMatchImage();
                replacementString = !(matchElement instanceof PsiField) ? StringUtil.trimEnd((String)matchImage, (char)';') : matchImage;
            }
            offset = Replacer.insertSubstitution(result, offset, info, replacementString);
            offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, match);
            if (forceAddingNewLine && info.isStatementContext()) {
                result.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result) {
        PsiElement element = info.getElement();
        PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prevSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() + offset - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex() + offset;
            result.delete(start, end);
            return offset - (end - start);
        }
        PsiElement nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (nextSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            return JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, null);
        }
        return offset;
    }

    private static boolean isRemovableToken(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiVariable)) {
            return false;
        }
        String text = element.getText();
        if (text.length() != 1) {
            return true;
        }
        switch (text.charAt(0)) {
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isIdentifier(PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @Override
    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = Collections.singleton("packageLocal");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/JavaStructuralSearchProfile", "getReservedWords"));
        }
        return set;
    }

    @Override
    public boolean isDocCommentOwner(PsiElement match) {
        return match instanceof PsiMember;
    }

    private static void handleMethodParameter(StringBuilder buf, ParameterInfo info, HashMap<String, MatchResult> matchMap) {
        if (!(info.getElement() instanceof PsiTypeElement)) {
            return;
        }
        String name = ((PsiParameter)info.getElement().getParent()).getName();
        name = StructuralSearchUtil.isTypedVariable(name) ? Replacer.stripTypedVariableDecoration(name) : name;
        MatchResult matchResult = matchMap.get(name);
        if (matchResult == null) {
            return;
        }
        if (matchResult.isMultipleMatch()) {
            for (MatchResult result : matchResult.getAllSons()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                JavaStructuralSearchProfile.appendParameter(buf, result);
            }
        } else {
            JavaStructuralSearchProfile.appendParameter(buf, matchResult);
        }
    }

    private static void appendParameter(StringBuilder buf, MatchResult matchResult) {
        List<MatchResult> sons = matchResult.getAllSons();
        assert (sons.size() == 1);
        buf.append(sons.get(0).getMatchImage()).append(' ').append(matchResult.getMatchImage());
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result, MatchResult match) {
        int index;
        if (info.isStatementContext() && result.charAt(index = offset + info.getStartIndex()) == ';' && (match == null || result.charAt(index - 1) == '}' && !(match.getMatch() instanceof PsiDeclarationStatement) && !(match.getMatch() instanceof PsiNewExpression) || !match.isMultipleMatch() && match.getMatch() instanceof PsiComment || match.isMultipleMatch() && match.getAllSons().get(match.getAllSons().size() - 1).getMatch() instanceof PsiComment)) {
            result.deleteCharAt(index);
            --offset;
        }
        return offset;
    }

    static class ValidatingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myCurrent;

        ValidatingVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                return;
            }
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (value instanceof PsiArrayInitializerMemberValue) {
                    for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                        String name = StringUtil.unquoteString((String)v.getText());
                        ValidatingVisitor.checkModifier(name);
                    }
                    continue;
                }
                if (value == null) continue;
                String name = StringUtil.unquoteString((String)value.getText());
                ValidatingVisitor.checkModifier(name);
            }
        }

        private static void checkModifier(String name) {
            if (!"Instance".equals(name) && !"packageLocal".equals(name) && ArrayUtil.find((Object[])JavaMatchingVisitor.MODIFIERS, (Object)name) < 0) {
                throw new MalformedPatternException(SSRBundle.message("invalid.modifier.type", name));
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            PsiElement parent = element.getParent();
            String errorDescription = element.getErrorDescription();
            if (parent instanceof PsiClass && "Identifier expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof PsiTryStatement && "'catch' or 'finally' expected".equals(errorDescription)) {
                return;
            }
            if (parent == this.myCurrent) {
                if ("';' expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier or type expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier expected".equals(errorDescription)) {
                    return;
                }
            }
            throw new MalformedPatternException(errorDescription);
        }

        void setCurrent(PsiElement current) {
            this.myCurrent = current;
        }
    }
}

