/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import android.support.constraint.solver.widgets.Animator;
import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import java.awt.Color;
import java.awt.Graphics2D;

public class AnimatedColor
extends Animation {
    private final Color mBeginColor;
    private final Color mEndColor;

    public AnimatedColor(Color begin, Color end) {
        this.mBeginColor = begin;
        this.mEndColor = end;
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
    }

    public Color getColor() {
        double progress = this.getProgress();
        double bR = (double)this.mBeginColor.getRed() / 255.0;
        double bG = (double)this.mBeginColor.getGreen() / 255.0;
        double bB = (double)this.mBeginColor.getBlue() / 255.0;
        double bA = (double)this.mBeginColor.getAlpha() / 255.0;
        double eR = (double)this.mEndColor.getRed() / 255.0;
        double eG = (double)this.mEndColor.getGreen() / 255.0;
        double eB = (double)this.mEndColor.getBlue() / 255.0;
        double eA = (double)this.mEndColor.getAlpha() / 255.0;
        bR = Math.pow(bR, 2.2);
        bG = Math.pow(bG, 2.2);
        bB = Math.pow(bB, 2.2);
        eR = Math.pow(eR, 2.2);
        eG = Math.pow(eG, 2.2);
        eB = Math.pow(eB, 2.2);
        double r = Animator.EaseInOutinterpolator((double)progress, (double)bR, (double)eR);
        double g = Animator.EaseInOutinterpolator((double)progress, (double)bG, (double)eG);
        double b = Animator.EaseInOutinterpolator((double)progress, (double)bB, (double)eB);
        double a = Animator.EaseInOutinterpolator((double)progress, (double)bA, (double)eA);
        r = Math.pow(r, 0.45454545454545453);
        g = Math.pow(g, 0.45454545454545453);
        b = Math.pow(b, 0.45454545454545453);
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), (int)(a * 255.0));
    }
}

