/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.drawing.decorator;

import android.support.constraint.solver.widgets.ConstraintTableLayout;
import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.structure.Selection;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;

public class TableDecorator
extends WidgetDecorator {
    private ArrayList<TableClickTarget> mTableClickTargets = new ArrayList();

    public TableDecorator(ConstraintWidget widget) {
        super(widget);
    }

    @Override
    public boolean onPaint(ViewTransform transform, Graphics2D g) {
        boolean needsRepaint = super.onPaint(transform, g);
        if (this.isSelected()) {
            ConstraintTableLayout table = (ConstraintTableLayout)this.mWidget;
            WidgetDraw.drawTableControls(transform, g, table);
        }
        return needsRepaint;
    }

    @Override
    public ConstraintWidget mousePressed(float x, float y, ViewTransform transform, Selection selection) {
        ConstraintTableLayout table = (ConstraintTableLayout)this.mWidget;
        this.mTableClickTargets.clear();
        ArrayList vertical = table.getVerticalGuidelines();
        int l = transform.getSwingX(table.getDrawX());
        int t = transform.getSwingY(table.getDrawY());
        int column = 0;
        TableClickTarget firstTarget = new TableClickTarget(table, column++, l, t - 20 - 4, 20, 20);
        this.mTableClickTargets.add(firstTarget);
        for (ConstraintWidget v : vertical) {
            int bx = transform.getSwingX(v.getX()) + l;
            TableClickTarget target = new TableClickTarget(table, column++, bx, t - 20 - 4, 20, 20);
            this.mTableClickTargets.add(target);
        }
        ConstraintTableLayout widgetHit = null;
        if (this.mTableClickTargets.size() > 0) {
            for (TableClickTarget tableClickTarget : this.mTableClickTargets) {
                if (!tableClickTarget.contains(x, y)) continue;
                widgetHit = tableClickTarget.getTable();
                break;
            }
            if (selection.isEmpty()) {
                this.mTableClickTargets.clear();
            }
        }
        return widgetHit;
    }

    @Override
    public void mouseRelease(int x, int y, ViewTransform transform, Selection selection) {
        for (TableClickTarget target : this.mTableClickTargets) {
            if (!target.contains(x, y)) continue;
            ConstraintTableLayout table = target.getTable();
            int column = target.getColumn();
            table.cycleColumnAlignment(column);
        }
    }

    static class TableClickTarget {
        private Rectangle mBounds = new Rectangle();
        private final ConstraintTableLayout mTable;
        private final int mColumn;

        TableClickTarget(ConstraintTableLayout table, int column, int x, int y, int w, int h) {
            this.mTable = table;
            this.mColumn = column;
            this.mBounds.setBounds(x, y, w, h);
        }

        public boolean contains(float x, float y) {
            return this.mBounds.contains(x, y);
        }

        public ConstraintTableLayout getTable() {
            return this.mTable;
        }

        public int getColumn() {
            return this.mColumn;
        }
    }
}

