/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine;

import java.util.Optional;
import java.util.logging.Logger;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.discovery.VintageDiscoverer;
import org.junit.vintage.engine.execution.RunnerExecutor;

@API(value=API.Usage.Experimental)
public class VintageTestEngine
implements TestEngine {
    private static final Logger LOG = Logger.getLogger(VintageTestEngine.class.getName());

    public String getId() {
        return "junit-vintage";
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.junit.vintage");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("junit-vintage-engine");
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        return new VintageDiscoverer(LOG).discover(discoveryRequest, uniqueId);
    }

    public void execute(ExecutionRequest request) {
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        TestDescriptor engineTestDescriptor = request.getRootTestDescriptor();
        engineExecutionListener.executionStarted(engineTestDescriptor);
        RunnerExecutor runnerExecutor = new RunnerExecutor(engineExecutionListener, LOG);
        this.executeAllChildren(runnerExecutor, engineTestDescriptor);
        engineExecutionListener.executionFinished(engineTestDescriptor, TestExecutionResult.successful());
    }

    private void executeAllChildren(RunnerExecutor runnerExecutor, TestDescriptor engineTestDescriptor) {
        engineTestDescriptor.getChildren().stream().map(RunnerTestDescriptor.class::cast).forEach(runnerExecutor::execute);
    }
}

