/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.velocity.psi.VtlCallable;
import com.intellij.velocity.psi.VtlVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VtlMethod
implements VtlCallable {
    private final PsiMethod myMethod;
    private final VtlVariable[] myParameters;

    public VtlMethod(PsiMethod method) {
        this.myMethod = method;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        this.myParameters = new VtlVariable[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.myParameters[i] = new Parameter(parameters[i]);
        }
    }

    @Override
    public VtlVariable[] getParameters() {
        return this.myParameters;
    }

    @Override
    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    private static class Parameter
    extends FakePsiElement
    implements VtlVariable {
        private final String myName;
        private final PsiParameter myParent;

        public Parameter(@NotNull PsiParameter parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/velocity/psi/reference/VtlMethod$Parameter", "<init>"));
            }
            this.myName = StringUtil.notNullize((String)parent.getName());
            this.myParent = parent;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlMethod$Parameter", "getName"));
            }
            return string;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        @Override
        public PsiType getPsiType() {
            return this.myParent.getType();
        }

        @Override
        @Nullable
        public PsiComment getDocComment() {
            return null;
        }
    }
}

